/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.clipping;

import java.util.List;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.clipping.MultiPolygonClipper;
import org.openstreetmap.atlas.geography.clipping.PolygonClipper;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Clip {
    private static final Logger logger = LoggerFactory.getLogger(Clip.class);
    private final ClipType clipType;
    private final List<? extends PolyLine> clip;
    private final MultiPolygon clipMulti;

    public Clip(ClipType clipType, MultiPolygon subject, MultiPolygon clipping) {
        this.clipType = clipType;
        this.clip = null;
        this.clipMulti = this.clip(subject, clipping);
    }

    public Clip(ClipType clipType, PolyLine subject, MultiPolygon clipping) {
        this.clipType = clipType;
        if (subject instanceof Polygon) {
            this.clipMulti = this.clip((Polygon)subject, clipping);
            this.clip = null;
        } else {
            this.clipMulti = null;
            this.clip = this.clip(subject, clipping);
        }
    }

    public Clip(ClipType clipType, PolyLine subject, Polygon clipping) {
        this.clipType = clipType;
        this.clip = subject instanceof Polygon ? this.clip((Polygon)subject, clipping) : this.clip(subject, clipping);
        this.clipMulti = null;
    }

    public List<? extends PolyLine> getClip() {
        return this.clip;
    }

    public MultiPolygon getClipMultiPolygon() {
        return this.clipMulti;
    }

    public boolean returnsMultiPolygon() {
        return this.clipMulti != null;
    }

    public boolean returnsPolygonOrPolyLineList() {
        return this.clip != null;
    }

    private MultiPolygon clip(MultiPolygon subject, MultiPolygon clipping) {
        switch (this.clipType) {
            case AND: {
                return new MultiPolygonClipper(clipping).and(subject);
            }
            case OR: {
                return new MultiPolygonClipper(clipping).union(subject);
            }
            case NOT: {
                return new MultiPolygonClipper(clipping).not(subject);
            }
            case XOR: {
                return new MultiPolygonClipper(clipping).xor(subject);
            }
        }
        throw new CoreException("Invalid Clip Type.");
    }

    private MultiPolygon clip(Polygon subject, MultiPolygon clipping) {
        switch (this.clipType) {
            case AND: {
                return new MultiPolygonClipper(clipping).and(subject);
            }
            case OR: {
                return new MultiPolygonClipper(clipping).union(subject);
            }
            case NOT: {
                return new MultiPolygonClipper(clipping).not(subject);
            }
            case XOR: {
                return new MultiPolygonClipper(clipping).xor(subject);
            }
        }
        throw new CoreException("Invalid Clip Type.");
    }

    private List<? extends PolyLine> clip(Polygon subject, Polygon clipping) {
        switch (this.clipType) {
            case AND: {
                return this.toPolygons(new PolygonClipper(clipping).and(subject));
            }
            case OR: {
                return this.toPolygons(new PolygonClipper(clipping).union(subject));
            }
            case NOT: {
                return this.toPolygons(new PolygonClipper(clipping).not(subject));
            }
            case XOR: {
                return this.toPolygons(new PolygonClipper(clipping).xor(subject));
            }
        }
        throw new CoreException("Invalid Clip Type.");
    }

    private List<? extends PolyLine> clip(PolyLine subject, MultiPolygon clipping) {
        switch (this.clipType) {
            case AND: {
                return new MultiPolygonClipper(clipping).and(subject);
            }
            case OR: {
                return new MultiPolygonClipper(clipping).union(subject);
            }
            case NOT: {
                return new MultiPolygonClipper(clipping).not(subject);
            }
            case XOR: {
                return new MultiPolygonClipper(clipping).xor(subject);
            }
        }
        throw new CoreException("Invalid Clip Type.");
    }

    private List<? extends PolyLine> clip(PolyLine subject, Polygon clipping) {
        switch (this.clipType) {
            case AND: {
                return new PolygonClipper(clipping).and(subject);
            }
            case OR: {
                return new PolygonClipper(clipping).union(subject);
            }
            case NOT: {
                return new PolygonClipper(clipping).not(subject);
            }
            case XOR: {
                return new PolygonClipper(clipping).xor(subject);
            }
        }
        throw new CoreException("Invalid Clip Type.");
    }

    private List<? extends PolyLine> toPolygons(Iterable<? extends PolyLine> input) {
        Iterable<PolyLine> iterables = Iterables.translate(input, polyLine -> {
            if (polyLine != null && !(polyLine instanceof Polygon)) {
                logger.warn("Something is not a Polygon {} : {}", polyLine.getClass(), polyLine);
            }
            return polyLine instanceof Polygon ? polyLine : null;
        });
        return Iterables.asList(Iterables.filter(iterables, p -> p != null));
    }

    public static enum ClipType {
        AND,
        OR,
        NOT,
        XOR;

    }
}

