/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.boundary;

import com.google.common.base.Strings;
import com.vividsolutions.jts.algorithm.distance.DiscreteHausdorffDistance;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.index.strtree.AbstractNode;
import com.vividsolutions.jts.index.strtree.GeometryItemDistance;
import com.vividsolutions.jts.index.strtree.ItemBoundable;
import com.vividsolutions.jts.index.strtree.ItemDistance;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.precision.GeometryPrecisionReducer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.complex.boundaries.ComplexBoundary;
import org.openstreetmap.atlas.geography.atlas.items.complex.boundaries.ComplexBoundaryFinder;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.RuntimeCounter;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.CountryCodeProperties;
import org.openstreetmap.atlas.geography.boundary.AbstractGridIndexBuilder;
import org.openstreetmap.atlas.geography.boundary.CountryBoundary;
import org.openstreetmap.atlas.geography.boundary.DynamicGridIndexBuilder;
import org.openstreetmap.atlas.geography.boundary.converters.CountryListTwoWayStringConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsMultiPolygonConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsMultiPolygonToMultiPolygonConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPointConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPolyLineConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPrecisionManager;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.tags.SyntheticNearestNeighborCountryCodeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.maps.MultiMap;
import org.openstreetmap.atlas.utilities.scalars.Distance;
import org.openstreetmap.atlas.utilities.scalars.Duration;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountryBoundaryMap
implements Serializable {
    private static final long serialVersionUID = -1714710346834527699L;
    private static final Logger logger = LoggerFactory.getLogger(CountryBoundaryMap.class);
    private static final String ISO_COUNTRY = "ISO_COUNTR";
    private static final String COUNTRY_CODE = "cntry_code";
    private static final List<String> COUNTRY_CODE_FIELDS = Arrays.asList("ISO_COUNTR", "cntry_code");
    private static final String GEOMETRY_FIELD = "the_geom";
    static final String COUNTRY_BOUNDARY_DELIMITER = "||";
    private static final String LIST_SEPARATOR = "#";
    private static final String GRID_ENVELOPE_DELIMITER = "::";
    private static final String GRID_INDEX_DELIMITER = ";;";
    private static final int GRID_INDEX_MIN_LENGTH = 3;
    private static final int GRID_INDEX_FIRST_CELL_INDEX = 2;
    private static final String POLYGON_ID_KEY = "pid";
    private static final String SPATIAL_INDEX_DELIMITER = "--";
    private static final double LINE_BUFFER = 1.0E-6;
    private static final double AREA_BUFFER = 1.0E-9;
    private static final double MAX_AREA_FOR_NEAREST_NEIGHBOR = 100.0;
    private static final double ANTIMERIDIAN = 180.0;
    private static final int MAXIMUM_EXPECTED_COUNTRIES_TO_SLICE_WITH = 3;
    private static final int DEFAULT_MAXIMUM_POLYGONS_TO_SLICE_WITH = 2000;
    private static final int EXPANDED_MAXIMUM_POLYGONS_TO_SLICE_WITH = 25000;
    private static final JtsMultiPolygonConverter JTS_MULTI_POLYGON_TO_POLYGON_CONVERTER = new JtsMultiPolygonConverter();
    private static final JtsPolyLineConverter JTS_POLYLINE_CONVERTER = new JtsPolyLineConverter();
    private static final JtsMultiPolygonToMultiPolygonConverter JTS_MULTI_POLYGON_TO_MULTI_POLYGON_CONVERTER = new JtsMultiPolygonToMultiPolygonConverter();
    private static final JtsPointConverter JTS_POINT_CONVERTER = new JtsPointConverter();
    private static final WKTWriter WKT_WRITER = new WKTWriter();
    private final Envelope envelope;
    private Envelope gridIndexEnvelope;
    private final MultiMap<String, com.vividsolutions.jts.geom.Polygon> countryNameToBoundaryMap;
    private final STRtree rawIndex;
    private STRtree gridIndex;
    private boolean useExpandedPolygonLimit = true;
    private transient Predicate<Taggable> shouldAlwaysSlicePredicate = taggable -> false;
    private transient GeometryPrecisionReducer reducer;
    private final CountryListTwoWayStringConverter countryListConverter = new CountryListTwoWayStringConverter();

    static void collectCells(AbstractNode node, MultiMap<Geometry, Envelope> cells) {
        if (node.getLevel() > 0) {
            node.getChildBoundables().stream().forEach(childNode -> CountryBoundaryMap.collectCells((AbstractNode)childNode, cells));
        } else if (node.getLevel() == 0) {
            node.getChildBoundables().stream().forEach(item -> {
                ItemBoundable boundable = (ItemBoundable)item;
                Geometry polygon = (Geometry)boundable.getItem();
                Envelope bounds = (Envelope)boundable.getBounds();
                cells.add(polygon, bounds);
            });
        }
    }

    public static Set<String> countryCodesIn(List<? extends Geometry> countryGeometries) {
        return countryGeometries.stream().map(geometry -> CountryBoundaryMap.getGeometryProperty(geometry, "iso_country_code")).collect(Collectors.toSet());
    }

    public static CountryBoundaryMap fromAtlas(Atlas atlas) {
        CountryBoundaryMap map = new CountryBoundaryMap();
        map.readFromAtlas(atlas);
        return map;
    }

    public static CountryBoundaryMap fromBoundaryMap(Map<String, MultiPolygon> boundaries) {
        CountryBoundaryMap map = new CountryBoundaryMap(Rectangle.MAXIMUM);
        boundaries.forEach((name, multiPolygon) -> map.addCountry((String)name, JTS_MULTI_POLYGON_TO_MULTI_POLYGON_CONVERTER.backwardConvert((MultiPolygon)multiPolygon)));
        return map;
    }

    public static CountryBoundaryMap fromPlainText(Resource resource) {
        CountryBoundaryMap map = new CountryBoundaryMap();
        map.readFromPlainText(resource);
        return map;
    }

    public static CountryBoundaryMap fromShapeFile(File file) {
        CountryBoundaryMap map = new CountryBoundaryMap();
        map.readFromShapeFile(file);
        return map;
    }

    public static Map<String, String> getGeometryProperties(Geometry geometry) {
        HashMap<String, String> result = new HashMap<String, String>();
        Map propertyMap = (Map)geometry.getUserData();
        if (propertyMap != null) {
            result.putAll(propertyMap);
        }
        return result;
    }

    public static String getGeometryProperty(Geometry geometry, String key) {
        return CountryBoundaryMap.getGeometryProperties(geometry).get(key);
    }

    public static boolean isSameCountry(List<? extends Geometry> countryGeometries) {
        return CountryBoundaryMap.numberCountries(countryGeometries) == 1L;
    }

    public static long numberCountries(List<? extends Geometry> countryGeometries) {
        if (countryGeometries.isEmpty()) {
            return 0L;
        }
        if (countryGeometries.size() == 1) {
            return 1L;
        }
        return CountryBoundaryMap.countryCodesIn(countryGeometries).size();
    }

    public static void setGeometryProperty(Geometry geometry, String key, String value) {
        Map propertyMap = (Map)geometry.getUserData();
        if (propertyMap == null) {
            HashMap<String, String> newPropertyMap = new HashMap<String, String>();
            newPropertyMap.put(key, value);
            geometry.setUserData(newPropertyMap);
        } else {
            String existingValue = (String)propertyMap.get(key);
            if (existingValue == null) {
                propertyMap.put(key, value);
                geometry.setUserData(propertyMap);
            } else if (!Objects.equals(existingValue, value)) {
                logger.error("Trying to override existing '{}' key's value of '{}' with '{}' for geometry {}", new Object[]{key, existingValue, value, geometry.toString()});
            }
        }
    }

    private static Stream<Geometry> geometries(GeometryCollection collection) {
        return IntStream.range(0, collection.getNumGeometries()).mapToObj(index -> collection.getGeometryN(index));
    }

    public CountryBoundaryMap() {
        this(Rectangle.MAXIMUM);
    }

    public CountryBoundaryMap(Rectangle bounds) {
        this.envelope = bounds.asEnvelope();
        this.countryNameToBoundaryMap = new MultiMap();
        this.rawIndex = new STRtree();
        this.gridIndex = null;
        this.reducer = new GeometryPrecisionReducer(JtsPrecisionManager.getPrecisionModel());
        this.reducer.setPointwise(true);
        this.reducer.setChangePrecisionModel(true);
    }

    void addCountry(String country, com.vividsolutions.jts.geom.MultiPolygon multiPolygon) {
        if (!this.envelope.intersects(multiPolygon.getEnvelopeInternal())) {
            return;
        }
        Geometry fixedPolygon = this.reducer.reduce(multiPolygon);
        if (fixedPolygon instanceof com.vividsolutions.jts.geom.Polygon) {
            fixedPolygon = new com.vividsolutions.jts.geom.MultiPolygon(new com.vividsolutions.jts.geom.Polygon[]{(com.vividsolutions.jts.geom.Polygon)fixedPolygon}, JtsPrecisionManager.getGeometryFactory());
        }
        List parts = CountryBoundaryMap.geometries((com.vividsolutions.jts.geom.MultiPolygon)fixedPolygon).collect(Collectors.toList());
        int polygonIdentifier = -1;
        for (Geometry part : parts) {
            ++polygonIdentifier;
            com.vividsolutions.jts.geom.Polygon polygon = (com.vividsolutions.jts.geom.Polygon)part;
            this.countryNameToBoundaryMap.add(country, polygon);
            if (!this.envelope.intersects(polygon.getEnvelopeInternal())) continue;
            CountryBoundaryMap.setGeometryProperty(polygon, "iso_country_code", country);
            CountryBoundaryMap.setGeometryProperty(polygon, POLYGON_ID_KEY, String.valueOf(polygonIdentifier));
            this.rawIndex.insert(polygon.getEnvelopeInternal(), (Object)polygon);
        }
    }

    MultiMap<Geometry, Envelope> getCells() {
        if (this.gridIndex == null) {
            return null;
        }
        MultiMap<Geometry, Envelope> polygonToCells = new MultiMap<Geometry, Envelope>();
        CountryBoundaryMap.collectCells(this.gridIndex.getRoot(), polygonToCells);
        return polygonToCells;
    }

    STRtree getGridIndex() {
        return this.gridIndex;
    }

    STRtree getRawIndex() {
        return this.rawIndex;
    }

    void readFromAtlas(Atlas atlas) {
        for (ComplexBoundary complexBoundary : new ComplexBoundaryFinder().find(atlas)) {
            if (!complexBoundary.hasCountryCode()) continue;
            ArrayList countryCodes = new ArrayList();
            try {
                MultiPolygon outline = complexBoundary.getOutline();
                com.vividsolutions.jts.geom.MultiPolygon multiPolygon = JTS_MULTI_POLYGON_TO_MULTI_POLYGON_CONVERTER.backwardConvert(outline);
                complexBoundary.getCountries().forEach(isoCountry -> this.addCountry(isoCountry.getIso3CountryCode(), multiPolygon));
            }
            catch (IllegalArgumentException e) {
                throw new CoreException("Unable to read country boundary for country codes {}", countryCodes, e);
            }
        }
    }

    void readFromPlainText(Resource resource) {
        HashMap<String, Integer> countryIdentifierMap = new HashMap<String, Integer>();
        WKTReader reader = new WKTReader();
        STRtree gridIndexFromFile = null;
        for (String line : resource.lines()) {
            if (line.isEmpty()) continue;
            if (line.startsWith(SPATIAL_INDEX_DELIMITER)) {
                logger.warn("Found previous version of grid index. Grid index will be ignored.");
                continue;
            }
            if (line.startsWith(GRID_INDEX_DELIMITER)) {
                String[] gridIndexParts;
                int length;
                if (this.countryNameToBoundaryMap.isEmpty()) {
                    logger.warn("Cannot read grid index, because no country boundary is supplied.");
                }
                if (gridIndexFromFile == null) {
                    gridIndexFromFile = new STRtree();
                }
                if ((length = (gridIndexParts = line.substring(GRID_INDEX_DELIMITER.length()).split(GRID_INDEX_DELIMITER)).length) < 3) {
                    throw new CoreException("Grid index entry is malformed.");
                }
                String country = gridIndexParts[0];
                String identifier = gridIndexParts[1];
                Geometry polygon = (Geometry)this.countryNameToBoundaryMap.get(country).get(Integer.valueOf(identifier));
                if (polygon == null) {
                    throw new CoreException("Grid index entry is malformed missing polygon.");
                }
                try {
                    for (int index = 2; index < length; ++index) {
                        String cellWkt = gridIndexParts[index];
                        if (Strings.isNullOrEmpty(cellWkt)) continue;
                        Geometry cell = reader.read(cellWkt);
                        gridIndexFromFile.insert(cell.getEnvelopeInternal(), (Object)polygon);
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new CoreException("Failed to create grid index cells.", e);
                }
            }
            if (line.startsWith(GRID_ENVELOPE_DELIMITER)) {
                try {
                    Geometry envelope = reader.read(line.substring(GRID_ENVELOPE_DELIMITER.length()));
                    this.gridIndexEnvelope = envelope.getEnvelopeInternal();
                    continue;
                }
                catch (ParseException e) {
                    throw new CoreException("Failed to read grid index envelope.", e);
                }
            }
            StringTokenizer boundaryTokenizer = new StringTokenizer(line, COUNTRY_BOUNDARY_DELIMITER);
            String country = boundaryTokenizer.nextToken();
            String geometryString = boundaryTokenizer.nextToken();
            try {
                StringTokenizer geometryTokenizer = new StringTokenizer(geometryString, LIST_SEPARATOR);
                while (geometryTokenizer.hasMoreTokens()) {
                    String polygonString = geometryTokenizer.nextToken();
                    Geometry geometry = reader.read(polygonString);
                    CountryBoundaryMap.setGeometryProperty(geometry, "iso_country_code", country);
                    if (geometry instanceof com.vividsolutions.jts.geom.Polygon) {
                        Integer identifier = (Integer)countryIdentifierMap.get(country);
                        if (identifier == null) {
                            countryIdentifierMap.put(country, 0);
                            CountryBoundaryMap.setGeometryProperty(geometry, POLYGON_ID_KEY, String.valueOf(0));
                        } else {
                            countryIdentifierMap.put(country, identifier + 1);
                            CountryBoundaryMap.setGeometryProperty(geometry, POLYGON_ID_KEY, String.valueOf(identifier + 1));
                        }
                        this.addCountry(country, (com.vividsolutions.jts.geom.Polygon)geometry);
                        continue;
                    }
                    if (!(geometry instanceof com.vividsolutions.jts.geom.MultiPolygon)) continue;
                    this.addCountry(country, (com.vividsolutions.jts.geom.MultiPolygon)geometry);
                }
            }
            catch (Exception e) {
                throw new CoreException("Invalid country boundary text file format.", e);
            }
        }
        if (gridIndexFromFile != null) {
            logger.info("Successfully read grid index of size {} from file.", (Object)gridIndexFromFile.size());
            gridIndexFromFile.build();
            this.gridIndex = gridIndexFromFile;
        } else {
            logger.warn("Given boundary file didn't have grid index.");
        }
    }

    void readFromShapeFile(File file) {
        FileDataStore store = null;
        FeatureIterator iterator = null;
        try {
            store = FileDataStoreFinder.getDataStore(file);
            iterator = store.getFeatureSource().getFeatures().features();
            while (iterator.hasNext()) {
                Object feature = iterator.next();
                Optional<Property> name = this.findCountryName((Feature)feature, COUNTRY_CODE_FIELDS);
                Property geometry = feature.getProperty(GEOMETRY_FIELD);
                String nameValue = (String)name.orElseThrow(() -> new CoreException("Can't read country code attribute from shape file")).getValue();
                com.vividsolutions.jts.geom.MultiPolygon multiPolygon = (com.vividsolutions.jts.geom.MultiPolygon)geometry.getValue();
                this.addCountry(nameValue, multiPolygon);
            }
        }
        catch (IOException e) {
            throw new CoreException("Error reading country boundary from file", e);
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
            if (store != null) {
                store.dispose();
            }
        }
    }

    public List<String> allCountryNames() {
        return this.boundaries(Rectangle.MAXIMUM).stream().map(CountryBoundary::getCountryName).collect(Collectors.toList());
    }

    public List<CountryBoundary> boundaries(Location location) {
        return this.boundariesHelper(() -> this.query(location.bounds().asEnvelope()), boundary -> boundary.covers(JTS_POINT_CONVERTER.convert(location)));
    }

    public List<CountryBoundary> boundaries(Location location, Distance extension) {
        return this.boundaries(location.boxAround(extension));
    }

    public List<CountryBoundary> boundaries(PolyLine polyLine) {
        return this.boundariesHelper(() -> this.query(polyLine.bounds().asEnvelope()), boundary -> boundary.intersects(JTS_POLYLINE_CONVERTER.convert(polyLine)));
    }

    public List<CountryBoundary> boundaries(PolyLine polyLine, Distance extension) {
        return this.boundariesHelper(() -> this.query(polyLine.bounds().expand(extension).asEnvelope()), boundary -> boundary.intersects(JTS_POLYLINE_CONVERTER.convert(polyLine)));
    }

    public List<CountryBoundary> boundaries(Rectangle bound) {
        return this.boundariesHelper(() -> this.query(bound.asEnvelope(), true), polygon -> true);
    }

    public List<LineString> clipBoundary(long identifier, com.vividsolutions.jts.geom.Polygon geometry) throws TopologyException {
        if (Objects.isNull(geometry)) {
            return null;
        }
        com.vividsolutions.jts.geom.Polygon target = geometry;
        ArrayList<LineString> results = new ArrayList<LineString>();
        List<com.vividsolutions.jts.geom.Polygon> polygons = this.query(target.getEnvelopeInternal());
        if (CountryBoundaryMap.isSameCountry(polygons)) {
            return results;
        }
        boolean isWarned = false;
        for (com.vividsolutions.jts.geom.Polygon polygon : polygons) {
            IntersectionMatrix matrix;
            try {
                matrix = target.relate(polygon);
            }
            catch (Exception e) {
                if (!isWarned) {
                    logger.warn("Error slicing feature: {}, {}", (Object)identifier, (Object)e.getMessage());
                }
                isWarned = true;
                continue;
            }
            if (matrix.isWithin()) {
                return results;
            }
            if (!matrix.isIntersects()) continue;
            Geometry clipped = target.intersection(polygon.getBoundary());
            String containedCountryCode = CountryBoundaryMap.getGeometryProperty(polygon, "iso_country_code");
            if (clipped instanceof GeometryCollection) {
                GeometryCollection collection = (GeometryCollection)clipped;
                CountryBoundaryMap.geometries(collection).forEach(point -> {
                    CountryBoundaryMap.setGeometryProperty(point, "iso_country_code", containedCountryCode);
                    results.add((LineString)point);
                });
                continue;
            }
            if (clipped instanceof LineString) {
                CountryBoundaryMap.setGeometryProperty(clipped, "iso_country_code", containedCountryCode);
                results.add((LineString)clipped);
                continue;
            }
            throw new CoreException("Unexpected geometry {} encountered during country slicing.", clipped);
        }
        return results;
    }

    public List<CountryBoundary> countryBoundary(String countryName) {
        Object geometries = this.countryNameToBoundaryMap.get(countryName);
        if (geometries == null || geometries.isEmpty()) {
            return null;
        }
        ArrayList<CountryBoundary> boundaries = new ArrayList<CountryBoundary>();
        boundaries.add(new CountryBoundary(countryName, JTS_MULTI_POLYGON_TO_POLYGON_CONVERTER.backwardConvert(geometries.stream().collect(Collectors.toSet()))));
        return boundaries;
    }

    public StringList countryCodesOverlappingWith(Rectangle bound) {
        return new StringList(this.query(bound.asEnvelope(), true).stream().map(polygon -> CountryBoundaryMap.getGeometryProperty(polygon, "iso_country_code")).collect(Collectors.toList()));
    }

    public void expandPolygonSliceLimit(boolean value) {
        this.useExpandedPolygonLimit = value;
    }

    public CountryCodeProperties getCountryCodeISO3(Geometry geometry) {
        return this.getCountryCodeISO3(geometry, false, 1.0E-6);
    }

    public CountryCodeProperties getCountryCodeISO3(Geometry geometry, boolean fastMode) {
        return this.getCountryCodeISO3(geometry, fastMode, 1.0E-6);
    }

    public CountryCodeProperties getCountryCodeISO3(Geometry geometry, boolean fastMode, double buffer) {
        Geometry target;
        StringList countryList = new StringList();
        if (geometry.getDimension() == 0) {
            Envelope envelope = geometry.getEnvelopeInternal();
            envelope.expandBy(buffer);
            target = geometry.getFactory().toGeometry(envelope);
        } else {
            target = geometry.buffer(buffer);
        }
        List polygons = this.query(target.getEnvelopeInternal()).stream().filter(polygon -> polygon.intersects(target)).collect(Collectors.toList());
        boolean usingNearestNeighbor = false;
        if (polygons.size() == 1 || CountryBoundaryMap.isSameCountry(polygons)) {
            countryList.add(CountryBoundaryMap.getGeometryProperty((Geometry)polygons.get(0), "iso_country_code"));
        } else {
            try {
                if (fastMode) {
                    Optional<String> match = polygons.stream().filter(polygon -> polygon.intersects(target)).map(polygon -> CountryBoundaryMap.getGeometryProperty(polygon, "iso_country_code")).findFirst();
                    match.ifPresent(countryList::add);
                } else {
                    countryList = new StringList(polygons.stream().filter(polygon -> polygon.intersects(target)).map(polygon -> CountryBoundaryMap.getGeometryProperty(polygon, "iso_country_code")).collect(Collectors.toList()));
                }
                if (countryList.isEmpty()) {
                    Geometry nearestGeometry = this.nearestNeighbour(target.getEnvelopeInternal(), target, new GeometryItemDistance());
                    if (nearestGeometry != null) {
                        usingNearestNeighbor = true;
                        String nearestCountryCode = CountryBoundaryMap.getGeometryProperty(nearestGeometry, "iso_country_code");
                        countryList.add(nearestCountryCode);
                    } else {
                        countryList.add("N/A");
                    }
                }
            }
            catch (Exception e) {
                logger.warn("There was exception when trying to find out country code for geometry {}, {}", (Object)geometry, (Object)e.getMessage());
                countryList.add("N/A");
            }
        }
        return new CountryCodeProperties(this.countryListConverter.backwardConvert(countryList), usingNearestNeighbor);
    }

    public CountryCodeProperties getCountryCodeISO3(Location location) {
        return this.getCountryCodeISO3(JTS_POINT_CONVERTER.convert(location));
    }

    public Set<String> getLoadedCountries() {
        return this.countryNameToBoundaryMap.keySet();
    }

    public boolean hasGridIndex() {
        return this.gridIndex != null;
    }

    public synchronized void initializeGridIndex(com.vividsolutions.jts.geom.MultiPolygon area) {
        if (Objects.isNull(area)) {
            logger.error("Given area is null. Skipping grid index initialization.");
            return;
        }
        this.gridIndexEnvelope = area.getEnvelopeInternal();
        List boundaries = this.rawIndex.query(this.gridIndexEnvelope);
        DynamicGridIndexBuilder builder = new DynamicGridIndexBuilder(boundaries, this.gridIndexEnvelope, this.rawIndex);
        this.gridIndex = builder.getIndex();
        logger.info("Grid index of size {} created.", (Object)this.gridIndex.size());
    }

    public void initializeGridIndex(Set<String> countries) {
        logger.info("Building grid index for {}.", countries);
        MultiPolygon multiPolygon = new MultiPolygon(new MultiMap<Polygon, Polygon>());
        for (String countryCode : countries) {
            List<CountryBoundary> boundaries = this.countryBoundary(countryCode);
            if (boundaries == null) continue;
            for (CountryBoundary boundary : boundaries) {
                multiPolygon = multiPolygon.concatenate(boundary.getBoundary());
            }
        }
        com.vividsolutions.jts.geom.MultiPolygon area = JTS_MULTI_POLYGON_TO_MULTI_POLYGON_CONVERTER.backwardConvert(multiPolygon);
        this.initializeGridIndex(area);
        HashSet<String> countriesWithoutGrids = new HashSet<String>(countries);
        this.getCells().keySet().forEach(geometry -> countriesWithoutGrids.remove(CountryBoundaryMap.getGeometryProperty(geometry, "iso_country_code")));
        if (!countriesWithoutGrids.isEmpty()) {
            throw new CoreException("Countries {} didn't have any grid index generated for them. Please check the input used for boundary generation.", countriesWithoutGrids);
        }
    }

    public void setShouldAlwaysSlicePredicate(Predicate<Taggable> shouldAlwaysSlicePredicate) {
        this.shouldAlwaysSlicePredicate = shouldAlwaysSlicePredicate;
    }

    public boolean shouldForceSlicing(Taggable ... source) {
        return source != null && source.length > 0 && this.shouldAlwaysSlicePredicate != null && this.shouldAlwaysSlicePredicate.test(source[0]);
    }

    public boolean shouldSkipSlicing(List<com.vividsolutions.jts.geom.Polygon> candidates, Taggable ... source) {
        return CountryBoundaryMap.isSameCountry(candidates) && !this.shouldForceSlicing(source);
    }

    public int size() {
        return this.countryNameToBoundaryMap.size();
    }

    public List<Geometry> slice(long identifier, Geometry geometry, Taggable ... source) throws TopologyException {
        Geometry nearestGeometry;
        if (Objects.isNull(geometry)) {
            return null;
        }
        Geometry target = geometry;
        ArrayList<Geometry> results = new ArrayList<Geometry>();
        List<com.vividsolutions.jts.geom.Polygon> candidates = this.query(target.getEnvelopeInternal());
        if (this.shouldSkipSlicing(candidates, source)) {
            String countryCode = CountryBoundaryMap.getGeometryProperty(candidates.get(0), "iso_country_code");
            CountryBoundaryMap.setGeometryProperty(target, "iso_country_code", countryCode);
            this.addResult(target, results);
            return results;
        }
        candidates = candidates.stream().distinct().collect(Collectors.toList());
        long numberCountries = CountryBoundaryMap.numberCountries(candidates);
        if (candidates.size() > this.getPolygonSliceLimit()) {
            RuntimeCounter.waySkipped(identifier);
            logger.warn("Skipping slicing way {} due to too many intersecting polygons [{}]", (Object)identifier, (Object)candidates.size());
            return null;
        }
        RuntimeCounter.geometryChecked();
        boolean fullyMatched = false;
        boolean isWarned = false;
        Time time = Time.now();
        if (numberCountries > 3L) {
            logger.warn("Slicing way {} with {} countries.", (Object)identifier, (Object)numberCountries);
            if (logger.isTraceEnabled()) {
                Map<String, List<com.vividsolutions.jts.geom.Polygon>> countries = candidates.stream().collect(Collectors.groupingBy(polygon -> CountryBoundaryMap.getGeometryProperty(polygon, "iso_country_code")));
                countries.forEach((key, value) -> logger.trace("{} : {}", key, (Object)value.size()));
            }
        }
        Iterator<com.vividsolutions.jts.geom.Polygon> candidateIterator = candidates.iterator();
        while (candidateIterator.hasNext()) {
            IntersectionMatrix matrix;
            com.vividsolutions.jts.geom.Polygon candidate = candidateIterator.next();
            String countryCode = CountryBoundaryMap.getGeometryProperty(candidate, "iso_country_code");
            if (Strings.isNullOrEmpty(countryCode)) {
                logger.warn("Ignoring a candidate polygon from slicing, because it is missing country tag.");
                continue;
            }
            try {
                matrix = target.relate(candidate);
            }
            catch (Exception e) {
                if (!isWarned) {
                    logger.warn("error slicing way: {}, {}", (Object)identifier, (Object)e.getMessage());
                }
                isWarned = true;
                continue;
            }
            if (matrix.isWithin()) {
                RuntimeCounter.geometryCheckedWithin();
                CountryBoundaryMap.setGeometryProperty(target, "iso_country_code", countryCode);
                this.addResult(target, results);
                fullyMatched = true;
                return results;
            }
            if (matrix.isIntersects()) continue;
            RuntimeCounter.geometryCheckedNoIntersect();
            candidateIterator.remove();
        }
        if (this.shouldSkipSlicing(candidates, source)) {
            String countryCode = CountryBoundaryMap.getGeometryProperty(candidates.get(0), "iso_country_code");
            CountryBoundaryMap.setGeometryProperty(target, "iso_country_code", countryCode);
            this.addResult(target, results);
            return results;
        }
        Collections.sort(candidates, (first, second) -> {
            int countryCodeComparison = CountryBoundaryMap.getGeometryProperty(first, "iso_country_code").compareTo(CountryBoundaryMap.getGeometryProperty(second, "iso_country_code"));
            if (countryCodeComparison != 0) {
                return countryCodeComparison;
            }
            return first.compareTo(second);
        });
        for (com.vividsolutions.jts.geom.Polygon candidate : candidates) {
            RuntimeCounter.geometryCheckedIntersect();
            Geometry clipped = target.intersection(candidate);
            if (clipped.getNumPoints() < 2) continue;
            String countryCode = CountryBoundaryMap.getGeometryProperty(candidate, "iso_country_code");
            CountryBoundaryMap.setGeometryProperty(clipped, "iso_country_code", countryCode);
            this.addResult(clipped, results);
            target = target.difference(candidate);
            if (target.getDimension() != 1 || !(target.getLength() < 1.0E-6)) {
                if (target.getDimension() != 2 || !(target.getArea() < 1.0E-9)) continue;
                DiscreteHausdorffDistance discreteHausdorffDistance = new DiscreteHausdorffDistance(target, candidate);
                if (!(discreteHausdorffDistance.orientedDistance() < 1.0E-6)) continue;
            }
            fullyMatched = true;
            break;
        }
        if (!fullyMatched && (nearestGeometry = this.nearestNeighbour(target.getEnvelopeInternal(), target, new GeometryItemDistance())) != null) {
            String nearestCountryCode = CountryBoundaryMap.getGeometryProperty(nearestGeometry, "iso_country_code");
            CountryBoundaryMap.setGeometryProperty(target, "iso_country_code", nearestCountryCode);
            CountryBoundaryMap.setGeometryProperty(target, "nearest_neighbor_country_code", SyntheticNearestNeighborCountryCodeTag.YES.toString());
            this.addResult(target, results);
        }
        if (logger.isDebugEnabled() && time.untilNow().isMoreThan(Duration.ONE_MINUTE)) {
            logger.debug("Took {} to slice way {}", (Object)time.untilNow(), (Object)identifier);
        }
        return results;
    }

    public void writeToFile(WritableResource resource) throws IOException {
        try (BufferedWriter output = new BufferedWriter(new OutputStreamWriter(resource.write(), StandardCharsets.UTF_8));){
            this.writeCountryBoundaries(output);
            this.writeGridIndex(output);
        }
    }

    private void addCountry(String country, com.vividsolutions.jts.geom.Polygon polygon) {
        this.countryNameToBoundaryMap.add(country, polygon);
        if (this.envelope.intersects(polygon.getEnvelopeInternal())) {
            this.rawIndex.insert(polygon.getEnvelopeInternal(), (Object)polygon);
        }
    }

    private void addResult(Geometry geometry, List<Geometry> results) {
        if (geometry instanceof GeometryCollection) {
            GeometryCollection collection = (GeometryCollection)geometry;
            CountryBoundaryMap.geometries(collection).forEach(part -> {
                CountryBoundaryMap.getGeometryProperties(geometry).forEach((key, value) -> CountryBoundaryMap.setGeometryProperty(part, key, value));
                this.addResult((Geometry)part, results);
            });
        } else if (geometry instanceof LineString || geometry instanceof com.vividsolutions.jts.geom.Polygon) {
            results.add(geometry);
        } else {
            logger.error("Resulting slice was a {}, ignoring it.", (Object)geometry.toText());
        }
    }

    private List<CountryBoundary> boundariesHelper(Supplier<List<com.vividsolutions.jts.geom.Polygon>> supplier, Predicate<com.vividsolutions.jts.geom.Polygon> filter) {
        MultiMap<String, com.vividsolutions.jts.geom.Polygon> map = new MultiMap<String, com.vividsolutions.jts.geom.Polygon>();
        List<com.vividsolutions.jts.geom.Polygon> geometry = supplier.get();
        geometry.stream().filter(filter).forEach(polygon -> {
            String countryCode = CountryBoundaryMap.getGeometryProperty(polygon, "iso_country_code");
            if (countryCode == null) {
                logger.error("Null country code for {}", (Object)polygon.toString());
            } else {
                map.add(countryCode, (com.vividsolutions.jts.geom.Polygon)polygon);
            }
        });
        return this.toCountryBoundaryList(map);
    }

    private Optional<Property> findCountryName(Feature feature, List<String> alternateNames) {
        List lowerCaseAlternateNames = alternateNames.stream().map(String::toLowerCase).collect(Collectors.toList());
        return feature.getProperties().stream().filter(property -> lowerCaseAlternateNames.contains(property.getName().getURI().toLowerCase())).findFirst();
    }

    private int getPolygonSliceLimit() {
        if (this.useExpandedPolygonLimit) {
            return 25000;
        }
        return 2000;
    }

    private Geometry nearestNeighbour(Envelope envelope, Object object, ItemDistance distance) {
        if (envelope.getArea() > 100.0) {
            return null;
        }
        if (this.gridIndex != null) {
            return (Geometry)this.gridIndex.nearestNeighbour(envelope, object, distance);
        }
        return (Geometry)this.rawIndex.nearestNeighbour(envelope, object, distance);
    }

    private List<com.vividsolutions.jts.geom.Polygon> query(Envelope envelope) {
        return this.query(envelope, false);
    }

    private List<com.vividsolutions.jts.geom.Polygon> query(Envelope envelope, boolean isBound) {
        ArrayList<Envelope> bboxes = new ArrayList<Envelope>();
        if (envelope.getWidth() >= 180.0 && !isBound) {
            Envelope bbox1 = new Envelope(-180.0, envelope.getMinX(), envelope.getMinY(), envelope.getMaxY());
            Envelope bbox2 = new Envelope(envelope.getMaxX(), 180.0, envelope.getMinY(), envelope.getMaxY());
            bboxes.add(bbox1);
            bboxes.add(bbox2);
        } else {
            bboxes.add(envelope);
        }
        ArrayList<com.vividsolutions.jts.geom.Polygon> result = new ArrayList<com.vividsolutions.jts.geom.Polygon>();
        for (Envelope bbox : bboxes) {
            if (this.gridIndex != null && this.gridIndexEnvelope.contains(bbox)) {
                result.addAll(this.gridIndex.query(bbox));
            }
            if (!result.isEmpty()) continue;
            result.addAll(this.rawIndex.query(bbox));
        }
        return result;
    }

    private List<CountryBoundary> toCountryBoundaryList(MultiMap<String, com.vividsolutions.jts.geom.Polygon> map) {
        ArrayList<CountryBoundary> list = new ArrayList<CountryBoundary>();
        for (Map.Entry<String, List<com.vividsolutions.jts.geom.Polygon>> entry : map.entrySet()) {
            String name = entry.getKey();
            List<com.vividsolutions.jts.geom.Polygon> polygons = entry.getValue();
            MultiPolygon multiPolygon = JTS_MULTI_POLYGON_TO_POLYGON_CONVERTER.backwardConvert((Set<com.vividsolutions.jts.geom.Polygon>)new HashSet<com.vividsolutions.jts.geom.Polygon>(polygons));
            CountryBoundary boundary = new CountryBoundary(name, multiPolygon);
            list.add(boundary);
        }
        return list;
    }

    private void writeCountryBoundaries(BufferedWriter output) throws IOException {
        logger.info("Writing country boundaries to output");
        this.countryNameToBoundaryMap.forEach((country, polygons) -> polygons.forEach(polygon -> {
            try {
                output.write((String)country);
                output.write(COUNTRY_BOUNDARY_DELIMITER);
                output.write(WKT_WRITER.write((Geometry)polygon));
                output.write(LIST_SEPARATOR);
                output.write(System.lineSeparator());
            }
            catch (IOException e) {
                throw new CoreException("Failed to write country boundaries.", e);
            }
        }));
    }

    private void writeGridIndex(BufferedWriter writer) {
        if (this.gridIndex == null) {
            logger.warn("Skipping grid index serialization, because it is null.");
            return;
        }
        try {
            writer.write(GRID_ENVELOPE_DELIMITER);
            com.vividsolutions.jts.geom.Polygon envelopeAsPolygon = AbstractGridIndexBuilder.buildGeoBox(this.gridIndexEnvelope.getMinX(), this.gridIndexEnvelope.getMaxX(), this.gridIndexEnvelope.getMinY(), this.gridIndexEnvelope.getMaxY());
            writer.write(WKT_WRITER.write(envelopeAsPolygon));
            writer.write(System.lineSeparator());
            MultiMap<Geometry, Envelope> polygonToCells = this.getCells();
            polygonToCells.forEach((polygon, cells) -> {
                String country = CountryBoundaryMap.getGeometryProperty(polygon, "iso_country_code");
                try {
                    writer.write(GRID_INDEX_DELIMITER);
                    writer.write(country);
                    writer.write(GRID_INDEX_DELIMITER);
                    writer.write(CountryBoundaryMap.getGeometryProperty(polygon, POLYGON_ID_KEY));
                    cells.forEach(cell -> {
                        try {
                            writer.write(GRID_INDEX_DELIMITER);
                            writer.write(WKT_WRITER.write(DynamicGridIndexBuilder.buildGeoBox(cell.getMinX(), cell.getMaxX(), cell.getMinY(), cell.getMaxY())));
                        }
                        catch (Exception e) {
                            throw new CoreException("Failed to write cell {} for {}", cell, country, e);
                        }
                    });
                    writer.write(System.lineSeparator());
                }
                catch (Exception e) {
                    throw new CoreException("Failed to write cells for {}.", country, e);
                }
            });
        }
        catch (IOException e) {
            throw new CoreException("Failed to write grid index.", e);
        }
    }
}

