/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.walker;

import java.util.Comparator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.identifier.ReverseIdentifierFactory;
import org.openstreetmap.atlas.geography.atlas.walker.EdgeWalker;

public class OsmWayWalker
extends EdgeWalker {
    private static final Function<Edge, Stream<Edge>> CONNECTED_EDGES = edge -> edge.connectedEdges().stream();

    public OsmWayWalker(Edge edge) {
        super(edge, new WaySectionComparator(), new MasterEdgeByOsmIdentifierFilter(edge.getOsmIdentifier()), CONNECTED_EDGES);
    }

    public OsmWayWalker(Edge edge, EdgeWalker.EdgeHandler edgeHandler) {
        super(edge, new WaySectionComparator(), new MasterEdgeByOsmIdentifierFilter(edge.getOsmIdentifier()), CONNECTED_EDGES, edgeHandler);
    }

    private static class WaySectionComparator
    implements Comparator<Edge> {
        private final ReverseIdentifierFactory reverseIdentifierFactory = new ReverseIdentifierFactory();

        private WaySectionComparator() {
        }

        @Override
        public int compare(Edge left, Edge right) {
            return Long.compare(this.reverseIdentifierFactory.getWaySectionIndex(left.getIdentifier()), this.reverseIdentifierFactory.getWaySectionIndex(right.getIdentifier()));
        }
    }

    private static class MasterEdgeByOsmIdentifierFilter
    implements Predicate<Edge> {
        private final long osmIdentifier;

        MasterEdgeByOsmIdentifierFilter(long osmIdentifier) {
            this.osmIdentifier = osmIdentifier;
        }

        @Override
        public boolean test(Edge edge) {
            return edge.isMasterEdge() && edge.getOsmIdentifier() == this.osmIdentifier;
        }
    }
}

