/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.statistics.coverage.poi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.statistics.coverage.Coverage;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.maps.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CountCoverage<T extends AtlasEntity>
extends Coverage<T> {
    private static final String TYPE_SEPARATOR = ";";
    private static final String KEYS_SEPARATOR = "|";
    private static final String VALUES_SEPARATOR = ",";
    private static final String KEY_VALUE_SEPARATOR = "->";
    private static final String COUPLED_KEYS_SEPARATOR = "&";
    private static final String COUPLED_KEYS_GROUP = "^";
    private final Set<TagGroup> tagGroups = this.validKeyValuePairs();

    public static Iterable<CountCoverage<AtlasEntity>> parseCountCoverages(Atlas atlas, Iterable<String> coverages) {
        ArrayList<CountCoverage<AtlasEntity>> result = new ArrayList<CountCoverage<AtlasEntity>>();
        Iterable<String> filteredCoverages = Iterables.filter(coverages, line -> !line.startsWith("#") && !"".equals(line));
        filteredCoverages.forEach(definition -> {
            try {
                StringList split = StringList.split(definition, TYPE_SEPARATOR);
                final StringList sources = StringList.split(split.get(1), VALUES_SEPARATOR);
                final String type = split.get(0);
                final HashSet allowedTags = new HashSet();
                StringList orGroups = StringList.split(split.get(2), KEYS_SEPARATOR);
                orGroups.forEach(orGroup -> {
                    TagGroup tagGroup = new TagGroup();
                    StringList andGroups = StringList.split(orGroup, COUPLED_KEYS_SEPARATOR);
                    andGroups.forEach(andGroup -> {
                        MultiMap<String, String> tags = new MultiMap<String, String>();
                        StringList carets = StringList.split(andGroup, COUPLED_KEYS_GROUP);
                        carets.forEach(caret -> {
                            StringList keyValue = StringList.split(caret, KEY_VALUE_SEPARATOR);
                            String key = keyValue.get(0);
                            StringList values = StringList.split(keyValue.get(1), VALUES_SEPARATOR);
                            values.forEach(value -> tags.add(key, (String)value));
                        });
                        tagGroup.addTags(tags);
                    });
                    allowedTags.add(tagGroup);
                });
                result.add(new CountCoverage<AtlasEntity>(LoggerFactory.getLogger((String)type), atlas){

                    @Override
                    protected Iterable<AtlasEntity> getEntities() {
                        if (sources.contains("all")) {
                            return this.getAtlas();
                        }
                        ArrayList<Iterable<AtlasEntity>> result = new ArrayList<Iterable<AtlasEntity>>();
                        if (sources.contains("nodes")) {
                            result.add(this.getAtlas().nodes());
                        }
                        if (sources.contains("edges")) {
                            result.add(this.getAtlas().edges());
                        }
                        if (sources.contains("areas")) {
                            result.add(this.getAtlas().areas());
                        }
                        if (sources.contains("lines")) {
                            result.add(this.getAtlas().lines());
                        }
                        if (sources.contains("points")) {
                            result.add(this.getAtlas().points());
                        }
                        if (sources.contains("relations")) {
                            result.add(this.getAtlas().relations());
                        }
                        return new MultiIterable<AtlasEntity>((Iterable<Iterable<AtlasEntity>>)result);
                    }

                    @Override
                    protected String type() {
                        return type;
                    }

                    @Override
                    protected Set<TagGroup> validKeyValuePairs() {
                        return allowedTags;
                    }
                });
            }
            catch (Exception e) {
                throw new CoreException("Error parsing {}", definition, e);
            }
        });
        return result;
    }

    public CountCoverage(Logger logger, Atlas atlas) {
        super(logger, atlas);
    }

    public CountCoverage(Logger logger, Atlas atlas, Predicate<T> filter) {
        super(logger, atlas, filter);
    }

    @Override
    protected Coverage.CoverageType coverageType() {
        return Coverage.CoverageType.COUNT;
    }

    @Override
    protected Set<String> getKeys(AtlasEntity item) {
        return new HashSet<String>();
    }

    @Override
    protected String getUnit() {
        return "count unit";
    }

    @Override
    protected double getValue(T item) {
        return 1.0;
    }

    @Override
    protected boolean isCounted(T item) {
        if (this.tagGroups.isEmpty()) {
            return true;
        }
        for (TagGroup group : this.tagGroups) {
            if (!this.isCounted(item, group)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String subType() {
        return "true";
    }

    protected abstract Set<TagGroup> validKeyValuePairs();

    private boolean isCounted(AtlasEntity item, MultiMap<String, String> andGroup) {
        for (String key : andGroup.keySet()) {
            if (!item.containsValue(key, (Iterable<String>)andGroup.get(key))) continue;
            return true;
        }
        return false;
    }

    private boolean isCounted(T item, TagGroup tagGroup) {
        for (MultiMap<String, String> andGroup : tagGroup) {
            if (this.isCounted((AtlasEntity)item, andGroup)) continue;
            return false;
        }
        return true;
    }

    public static class TagGroup
    implements Iterable<MultiMap<String, String>>,
    Serializable {
        private static final long serialVersionUID = -3963233623607200077L;
        private final Set<MultiMap<String, String>> valuesWorkingTogether = new HashSet<MultiMap<String, String>>();

        public void addTags(MultiMap<String, String> tags) {
            this.valuesWorkingTogether.add(tags);
        }

        @Override
        public Iterator<MultiMap<String, String>> iterator() {
            return this.valuesWorkingTogether.iterator();
        }

        public String toString() {
            return this.valuesWorkingTogether.toString();
        }
    }
}

