/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.routing;

import com.google.common.collect.Iterables;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Route;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AllPathsRouter {
    private static final Logger logger = LoggerFactory.getLogger(AllPathsRouter.class);
    private static final int MAXIMUM_ALLOWED_EDGES_FOR_TRAVERSAL = 1000;
    private static final int MAXIMUM_ALLOWED_PATHS = 20000;
    private static final Predicate<Edge> ALL_EDGES = edge -> true;

    public static Set<Route> allRoutes(Edge start, Edge end) {
        if (start.getAtlas() != end.getAtlas()) {
            throw new CoreException("Supplied start and end edges must come from the same atlas!");
        }
        if (Iterables.size(start.getAtlas().edges()) > 1000) {
            throw new CoreException("Atlas has too many edges for an efficient traversal - aborting!");
        }
        Stack<Edge> path = new Stack<Edge>();
        HashSet<Long> onPath = new HashSet<Long>();
        HashSet<Route> routes = new HashSet<Route>();
        AllPathsRouter.allRoutes(start, end, path, onPath, routes, ALL_EDGES);
        return routes;
    }

    public static Set<Route> allRoutes(Edge start, Edge end, Comparator<Route> comparator) {
        if (start.getAtlas() != end.getAtlas()) {
            throw new CoreException("Supplied start and end edges must come from the same atlas!");
        }
        if (Iterables.size(start.getAtlas().edges()) > 1000) {
            throw new CoreException("Atlas has too many edges for an efficient traversal - aborting!");
        }
        Stack<Edge> path = new Stack<Edge>();
        HashSet<Long> onPath = new HashSet<Long>();
        TreeSet<Route> routes = new TreeSet<Route>(comparator);
        AllPathsRouter.allRoutes(start, end, path, onPath, routes, ALL_EDGES);
        return routes;
    }

    public static Set<Route> allRoutes(Edge start, Edge end, Predicate<Edge> filter) {
        if (start.getAtlas() != end.getAtlas()) {
            throw new CoreException("Supplied start and end edges must come from the same atlas!");
        }
        if (Iterables.size(start.getAtlas().edges()) > 1000) {
            throw new CoreException("Atlas has too many edges for an efficient traversal - aborting!");
        }
        Stack<Edge> path = new Stack<Edge>();
        HashSet<Long> onPath = new HashSet<Long>();
        HashSet<Route> routes = new HashSet<Route>();
        AllPathsRouter.allRoutes(start, end, path, onPath, routes, filter);
        return routes;
    }

    public static Set<Route> allRoutes(Edge start, Edge end, Predicate<Edge> filter, Comparator<Route> comparator) {
        if (start.getAtlas() != end.getAtlas()) {
            throw new CoreException("Supplied start and end edges must come from the same atlas!");
        }
        if (Iterables.size(start.getAtlas().edges()) > 1000) {
            throw new CoreException("Atlas has too many edges for an efficient traversal - aborting!");
        }
        Stack<Edge> path = new Stack<Edge>();
        HashSet<Long> onPath = new HashSet<Long>();
        TreeSet<Route> routes = new TreeSet<Route>(comparator);
        AllPathsRouter.allRoutes(start, end, path, onPath, routes, filter);
        return routes;
    }

    private static void allRoutes(Edge start, Edge end, Stack<Edge> path, Set<Long> onPath, Set<Route> routes, Predicate<Edge> filter) {
        if (routes.size() > 20000) {
            return;
        }
        path.push(start);
        onPath.add(start.getIdentifier());
        if (start.equals(end)) {
            routes.add(Route.forEdges(path));
            if (routes.size() > 20000) {
                logger.warn("Too many paths found - aborting! Path so far: {}", path.stream().map(edge -> String.valueOf(edge.getIdentifier())).collect(Collectors.toList()));
            }
        } else {
            for (Edge candidate : start.outEdges()) {
                if (candidate.isZeroLength() || onPath.contains(candidate.getIdentifier()) || !filter.test(candidate) && !candidate.equals(end)) continue;
                AllPathsRouter.allRoutes(candidate, end, path, onPath, routes, filter);
            }
        }
        path.pop();
        onPath.remove(start.getIdentifier());
    }

    private AllPathsRouter() {
    }
}

