/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.routing;

import java.util.Iterator;
import java.util.SortedSet;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Route;
import org.openstreetmap.atlas.geography.atlas.items.SnappedEdge;
import org.openstreetmap.atlas.geography.atlas.routing.Router;
import org.openstreetmap.atlas.utilities.scalars.Distance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRouter
implements Router {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRouter.class);
    private final Atlas atlas;
    private final Distance threshold;

    public AbstractRouter(Atlas atlas, Distance threshold) {
        this.atlas = atlas;
        this.threshold = threshold;
    }

    @Override
    public Route route(Edge start, Edge end) {
        if (start == null || end == null) {
            throw new CoreException("Cannot compute route on null arguments: start = {} and end = {}", start, end);
        }
        if (start.equals(end)) {
            return Route.forEdge(start);
        }
        if (start.end().equals(end.start())) {
            return Route.forEdge(start).append(end);
        }
        Route result = this.route(start.end(), end.start());
        if (result != null) {
            return Route.forEdge(start).append(result).append(end);
        }
        return null;
    }

    @Override
    public Route route(Location start, Location end) {
        if (start == null || end == null) {
            throw new CoreException("Cannot compute route on null arguments: start = {} and end = {}", start, end);
        }
        SortedSet<SnappedEdge> startEdges = this.atlas.snaps(start, this.threshold);
        SortedSet<SnappedEdge> endEdges = this.atlas.snaps(end, this.threshold);
        if (startEdges.isEmpty()) {
            return null;
        }
        if (endEdges.isEmpty()) {
            return null;
        }
        Iterator startIterator = startEdges.iterator();
        for (int i = 0; i < startEdges.size(); ++i) {
            Edge startEdge = ((SnappedEdge)startIterator.next()).getEdge();
            Iterator endIterator = endEdges.iterator();
            for (int j = 0; j < endEdges.size(); ++j) {
                Edge endEdge = ((SnappedEdge)endIterator.next()).getEdge();
                Route route = this.route(startEdge, endEdge);
                if (route == null) continue;
                return route;
            }
        }
        return null;
    }
}

