/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.raw.slicing.temporary;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class TemporaryEntity
implements Serializable {
    private static final long serialVersionUID = -7784252999177116142L;
    private final Map<String, String> tags;
    private final long identifier;

    protected TemporaryEntity(long identifier, Map<String, String> tags) {
        this.identifier = identifier;
        this.tags = tags;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            TemporaryEntity that = (TemporaryEntity)other;
            return this.getIdentifier() == that.getIdentifier();
        }
        return false;
    }

    public long getIdentifier() {
        return this.identifier;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getIdentifier()).append(this.getClass()).hashCode();
    }

    public abstract String toString();

    protected String tagString() {
        StringBuilder builder = new StringBuilder();
        Map<String, String> tags = this.getTags();
        int index = 0;
        builder.append("[Tags: ");
        for (String key : tags.keySet()) {
            String value = tags.get(key);
            builder.append("[");
            builder.append(key);
            builder.append(" => ");
            builder.append(value);
            builder.append("]");
            if (index < tags.size() - 1) {
                builder.append(", ");
            }
            ++index;
        }
        builder.append("]");
        return builder.toString();
    }
}

