/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.raw.slicing.changeset;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.temporary.TemporaryLine;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.temporary.TemporaryPoint;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.temporary.TemporaryRelation;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.temporary.TemporaryRelationMember;
import org.openstreetmap.atlas.utilities.maps.MultiMapWithSet;

public class RelationChangeSet {
    private final Map<Long, TemporaryPoint> createdPoints;
    private final Map<Long, TemporaryLine> createdLines;
    private final Map<Long, TemporaryRelation> createdRelations;
    private final Map<Long, Map<String, String>> updatedRelationTags;
    private final MultiMapWithSet<Long, TemporaryRelationMember> addedRelationMembers;
    private final MultiMapWithSet<Long, TemporaryRelationMember> deletedRelationMembers;
    private final Set<Long> deletedPoints = new HashSet<Long>();
    private final Set<Long> deletedLines;
    private final Set<Long> deletedRelations;
    private final MultiMapWithSet<Long, Long> deletedToCreatedRelationMapping;

    public RelationChangeSet() {
        this.createdPoints = new HashMap<Long, TemporaryPoint>();
        this.createdLines = new HashMap<Long, TemporaryLine>();
        this.createdRelations = new HashMap<Long, TemporaryRelation>();
        this.updatedRelationTags = new HashMap<Long, Map<String, String>>();
        this.addedRelationMembers = new MultiMapWithSet();
        this.deletedRelationMembers = new MultiMapWithSet();
        this.deletedLines = new HashSet<Long>();
        this.deletedRelations = new HashSet<Long>();
        this.deletedToCreatedRelationMapping = new MultiMapWithSet();
    }

    public void addRelationMember(Long relationIdentifier, TemporaryRelationMember member) {
        this.addedRelationMembers.add(relationIdentifier, member);
    }

    public void createDeletedToCreatedMapping(long deletedIdentifier, Long createdIdentifier) {
        this.deletedToCreatedRelationMapping.add(deletedIdentifier, createdIdentifier);
    }

    public void createLine(TemporaryLine line) {
        this.createdLines.put(line.getIdentifier(), line);
    }

    public void createPoint(TemporaryPoint point) {
        this.createdPoints.put(point.getIdentifier(), point);
    }

    public void createRelation(TemporaryRelation relation) {
        this.createdRelations.put(relation.getIdentifier(), relation);
    }

    public void deleteLine(Long identifier) {
        this.deletedLines.add(identifier);
    }

    public void deletePoint(Long identifier) {
        this.deletedPoints.add(identifier);
    }

    public void deleteRelation(long identifier) {
        this.deletedRelations.add(identifier);
    }

    public void deleteRelationMember(Long relationIdentifier, TemporaryRelationMember member) {
        this.deletedRelationMembers.add(relationIdentifier, member);
    }

    public MultiMapWithSet<Long, TemporaryRelationMember> getAddedRelationMembers() {
        return this.addedRelationMembers;
    }

    public Map<Long, TemporaryLine> getCreatedLines() {
        return this.createdLines;
    }

    public Map<Long, TemporaryPoint> getCreatedPoints() {
        return this.createdPoints;
    }

    public Map<Long, TemporaryRelation> getCreatedRelations() {
        return this.createdRelations;
    }

    public Set<Long> getDeletedLines() {
        return this.deletedLines;
    }

    public Set<Long> getDeletedPoints() {
        return this.deletedPoints;
    }

    public MultiMapWithSet<Long, TemporaryRelationMember> getDeletedRelationMembers() {
        return this.deletedRelationMembers;
    }

    public Set<Long> getDeletedRelations() {
        return this.deletedRelations;
    }

    public MultiMapWithSet<Long, Long> getDeletedToCreatedRelationMapping() {
        return this.deletedToCreatedRelationMapping;
    }

    public Map<Long, Map<String, String>> getUpdatedRelationTags() {
        return this.updatedRelationTags;
    }

    public boolean relationGeometryModified(long relationIdentifier) {
        return this.getDeletedRelations().contains(relationIdentifier) || this.getAddedRelationMembers().get(relationIdentifier) != null || this.getDeletedRelationMembers().get(relationIdentifier) != null;
    }

    public void updateRelationTags(long relationIdentifier, Map<String, String> newTags) {
        this.updatedRelationTags.put(relationIdentifier, newTags);
    }
}

