/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.raw.slicing.changeset;

import java.util.ArrayList;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.builder.AtlasSize;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasBuilder;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.temporary.TemporaryLine;

public abstract class ChangeSetHandler {
    private static final double ENTITY_SCALING_FACTOR = 1.2;
    private final Atlas atlas;
    private final PackedAtlasBuilder builder = new PackedAtlasBuilder();

    protected ChangeSetHandler(Atlas atlas) {
        this.atlas = atlas;
    }

    public abstract Atlas applyChanges();

    protected String atlasStatistics(Atlas atlas) {
        StringBuilder builder = new StringBuilder();
        builder.append("Points: ");
        builder.append(atlas.numberOfPoints());
        builder.append(" Lines: ");
        builder.append(atlas.numberOfLines());
        builder.append(" Relations: ");
        builder.append(atlas.numberOfRelations());
        return builder.toString();
    }

    protected Atlas getAtlas() {
        return this.atlas;
    }

    protected PackedAtlasBuilder getBuilder() {
        return this.builder;
    }

    protected String getShardOrAtlasName() {
        return this.atlas.metaData().getShardName().orElse(this.atlas.getName());
    }

    protected PolyLine reconstructGeometryForLine(TemporaryLine line) {
        ArrayList locations = new ArrayList();
        line.getShapePointIdentifiers().forEach(identifier -> {
            Point point = this.getBuilder().peek().point((long)identifier);
            if (point == null) {
                throw new CoreException("Corrupt Data: Line {} is referencing a shape point {} which doesn't exist!", line.getIdentifier(), identifier);
            }
            locations.add(point.getLocation());
        });
        return new PolyLine(locations);
    }

    protected void setAtlasSizeEstimateAndMetadata() {
        AtlasSize size = new AtlasSize(0L, 0L, 0L, Math.round((double)this.getAtlas().numberOfLines() * 1.2), Math.round((double)this.getAtlas().numberOfPoints() * 1.2), this.getAtlas().numberOfRelations());
        this.getBuilder().setSizeEstimates(size);
        this.getBuilder().setMetaData(this.atlas.metaData());
    }
}

