/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.raw.slicing;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.identifier.CountrySlicingIdentifierFactory;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.CoordinateToNewPointMapping;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.CountryCodeProperties;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.RawAtlasSlicingStatistic;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.temporary.TemporaryPoint;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.converters.MultiplePolyLineToPolygonsConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsLinearRingConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsLocationConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPolyLineConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPolygonConverter;
import org.openstreetmap.atlas.tags.SyntheticBoundaryNodeTag;
import org.openstreetmap.atlas.tags.SyntheticNearestNeighborCountryCodeTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RawAtlasSlicer {
    private static final Logger logger = LoggerFactory.getLogger(RawAtlasSlicer.class);
    private static final double SEVEN_DIGIT_PRECISION_SCALE = 1.0E7;
    protected static final JtsPolygonConverter JTS_POLYGON_CONVERTER = new JtsPolygonConverter();
    protected static final JtsPolyLineConverter JTS_POLYLINE_CONVERTER = new JtsPolyLineConverter();
    protected static final JtsLocationConverter JTS_LOCATION_CONVERTER = new JtsLocationConverter();
    protected static final JtsLinearRingConverter JTS_LINEAR_RING_CONVERTER = new JtsLinearRingConverter();
    protected static final MultiplePolyLineToPolygonsConverter MULTIPLE_POLY_LINE_TO_POLYGON_CONVERTER = new MultiplePolyLineToPolygonsConverter();
    private final Set<String> countries;
    private final CountryBoundaryMap countryBoundaryMap;
    private final RawAtlasSlicingStatistic statistics = new RawAtlasSlicingStatistic(logger);
    private final CoordinateToNewPointMapping newPointCoordinates;

    protected static Map<String, String> createLineTags(Geometry geometry, Map<String, String> tags) {
        String countryCode = CountryBoundaryMap.getGeometryProperty(geometry, "iso_country_code");
        tags.put("iso_country_code", countryCode);
        String usingNearestNeighbor = CountryBoundaryMap.getGeometryProperty(geometry, "nearest_neighbor_country_code");
        if (usingNearestNeighbor != null) {
            tags.put("nearest_neighbor_country_code", usingNearestNeighbor);
        }
        return tags;
    }

    protected static TemporaryPoint createNewPoint(Coordinate coordinate, CountrySlicingIdentifierFactory pointIdentifierFactory, Map<String, String> pointTags) {
        if (!pointIdentifierFactory.hasMore()) {
            throw new CoreException("Country Slicing exceeded maximum number {} of supported new points at Coordinate {}", 1000L, coordinate);
        }
        pointTags.put("synthetic_boundary_node", SyntheticBoundaryNodeTag.YES.toString());
        return new TemporaryPoint(pointIdentifierFactory.nextIdentifier(), JTS_LOCATION_CONVERTER.backwardConvert(coordinate), pointTags);
    }

    protected static boolean fromSameCountry(Line one, Line two) {
        Optional<String> firstTagValue = one.getTag("iso_country_code");
        Optional<String> secondTagValue = two.getTag("iso_country_code");
        if (firstTagValue.isPresent() && secondTagValue.isPresent()) {
            HashSet<String> firstCountries = new HashSet<String>(Arrays.asList(firstTagValue.get().split(",")));
            HashSet<String> secondCountries = new HashSet<String>(Arrays.asList(secondTagValue.get().split(",")));
            firstCountries.retainAll(new HashSet<String>(secondCountries));
            return !firstCountries.isEmpty();
        }
        throw new CoreException("All raw Atlas lines must have a country code by the time Relation slicing is done. One of the two Lines {} or {} does not!", one.getIdentifier(), two.getIdentifier());
    }

    protected static void roundCoordinate(Coordinate coordinate) {
        coordinate.x = (double)Math.round(coordinate.x * 1.0E7) / 1.0E7;
        coordinate.y = (double)Math.round(coordinate.y * 1.0E7) / 1.0E7;
    }

    public RawAtlasSlicer(Set<String> countries, CountryBoundaryMap countryBoundaryMap, CoordinateToNewPointMapping newPointCoordinates) {
        this.countries = countries;
        this.countryBoundaryMap = countryBoundaryMap;
        this.newPointCoordinates = newPointCoordinates;
    }

    public abstract Atlas slice();

    protected Map<String, String> createPointTags(Location location, boolean fromRawAtlas) {
        HashMap<String, String> tags = new HashMap<String, String>();
        CountryCodeProperties countryDetails = this.getCountryBoundaryMap().getCountryCodeISO3(location);
        if (countryDetails.inMultipleCountries()) {
            tags.put("iso_country_code", Joiner.on(",").join(Sets.newTreeSet(Arrays.asList(countryDetails.getIso3CountryCode().split(",")))));
        } else {
            tags.put("iso_country_code", countryDetails.getIso3CountryCode());
        }
        if (countryDetails.usingNearestNeighbor()) {
            tags.put("nearest_neighbor_country_code", SyntheticNearestNeighborCountryCodeTag.YES.toString());
            tags.put("synthetic_boundary_node", SyntheticBoundaryNodeTag.EXISTING.toString());
        }
        if (fromRawAtlas && countryDetails.inMultipleCountries()) {
            tags.put("synthetic_boundary_node", SyntheticBoundaryNodeTag.EXISTING.toString());
        }
        return tags;
    }

    protected CoordinateToNewPointMapping getCoordinateToPointMapping() {
        return this.newPointCoordinates;
    }

    protected Set<String> getCountries() {
        return this.countries;
    }

    protected CountryBoundaryMap getCountryBoundaryMap() {
        return this.countryBoundaryMap;
    }

    protected RawAtlasSlicingStatistic getStatistics() {
        return this.statistics;
    }
}

