/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.raw.slicing;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CoordinateToNewPointMapping {
    private static final Integer SIX_DIGIT_PRECISION_SCALE = 1000000;
    private final Map<Coordinate, Long> coordinateToPointIdentifierMap = new ConcurrentHashMap<Coordinate, Long>();
    private final PrecisionModel precisionModel = new PrecisionModel(SIX_DIGIT_PRECISION_SCALE.intValue());

    public boolean containsCoordinate(Coordinate coordinate) {
        Coordinate scaled = this.getScaledCoordinate(coordinate);
        return this.coordinateToPointIdentifierMap.containsKey(scaled);
    }

    public Long getPointForCoordinate(Coordinate coordinate) {
        Coordinate precise = this.getScaledCoordinate(coordinate);
        return this.coordinateToPointIdentifierMap.get(precise);
    }

    public void storeMapping(Coordinate coordinate, Long value) {
        Coordinate scaled = this.getScaledCoordinate(coordinate);
        this.coordinateToPointIdentifierMap.put(scaled, value);
    }

    private Coordinate getScaledCoordinate(Coordinate target) {
        Coordinate cloned = (Coordinate)target.clone();
        this.precisionModel.makePrecise(cloned);
        return cloned;
    }
}

