/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.raw.sectioning;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.temporary.TemporaryNode;

public class NodeOccurrenceCounter {
    private final Map<TemporaryNode, Integer> nodes = new HashMap<TemporaryNode, Integer>();

    public void addNode(TemporaryNode node) {
        this.nodes.put(node, 1);
    }

    public Optional<TemporaryNode> getNode(Location location) {
        for (TemporaryNode node : this.getNodes()) {
            if (!node.getLocation().equals(location)) continue;
            return Optional.of(node);
        }
        return Optional.empty();
    }

    public Set<TemporaryNode> getNodes() {
        return this.nodes.keySet();
    }

    public int getOccurrence(TemporaryNode node) {
        return this.nodes.get(node);
    }

    public void incrementOccurrence(TemporaryNode node) {
        if (this.nodes.containsKey(node)) {
            int oldOccurence = this.nodes.get(node);
            this.nodes.put(node, oldOccurence + 1);
        }
    }

    public int size() {
        return this.nodes.size();
    }
}

