/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.pbf.store;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;

public class SectionCounter {
    private Map<Long, Byte> map = new HashMap<Long, Byte>();

    public void clear() {
        this.map = new HashMap<Long, Byte>();
    }

    public boolean contains(Long identifier) {
        return this.map.containsKey(identifier);
    }

    public int countFor(Long identifier) {
        return this.map.get(identifier).byteValue();
    }

    public void increment(Long nodeIdentifier) {
        Byte count = this.map.get(nodeIdentifier);
        if (count == null) {
            count = 0;
        }
        this.map.put(nodeIdentifier, (byte)(count + 1));
    }

    public void increment(WayNode node) {
        long nodeIdentifier = node.getNodeId();
        this.increment(nodeIdentifier);
    }

    public void incrementAll(List<WayNode> nodes) {
        nodes.forEach(node -> this.increment((WayNode)node));
    }

    public boolean isSection(Long identifier) {
        return this.contains(identifier) && this.countFor(identifier) > 1;
    }

    public long sectionCount() {
        return this.map.values().stream().filter(count -> count > 1).count();
    }

    public Stream<Long> sections() {
        return this.map.keySet().stream().filter(identifier -> this.isSection((Long)identifier));
    }

    public int size() {
        return this.map.size();
    }
}

