/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.pbf.slicing;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.TopologyException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.geography.atlas.pbf.converters.TagMapToTagCollectionConverter;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.ChangeSet;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.RelationType;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.RuntimeCounter;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.identifier.CountrySlicingIdentifierFactory;
import org.openstreetmap.atlas.geography.atlas.pbf.store.PbfMemoryStore;
import org.openstreetmap.atlas.geography.atlas.pbf.store.TagMap;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.converters.jts.JtsUtility;
import org.openstreetmap.atlas.tags.SyntheticBoundaryNodeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.openstreetmap.atlas.utilities.maps.MultiMap;
import org.openstreetmap.osmosis.core.domain.v0_6.CommonEntityData;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountrySlicingProcessor {
    private static final Logger logger = LoggerFactory.getLogger(CountrySlicingProcessor.class);
    private static final int JTS_MINIMUM_RING_SIZE = 4;
    private static final TagMapToTagCollectionConverter TAG_MAP_TO_TAG_COLLECTION_CONVERTER = new TagMapToTagCollectionConverter();
    private final CountryBoundaryMap boundaryMap;
    private final Set<String> countryCodeISO3;
    private final PbfMemoryStore store;
    private final ChangeSet changeSet;

    private static void roundCoordinate(Coordinate coordinate) {
        double factor = 1.0E7;
        coordinate.x = (double)Math.round(coordinate.x * 1.0E7) / 1.0E7;
        coordinate.y = (double)Math.round(coordinate.y * 1.0E7) / 1.0E7;
    }

    private static void tagCountry(Entity entity, String countryCode, String usingNearestNeighbor) {
        if (Objects.isNull(entity)) {
            return;
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        boolean hasCountryCode = false;
        for (Tag tag : entity.getTags()) {
            if (tag.getKey().equals("iso_country_code")) {
                hasCountryCode = true;
                if (!tag.getValue().contains(countryCode)) {
                    tags.add(new Tag("iso_country_code", String.join((CharSequence)",", tag.getValue(), countryCode)));
                    continue;
                }
                return;
            }
            tags.add(tag);
        }
        if (hasCountryCode) {
            if (usingNearestNeighbor != null) {
                tags.add(new Tag("nearest_neighbor_country_code", usingNearestNeighbor));
            }
            entity.getTags().clear();
            entity.getTags().addAll(tags);
        } else {
            entity.getTags().add(new Tag("iso_country_code", countryCode));
            if (usingNearestNeighbor != null) {
                entity.getTags().add(new Tag("nearest_neighbor_country_code", usingNearestNeighbor));
            }
        }
    }

    public CountrySlicingProcessor(PbfMemoryStore store, CountryBoundaryMap countryBoundaryMap) {
        this(store, countryBoundaryMap, null);
    }

    public CountrySlicingProcessor(PbfMemoryStore store, CountryBoundaryMap countryBoundaryMap, Set<String> countryCodeISO3) {
        this.store = store;
        this.countryCodeISO3 = countryCodeISO3;
        this.boundaryMap = countryBoundaryMap;
        this.changeSet = new ChangeSet();
    }

    public void run() {
        logger.info("Starting country slicing process....");
        this.processWays();
        this.store.apply(this.changeSet, false);
        this.processRelations();
        this.store.apply(this.changeSet);
        logger.info(RuntimeCounter.print());
    }

    private List<LinearRing> buildRings(Relation relation, List<RelationMember> members) {
        ArrayList<LinearRing> results = new ArrayList<LinearRing>();
        ArrayList<PolygonPiece> pieces = new ArrayList<PolygonPiece>(members.size());
        ArrayDeque<PolygonPiece> stack = new ArrayDeque<PolygonPiece>(members.size());
        for (RelationMember member : members) {
            Way way = this.store.getWay(member.getMemberId());
            if (way == null) {
                logger.warn("Relation {} has an incomplete member {}", (Object)relation.getId(), (Object)member.getMemberId());
                return null;
            }
            PolygonPiece piece = new PolygonPiece(way);
            pieces.add(piece);
            stack.push(piece);
        }
        while (!stack.isEmpty()) {
            PolygonPiece piece1 = (PolygonPiece)stack.pop();
            while (!piece1.isClosed()) {
                boolean foundConnection = false;
                for (PolygonPiece piece2 : stack) {
                    if (piece1.getEndNode().equals(piece2.getStartNode())) {
                        foundConnection = true;
                        piece1.merge(piece2, false, false);
                    } else if (piece1.getEndNode().equals(piece2.getEndNode())) {
                        foundConnection = true;
                        piece1.merge(piece2, false, true);
                    } else if (piece1.getStartNode().equals(piece2.getStartNode())) {
                        foundConnection = true;
                        piece1.merge(piece2, true, false);
                    } else if (piece1.getStartNode().equals(piece2.getEndNode())) {
                        foundConnection = true;
                        piece1.merge(piece2, true, true);
                    }
                    if (!foundConnection) continue;
                    stack.remove(piece2);
                    break;
                }
                if (foundConnection) continue;
                logger.warn("Relation {} claims to be multipolygon, but has a detached way {}", (Object)relation.getId(), (Object)piece1.getIdentifier());
                return null;
            }
            if (piece1.getCoordinates().size() < 4) {
                logger.warn("Relation {} claims to be multipolygon, but doesn't have a valid closed way", (Object)relation.getId(), (Object)piece1.getIdentifier());
                return null;
            }
            results.add(JtsUtility.buildLinearRing(piece1.getCoordinates()));
        }
        return results;
    }

    private void generatePatchedWays(Relation relation, List<RelationMember> outers, List<RelationMember> inners, Map<Coordinate, Node> cachedNodes) {
        int outerIndex;
        if (outers == null || outers.isEmpty()) {
            return;
        }
        List<RelationMember> outerInCompleteList = outers.stream().filter(relationMember -> {
            Way way = this.store.getWay(relationMember.getMemberId());
            return way == null || !way.isClosed();
        }).collect(Collectors.toList());
        if (outerInCompleteList.isEmpty()) {
            return;
        }
        List<LinearRing> outerRings = this.buildRings(relation, outerInCompleteList);
        if (outerRings == null || outerRings.isEmpty()) {
            return;
        }
        List<LinearRing> innerRings = null;
        MultiMap<Integer, Integer> outToInMap = new MultiMap<Integer, Integer>();
        List<RelationMember> innerIncompleteList = null;
        if (inners != null && !inners.isEmpty()) {
            innerIncompleteList = inners.stream().filter(relationMember -> {
                Way way = this.store.getWay(relationMember.getMemberId());
                return way == null || !way.isClosed();
            }).collect(Collectors.toList());
            innerRings = this.buildRings(relation, innerIncompleteList);
            if (innerRings == null) {
                return;
            }
            for (int innerIndex = 0; innerIndex < innerRings.size(); ++innerIndex) {
                LinearRing inner = innerRings.get(innerIndex);
                boolean isMatched = false;
                for (outerIndex = 0; outerIndex < outerRings.size(); ++outerIndex) {
                    LinearRing outer = outerRings.get(outerIndex);
                    Polygon polygon = new Polygon(outer, null, JtsUtility.GEOMETRY_FACTORY);
                    if (!polygon.contains(inner)) continue;
                    isMatched = true;
                    outToInMap.add(outerIndex, innerIndex);
                }
                if (isMatched) continue;
                return;
            }
        }
        long[] seeds = new long[relation.getMembers().size()];
        for (int seedIndex = 0; seedIndex < seeds.length; ++seedIndex) {
            long seed = relation.getMembers().get(seedIndex).getMemberId();
            if (this.changeSet.hasWay(seed)) {
                seed += (long)this.changeSet.getWayMap().get(seed).size() * 1000L;
            }
            seeds[seedIndex] = seed;
        }
        CountrySlicingIdentifierFactory wayIdentifierGenerator = new CountrySlicingIdentifierFactory(seeds[0]);
        CountrySlicingIdentifierFactory nodeIdentifierGenerator = new CountrySlicingIdentifierFactory(seeds);
        for (outerIndex = 0; outerIndex < outerRings.size(); ++outerIndex) {
            List<LineString> borderLines;
            Polygon polygon;
            LinearRing outerRing = outerRings.get(outerIndex);
            LinearRing[] holes = null;
            if (outToInMap.containsKey(outerIndex)) {
                Object innerIndexes = outToInMap.get(outerIndex);
                holes = new LinearRing[innerIndexes.size()];
                for (int innerIndex = 0; innerIndex < innerIndexes.size(); ++innerIndex) {
                    holes[innerIndex] = innerRings.get((Integer)innerIndexes.get(innerIndex));
                }
            }
            if (!(polygon = new Polygon(outerRing, holes, JtsUtility.GEOMETRY_FACTORY)).isValid()) {
                logger.warn("Polygon created by relation {} is invalid", (Object)relation.getId());
                return;
            }
            try {
                borderLines = this.boundaryMap.clipBoundary(relation.getId(), polygon);
            }
            catch (Exception e) {
                logger.error("Error processing relation {}, message: {}, geometry: {}", new Object[]{relation.getId(), e.getMessage(), polygon.toString()});
                return;
            }
            if (borderLines == null || borderLines.size() == 0) {
                return;
            }
            if ((long)borderLines.size() >= 1000L) {
                logger.warn("Borderline got cut into more than 999 pieces for relation {}", (Object)relation.getId());
                return;
            }
            if (innerIncompleteList != null && borderLines.size() > 0) {
                innerIncompleteList.forEach(relationMember -> {
                    relation.getMembers().remove(relationMember);
                    relation.getMembers().add(new RelationMember(relationMember.getMemberId(), relationMember.getMemberType(), "outer"));
                });
            }
            for (LineString borderLine : borderLines) {
                ArrayList<WayNode> wayNodes = new ArrayList<WayNode>(borderLine.getNumPoints());
                for (int borderLineIndex = 0; borderLineIndex < borderLine.getNumPoints(); ++borderLineIndex) {
                    Coordinate nodeCoordinate = borderLine.getCoordinateN(borderLineIndex);
                    CountrySlicingProcessor.roundCoordinate(nodeCoordinate);
                    Node node = cachedNodes.get(nodeCoordinate);
                    if (node == null) {
                        long newNodeIdentifier;
                        try {
                            newNodeIdentifier = nodeIdentifierGenerator.nextIdentifier();
                        }
                        catch (Exception e) {
                            logger.warn("New way generated for relation {} is too big, ran out of node identfiers to use.", (Object)relation.getId(), (Object)e);
                            return;
                        }
                        node = this.store.createNode(newNodeIdentifier, nodeCoordinate.y, nodeCoordinate.x);
                        this.store.addNode(node);
                        cachedNodes.put(nodeCoordinate, node);
                    }
                    wayNodes.add(new WayNode(node.getId()));
                }
                Way way = new Way(new CommonEntityData(wayIdentifierGenerator.nextIdentifier(), relation.getVersion(), relation.getTimestampContainer(), relation.getUser(), relation.getChangesetId()), wayNodes);
                String countryCodeValue = CountryBoundaryMap.getGeometryProperty(borderLine, "iso_country_code");
                way.getTags().add(new Tag("iso_country_code", countryCodeValue));
                String usingNearestNeighbor = CountryBoundaryMap.getGeometryProperty(borderLine, "nearest_neighbor_country_code");
                if (usingNearestNeighbor != null) {
                    way.getTags().add(new Tag("nearest_neighbor_country_code", usingNearestNeighbor));
                }
                this.changeSet.addCreatedWay(way);
                relation.getMembers().add(new RelationMember(way.getId(), way.getType(), "outer"));
                this.changeSet.addModifiedRelation(relation);
            }
        }
    }

    private boolean isOutsideWorkingBound(Geometry geometry) {
        String countryCode = CountryBoundaryMap.getGeometryProperty(geometry, "iso_country_code");
        return this.countryCodeISO3 != null && !this.countryCodeISO3.isEmpty() && !this.countryCodeISO3.contains(countryCode);
    }

    private Optional<List<Relation>> processDefaultRelation(Relation relation, List<Long> parents) {
        Map<String, List<RelationMember>> countryEntityMap;
        ArrayList createdRelations = new ArrayList();
        ArrayList<RelationMember> members = new ArrayList<RelationMember>();
        boolean isModified = false;
        block4: for (RelationMember member2 : relation.getMembers()) {
            switch (member2.getMemberType()) {
                case Way: {
                    List<Way> slicedWays = this.changeSet.getCreatedWays(member2.getMemberId());
                    if (slicedWays != null && !slicedWays.isEmpty()) {
                        isModified = true;
                        slicedWays.forEach(way -> members.add(this.store.createRelationMember(member2, way.getId())));
                        continue block4;
                    }
                    members.add(member2);
                    continue block4;
                }
                case Relation: {
                    Optional<List<Relation>> slicedMembers;
                    parents.add(relation.getId());
                    Relation subRelation = this.store.getRelation(member2.getMemberId());
                    if (subRelation == null) {
                        members.add(member2);
                        continue block4;
                    }
                    if (!parents.contains(subRelation.getId())) {
                        slicedMembers = this.sliceRelation(subRelation, parents);
                    } else {
                        logger.error("Relation {} has a loop! Parent tree: {}", (Object)subRelation.getId(), parents);
                        slicedMembers = Optional.empty();
                    }
                    if (slicedMembers.isPresent()) {
                        isModified = true;
                        slicedMembers.get().forEach(slicedRelation -> members.add(this.store.createRelationMember(member2, slicedRelation.getId())));
                        continue block4;
                    }
                    members.add(member2);
                    continue block4;
                }
            }
            members.add(member2);
        }
        if (isModified) {
            this.changeSet.addModifiedRelation(relation);
        }
        List<Object> memberWithoutCountry = (countryEntityMap = members.stream().collect(Collectors.groupingBy(member -> {
            Entity entity = this.store.getEntity((RelationMember)member);
            if (Objects.isNull(entity)) {
                return "N/A";
            }
            Optional<Tag> countryCodeTag = entity.getTags().stream().filter(tag -> tag.getKey().equals("iso_country_code")).findFirst();
            if (countryCodeTag.isPresent()) {
                return countryCodeTag.get().getValue();
            }
            return "N/A";
        }))).containsKey("N/A") ? countryEntityMap.remove("N/A") : Collections.emptyList();
        int countryCount = countryEntityMap.size();
        if (countryCount == 0) {
            relation.getTags().add(new Tag("iso_country_code", "N/A"));
            return Optional.empty();
        }
        if (countryCount == 1) {
            relation.getTags().add(new Tag("iso_country_code", countryEntityMap.keySet().iterator().next()));
            return Optional.empty();
        }
        RuntimeCounter.relationSliced();
        this.changeSet.addDeletedRelation(relation);
        CountrySlicingIdentifierFactory relationIdFactory = new CountrySlicingIdentifierFactory(relation.getId());
        countryEntityMap.entrySet().forEach(entry -> {
            ArrayList<RelationMember> candidateMembers = new ArrayList<RelationMember>();
            candidateMembers.addAll((Collection)entry.getValue());
            candidateMembers.addAll(memberWithoutCountry);
            if (!candidateMembers.isEmpty()) {
                Relation relationToAdd = this.store.createRelation(relation, relationIdFactory.nextIdentifier(), candidateMembers);
                relationToAdd.getTags().add(new Tag("iso_country_code", (String)entry.getKey()));
                createdRelations.add(relationToAdd);
                this.changeSet.addCreatedRelation(relationToAdd);
            }
        });
        return Optional.of(createdRelations);
    }

    private void processMultiPolygonRelation(Relation relation) {
        Map<String, List<RelationMember>> roleMap = relation.getMembers().stream().filter(member -> member.getMemberType() == EntityType.Way).collect(Collectors.groupingBy(RelationMember::getMemberRole));
        List<RelationMember> outer = roleMap.get("outer");
        List<RelationMember> inner = roleMap.get("inner");
        HashMap<Coordinate, Node> cachedNodes = new HashMap<Coordinate, Node>();
        this.generatePatchedWays(relation, outer, inner, cachedNodes);
    }

    private void processRelations() {
        this.store.getRelations().values().stream().forEach(this::sliceRelation);
    }

    private void processWays() {
        this.store.getWays().values().stream().forEach(this::sliceWay);
    }

    private Optional<List<Relation>> sliceRelation(Relation relation) {
        return this.sliceRelation(relation, new ArrayList<Long>());
    }

    private Optional<List<Relation>> sliceRelation(Relation relation, List<Long> parents) {
        RuntimeCounter.relationProcessed();
        Map<String, String> tagMap = new TagMap(relation.getTags()).getTags();
        String typeValue = tagMap.get("type");
        RelationType type = RelationType.forValue(typeValue);
        switch (type) {
            case MULTIPOLYGON: 
            case BOUNDARY: {
                this.processMultiPolygonRelation(relation);
                break;
            }
        }
        return this.processDefaultRelation(relation, parents);
    }

    private Optional<List<Way>> sliceWay(Way way) {
        List<Geometry> slices;
        RuntimeCounter.wayProcessed();
        if (Objects.isNull(way)) {
            return Optional.empty();
        }
        List<WayNode> wayNodes = way.getWayNodes();
        if (wayNodes.size() < 2 || wayNodes.size() == 2 && wayNodes.get(0).getNodeId() == wayNodes.get(1).getNodeId()) {
            return Optional.empty();
        }
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        HashMap<Coordinate, Node> coordinateToNode = new HashMap<Coordinate, Node>(wayNodes.size() + 2);
        HashMap<Long, Node> identifierToNode = new HashMap<Long, Node>(wayNodes.size() + 2);
        wayNodes.forEach(wayNode -> {
            Node node = this.store.getNode(wayNode.getNodeId());
            if (node == null) {
                logger.error("Node {} in Way {} is not in the store.", (Object)wayNode.getNodeId(), (Object)way.getId());
            }
            Coordinate coordinate = new Coordinate(node.getLongitude(), node.getLatitude());
            CountrySlicingProcessor.roundCoordinate(coordinate);
            coordinates.add(coordinate);
            coordinateToNode.put(coordinate, node);
            identifierToNode.put(node.getId(), node);
        });
        Geometry geometry = !way.isClosed() ? JtsUtility.buildLineString(coordinates.toArray(new Coordinate[0])) : JtsUtility.toPolygon(coordinates);
        try {
            slices = this.boundaryMap.slice(way.getId(), geometry, Taggable.with(way.getTags()));
        }
        catch (TopologyException e) {
            logger.warn("Way slicing for {} threw topology exception.", (Object)way.getId(), (Object)e);
            return Optional.empty();
        }
        if (slices == null) {
            way.getTags().add(new Tag("iso_country_code", "N/A"));
            return Optional.empty();
        }
        if (slices.size() == 1 || CountryBoundaryMap.isSameCountry(slices) && !this.boundaryMap.shouldForceSlicing(Taggable.with(way.getTags()))) {
            String countryCodeValue = CountryBoundaryMap.getGeometryProperty(slices.get(0), "iso_country_code");
            way.getTags().add(new Tag("iso_country_code", countryCodeValue));
            String usingNearestNeighbor = CountryBoundaryMap.getGeometryProperty(slices.get(0), "nearest_neighbor_country_code");
            if (usingNearestNeighbor != null) {
                way.getTags().add(new Tag("nearest_neighbor_country_code", usingNearestNeighbor));
            }
            return Optional.empty();
        }
        if ((long)slices.size() < 1000L) {
            RuntimeCounter.waySliced();
            CountrySlicingIdentifierFactory wayIdentifierFactory = new CountrySlicingIdentifierFactory(way.getId());
            CountrySlicingIdentifierFactory nodeIdentifierFactory = new CountrySlicingIdentifierFactory(way.getId());
            ArrayList<Way> createdWays = new ArrayList<Way>();
            for (Geometry slice : slices) {
                Coordinate[] points;
                if (this.isOutsideWorkingBound(slice)) continue;
                ArrayList<WayNode> newWayNodes = new ArrayList<WayNode>(slice.getNumPoints());
                for (Coordinate coordinate : points = slice.getCoordinates()) {
                    CountrySlicingProcessor.roundCoordinate(coordinate);
                    Node node = (Node)coordinateToNode.get(coordinate);
                    if (node != null) {
                        newWayNodes.add(new WayNode(node.getId()));
                        continue;
                    }
                    if (!nodeIdentifierFactory.hasMore()) {
                        logger.error("Country slicing exceeded max number({}) of supported new nodes for way {}", (Object)1000L, (Object)way.getId());
                        return Optional.empty();
                    }
                    Map<String, String> boundaryNodeTags = Maps.hashMap("synthetic_boundary_node", SyntheticBoundaryNodeTag.YES.name().toLowerCase());
                    node = this.store.createNode(nodeIdentifierFactory.nextIdentifier(), coordinate.y, coordinate.x, boundaryNodeTags);
                    this.changeSet.addCreatedNode(node);
                    coordinateToNode.put(coordinate, node);
                    identifierToNode.put(node.getId(), node);
                    newWayNodes.add(new WayNode(node.getId()));
                }
                String countryCode = CountryBoundaryMap.getGeometryProperty(slice, "iso_country_code");
                String usingNearestNeighbor = CountryBoundaryMap.getGeometryProperty(slice, "nearest_neighbor_country_code");
                Way createdWay = this.store.createWay(way, wayIdentifierFactory.nextIdentifier(), newWayNodes);
                createdWay.getTags().add(new Tag("iso_country_code", countryCode));
                if (usingNearestNeighbor != null) {
                    createdWay.getTags().add(new Tag("nearest_neighbor_country_code", usingNearestNeighbor));
                }
                createdWays.add(createdWay);
                if (!this.store.isAtlasEdge(createdWay)) continue;
                Node nodeStart = (Node)identifierToNode.get(((WayNode)newWayNodes.get(0)).getNodeId());
                Node nodeEnd = (Node)identifierToNode.get(((WayNode)newWayNodes.get(newWayNodes.size() - 1)).getNodeId());
                CountrySlicingProcessor.tagCountry(nodeStart, countryCode, usingNearestNeighbor);
                CountrySlicingProcessor.tagCountry(nodeEnd, countryCode, usingNearestNeighbor);
            }
            for (Way createdWay : createdWays) {
                this.changeSet.addCreatedWay(createdWay, way.getId());
            }
            this.changeSet.addDeletedWay(way);
            return Optional.of(createdWays);
        }
        logger.error("Country slicing exceeded maximum number of supported pieces {} for way {}", (Object)1000L, (Object)way.getId());
        return Optional.empty();
    }

    private Geometry toGeometry(Way way) {
        List<WayNode> wayNodes = way.getWayNodes();
        if (wayNodes.size() < 2) {
            return null;
        }
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        HashMap coordinateToNode = new HashMap(wayNodes.size() + 2);
        wayNodes.forEach(wayNode -> {
            Node node = this.store.getNode(wayNode.getNodeId());
            Coordinate coordinate = new Coordinate(node.getLongitude(), node.getLatitude());
            coordinates.add(coordinate);
            coordinateToNode.put(coordinate, node);
        });
        Geometry geometry = !way.isClosed() ? JtsUtility.buildLineString(coordinates.toArray(new Coordinate[0])) : JtsUtility.toPolygon(coordinates);
        return geometry;
    }

    public class PolygonPiece {
        private final List<Coordinate> coordinates;
        private final long identifier;

        public PolygonPiece(Way way) {
            this.identifier = way.getId();
            Coordinate[] coordinates = CountrySlicingProcessor.this.toGeometry(way).getCoordinates();
            this.coordinates = new ArrayList<Coordinate>();
            for (Coordinate coordinate : coordinates) {
                this.coordinates.add(coordinate);
            }
        }

        public boolean equals(Object other) {
            return other instanceof PolygonPiece && this.identifier == ((PolygonPiece)other).identifier;
        }

        public List<Coordinate> getCoordinates() {
            return this.coordinates;
        }

        public Coordinate getEndNode() {
            return this.coordinates.get(this.coordinates.size() - 1);
        }

        public long getIdentifier() {
            return this.identifier;
        }

        public Coordinate getStartNode() {
            return this.coordinates.get(0);
        }

        public int hashCode() {
            return (int)this.identifier;
        }

        public void merge(PolygonPiece otherPiece, boolean isReverseSelf, boolean isReverseOther) {
            if (isReverseSelf) {
                Collections.reverse(this.coordinates);
            }
            if (isReverseOther) {
                Collections.reverse(otherPiece.getCoordinates());
            }
            this.coordinates.addAll(otherPiece.getCoordinates());
        }

        private boolean isClosed() {
            return this.coordinates.get(0).equals(this.coordinates.get(this.coordinates.size() - 1));
        }
    }
}

