/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.pbf.slicing;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.atlas.utilities.maps.MultiMap;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeSet {
    private static final Logger logger = LoggerFactory.getLogger(ChangeSet.class);
    private final List<Node> createdNodes = new ArrayList<Node>();
    private final List<Node> deletedNodes = new ArrayList<Node>();
    private final List<Way> createdWays = new ArrayList<Way>();
    private final List<Way> deletedWays = new ArrayList<Way>();
    private final List<Relation> createdRelations = new ArrayList<Relation>();
    private final List<Relation> modifiedRelation;
    private final List<Relation> deletedRelations = new ArrayList<Relation>();
    private final MultiMap<Long, Way> wayMap;

    public ChangeSet() {
        this.modifiedRelation = new ArrayList<Relation>();
        this.wayMap = new MultiMap();
    }

    public void addCreatedNode(Node createdNode) {
        this.createdNodes.add(createdNode);
    }

    public void addCreatedRelation(Relation relation) {
        this.createdRelations.add(relation);
    }

    public void addCreatedWay(Way createdWay) {
        this.createdWays.add(createdWay);
    }

    public void addCreatedWay(Way createdWay, long originalWayIdentifier) {
        this.createdWays.add(createdWay);
        this.wayMap.add(originalWayIdentifier, createdWay);
    }

    public void addDeletedNode(Node node) {
        this.deletedNodes.add(node);
    }

    public void addDeletedRelation(Relation relation) {
        this.deletedRelations.add(relation);
    }

    public void addDeletedWay(Way way) {
        this.deletedWays.add(way);
    }

    public void addModifiedRelation(Relation relation) {
        this.modifiedRelation.add(relation);
    }

    public List<Node> getCreatedNodes() {
        return this.createdNodes;
    }

    public List<Relation> getCreatedRelations() {
        return this.createdRelations;
    }

    public List<Way> getCreatedWays() {
        return this.createdWays;
    }

    public List<Way> getCreatedWays(long originalWayIdentifier) {
        return this.wayMap.get(originalWayIdentifier);
    }

    public List<Node> getDeletedNodes() {
        return this.deletedNodes;
    }

    public List<Relation> getDeletedRelations() {
        return this.deletedRelations;
    }

    public List<Way> getDeletedWays() {
        return this.deletedWays;
    }

    public List<Relation> getModifiedRelation() {
        return this.modifiedRelation;
    }

    public MultiMap<Long, Way> getWayMap() {
        return this.wayMap;
    }

    public boolean hasWay(long wayIdentifier) {
        return this.wayMap.containsKey(wayIdentifier);
    }

    public void save(OutputStream output) {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));
            for (Way way : this.createdWays) {
                writer.write("create,way,");
                writer.write(String.valueOf(way.getId()));
                writer.newLine();
            }
            writer.write("======new relations=====\n");
            for (Relation toBeAddedRelation : this.createdRelations) {
                writer.write("nr: ");
                writer.write(toBeAddedRelation.toString());
                writer.newLine();
            }
            writer.write("======old ways======\n");
            for (Way toBeRemovedWay : this.deletedWays) {
                writer.write("ow: ");
                writer.write(toBeRemovedWay.toString());
                writer.newLine();
            }
            writer.write("======old relations=====\n");
            for (Relation toBeRemovedRelation : this.deletedRelations) {
                writer.write("or: ");
                writer.write(toBeRemovedRelation.toString());
                writer.newLine();
            }
            writer.write("======modified relations=====\n");
            for (Relation modified : this.modifiedRelation) {
                writer.write("or: ");
                writer.write(modified.toString());
                writer.newLine();
            }
            writer.close();
        }
        catch (IOException e) {
            logger.error("Could not save ChangeSet", (Throwable)e);
        }
    }
}

