/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.pbf;

import java.util.function.Supplier;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasMetaData;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasBuilder;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.pbf.CloseableOsmosisReader;
import org.openstreetmap.atlas.geography.atlas.pbf.OsmPbfProcessor;
import org.openstreetmap.atlas.streaming.Streams;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmPbfLoader {
    private static final Logger logger = LoggerFactory.getLogger(OsmPbfLoader.class);
    private final PackedAtlasBuilder builder = new PackedAtlasBuilder();
    private final OsmPbfProcessor processor;
    private final Supplier<CloseableOsmosisReader> osmosisReaderSupplier;
    private CloseableOsmosisReader reader;
    private Atlas atlas;
    private AtlasMetaData metaData = new AtlasMetaData();
    private final AtlasLoadingOption atlasLoadingOption;

    public OsmPbfLoader(Resource resource) {
        this(resource, MultiPolygon.MAXIMUM, AtlasLoadingOption.createOptionWithNoSlicing());
    }

    public OsmPbfLoader(Resource resource, AtlasLoadingOption option) {
        this(resource, MultiPolygon.MAXIMUM, option);
    }

    public OsmPbfLoader(Resource resource, MultiPolygon polygon) {
        this(resource, polygon, AtlasLoadingOption.createOptionWithNoSlicing());
    }

    public OsmPbfLoader(Resource resource, MultiPolygon polygon, AtlasLoadingOption loadingOption) {
        this(() -> new CloseableOsmosisReader(resource.read()), polygon, loadingOption);
    }

    protected OsmPbfLoader(Supplier<CloseableOsmosisReader> osmosisReaderSupplier, MultiPolygon polygon, AtlasLoadingOption loadingOption) {
        this.osmosisReaderSupplier = osmosisReaderSupplier;
        this.processor = new OsmPbfProcessor(this.builder, loadingOption, polygon);
        this.atlasLoadingOption = loadingOption;
    }

    public Atlas read() {
        if (this.atlas == null) {
            this.makeNewReader();
            this.reader.run();
            this.makeNewReader();
            this.reader.run();
            logger.info("Finished reading PBF, now retrieve atlas");
            this.metaData.getTags().put("edgeConfiguration", this.atlasLoadingOption.getEdgeFilter().toString());
            this.metaData.getTags().put("waySectioningConfiguration", this.atlasLoadingOption.getWaySectionFilter().toString());
            this.metaData.getTags().put("osmPbfNodeConfiguration", this.atlasLoadingOption.getOsmPbfNodeFilter().toString());
            this.metaData.getTags().put("osmPbfWayConfiguration", this.atlasLoadingOption.getOsmPbfWayFilter().toString());
            this.metaData.getTags().put("osmPbfRelationConfiguration", this.atlasLoadingOption.getOsmPbfRelationFilter().toString());
            this.builder.setMetaData(this.metaData);
            this.atlas = this.builder.get();
            if (this.atlas != null) {
                logger.info("Finished building atlas {}", (Object)this.atlas.getName());
            } else {
                logger.info("No Atlas (empty) for shard {}", (Object)this.metaData.getShardName().orElse("unknown"));
            }
        }
        this.closeReader();
        return this.atlas;
    }

    public void saveAsGeojson(WritableResource resource) {
        logger.info("Saving geojson file");
        this.read().saveAsGeoJson(resource);
    }

    public void saveAtlas(WritableResource resource) {
        logger.info("Saving atlas file");
        this.read().save(resource);
    }

    public OsmPbfLoader withMetaData(AtlasMetaData metaData) {
        this.metaData = metaData;
        return this;
    }

    private void closeReader() {
        if (this.reader != null) {
            Streams.close(this.reader);
        }
    }

    private void makeNewReader() {
        this.closeReader();
        this.reader = this.osmosisReaderSupplier.get();
        this.reader.setSink(this.processor);
    }
}

