/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.multi;

import java.util.Map;
import org.openstreetmap.atlas.geography.PolyLine;

public class TemporaryEdge {
    private final long identifier;
    private final PolyLine polyLine;
    private final long startNodeIdentifier;
    private final long endNodeIdentifier;
    private final Map<String, String> tags;

    public TemporaryEdge(long identifier, PolyLine polyLine, long startNodeIdentifier, long endNodeIdentifier, Map<String, String> tags) {
        this.identifier = identifier;
        this.polyLine = polyLine;
        this.startNodeIdentifier = startNodeIdentifier;
        this.endNodeIdentifier = endNodeIdentifier;
        this.tags = tags;
    }

    public long getEndNodeIdentifier() {
        return this.endNodeIdentifier;
    }

    public long getIdentifier() {
        return this.identifier;
    }

    public PolyLine getPolyLine() {
        return this.polyLine;
    }

    public long getReversedIdentifier() {
        return -1L * Math.abs(this.getIdentifier());
    }

    public long getStartNodeIdentifier() {
        return this.startNodeIdentifier;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public String toString() {
        return "[TemporaryEdge: id = " + this.identifier + ", startNode = " + this.startNodeIdentifier + ", endNode = " + this.endNodeIdentifier + ", geom = " + this.polyLine + "]";
    }
}

