/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.multi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.builder.AtlasSize;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.multi.TemporaryEdge;
import org.openstreetmap.atlas.geography.atlas.multi.TemporaryOrderedLocation;
import org.openstreetmap.atlas.geography.atlas.multi.TemporaryOrderedNode;
import org.openstreetmap.atlas.geography.atlas.multi.TemporaryRelation;
import org.openstreetmap.atlas.geography.atlas.multi.TemporaryRelationMember;
import org.openstreetmap.atlas.geography.atlas.multi.TemporaryRoad;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasBuilder;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.identifier.ReverseIdentifierFactory;
import org.openstreetmap.atlas.utilities.maps.MultiMap;
import org.openstreetmap.atlas.utilities.maps.MultiMapWithSet;
import org.openstreetmap.atlas.utilities.scalars.Ratio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiAtlasBorderFixer
implements Serializable {
    private static final long serialVersionUID = -3774372864489402091L;
    private static final Logger logger = LoggerFactory.getLogger(MultiAtlasBorderFixer.class);
    private static final String MISSING_FIX_ATLAS = "Fix Atlas is not present.";
    private boolean isCompleted = false;
    private final MultiMapWithSet<Long, Long> nodeIdentifiersToRemovedInEdges;
    private final MultiMapWithSet<Long, Long> nodeIdentifiersToRemovedOutEdges;
    private final MultiMapWithSet<Long, Long> relationIdentifiersToRemovedEdgeMembers;
    private final Set<Long> fixedCountryOsmIdentifiers;
    private transient Optional<Atlas> fixAtlas = Optional.empty();
    private final List<Atlas> subAtlases;
    private final HashSet<Long> countryOsmIdentifierWithReverseEdges;
    private final MultiMap<Long, Long> countryOsmIdentifierToEdgeIdentifiers;

    protected MultiAtlasBorderFixer(List<Atlas> subAtlases, Iterable<Long> edgeIdentifiers) {
        this.nodeIdentifiersToRemovedInEdges = new MultiMapWithSet();
        this.nodeIdentifiersToRemovedOutEdges = new MultiMapWithSet();
        this.relationIdentifiersToRemovedEdgeMembers = new MultiMapWithSet();
        this.fixedCountryOsmIdentifiers = new HashSet<Long>();
        this.subAtlases = subAtlases;
        this.countryOsmIdentifierToEdgeIdentifiers = new MultiMap();
        this.countryOsmIdentifierWithReverseEdges = new HashSet();
        edgeIdentifiers.forEach(edgeIdentifier -> {
            long countryOsmIdentifier = this.getCountryOsmIdentifier((long)edgeIdentifier);
            if (Edge.isMasterEdgeIdentifier(edgeIdentifier)) {
                this.countryOsmIdentifierToEdgeIdentifiers.add(countryOsmIdentifier, (Long)edgeIdentifier);
            } else {
                this.countryOsmIdentifierWithReverseEdges.add(countryOsmIdentifier);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fixBorderIssues() {
        this.isCompleted = false;
        this.fixAtlas = Optional.empty();
        HashSet<Long> processedCountryOsmIdentifiers = new HashSet<Long>();
        HashMap<Long, Node> nodeIdentifiersToNewNodes = new HashMap<Long, Node>();
        ArrayList<TemporaryEdge> newEdgeList = new ArrayList<TemporaryEdge>();
        HashSet<TemporaryRelation> relationsToUpdate = new HashSet<TemporaryRelation>();
        MultiMapWithSet relationMembersToUpdate = new MultiMapWithSet();
        for (Map.Entry<Long, List<Long>> countryOsmIdentifierEdgeIdentifiersPair : this.countryOsmIdentifierToEdgeIdentifiers.entrySet()) {
            long countryOsmIdentifier = countryOsmIdentifierEdgeIdentifiersPair.getKey();
            if (processedCountryOsmIdentifiers.contains(countryOsmIdentifier)) continue;
            List<Long> edgeIdentifiers = countryOsmIdentifierEdgeIdentifiersPair.getValue();
            long osmIdentifier = this.getOsmIdentifier(edgeIdentifiers.get(0));
            MultiMap<Long, Edge> identifierToEdgeList = this.createIdentifierToEdgeMultiMap(edgeIdentifiers);
            if (!(this.hasInconsistentIdentifier(countryOsmIdentifier, identifierToEdgeList) || this.hasInconsistentEdges(identifierToEdgeList) || this.hasInconsistentRelations(identifierToEdgeList))) {
                processedCountryOsmIdentifiers.add(countryOsmIdentifier);
                continue;
            }
            boolean hasReverseEdges = this.countryOsmIdentifierWithReverseEdges.contains(countryOsmIdentifier);
            List<Edge> edges = identifierToEdgeList.allValues();
            List<TemporaryRoad> roads = this.createRoadsPerSubAtlas(countryOsmIdentifier, edges);
            try {
                if (!this.areRoadsConsistent(roads)) {
                    logger.warn("Roads {} generated for OSM way {} were not consistent. Skipping fix!", roads, (Object)countryOsmIdentifier);
                    continue;
                }
                Map<String, String> tags = this.collectTags(roads);
                PolyLine line = this.createPolyLineFromRoads(roads);
                Set<TemporaryRelation> candidateRelations = this.collectRelations(edges);
                MultiMapWithSet<Long, String> candidateRoles = this.collectRoles(candidateRelations, osmIdentifier);
                MultiMapWithSet<Long, Set> candidateRelationMembers = new MultiMapWithSet<Long, Set>();
                SortedSet<TemporaryOrderedNode> nodes = this.createTemporaryOrderedNodeList(roads);
                HashMap candidateNodeIdentifiersToNewNodes = new HashMap();
                ArrayList<TemporaryEdge> candidateEdgeList = new ArrayList<TemporaryEdge>();
                nodes.forEach(temporaryNode -> candidateNodeIdentifiersToNewNodes.put(temporaryNode.getNodeIdentifier(), temporaryNode.getNode()));
                long newEdgeIdentifier = this.getStartIdentifier(countryOsmIdentifier);
                TemporaryOrderedNode previousNodePointer = null;
                for (TemporaryOrderedNode currNodePointer : nodes) {
                    if (previousNodePointer != null) {
                        Node previousNode = previousNodePointer.getNode();
                        Location previousLocation = previousNode.getLocation();
                        long previousIdentifier = previousNode.getIdentifier();
                        int previousOccurrenceIndex = previousNodePointer.getOccurrenceIndex();
                        Node currentNode = currNodePointer.getNode();
                        Location currentLocation = currentNode.getLocation();
                        long currentIdentifier = currentNode.getIdentifier();
                        int currentOccurrenceIndex = currNodePointer.getOccurrenceIndex();
                        PolyLine polyLine = line.between(previousLocation, previousOccurrenceIndex, currentLocation, currentOccurrenceIndex);
                        TemporaryEdge newEdge = new TemporaryEdge(++newEdgeIdentifier, polyLine, previousIdentifier, currentIdentifier, tags);
                        candidateEdgeList.add(newEdge);
                        if (hasReverseEdges) {
                            TemporaryEdge newReverseEdge = new TemporaryEdge(newEdge.getReversedIdentifier(), polyLine.reversed(), currentIdentifier, previousIdentifier, tags);
                            candidateEdgeList.add(newReverseEdge);
                        }
                        candidateRoles.forEach((relationIdentifier, roles) -> {
                            if (roles != null && !roles.isEmpty()) {
                                for (String role : roles) {
                                    candidateRelationMembers.add((Long)relationIdentifier, (Set)((Object)new TemporaryRelationMember(newEdge.getIdentifier(), role, ItemType.EDGE)));
                                    if (!hasReverseEdges) continue;
                                    candidateRelationMembers.add((Long)relationIdentifier, (Set)((Object)new TemporaryRelationMember(newEdge.getReversedIdentifier(), role, ItemType.EDGE)));
                                }
                            } else {
                                logger.error("Edge {} is missing roles {} in relation {}.", new Object[]{osmIdentifier, roles, relationIdentifier});
                            }
                        });
                    }
                    previousNodePointer = currNodePointer;
                }
                nodeIdentifiersToNewNodes.putAll(candidateNodeIdentifiersToNewNodes);
                newEdgeList.addAll(candidateEdgeList);
                relationsToUpdate.addAll(candidateRelations);
                candidateRelationMembers.forEach((identifier, temporaryRelationMember) -> temporaryRelationMember.forEach(member -> relationMembersToUpdate.add(identifier, member)));
                this.markItemsToBeIgnored(roads, hasReverseEdges);
                this.fixedCountryOsmIdentifiers.add(countryOsmIdentifier);
            }
            catch (Exception e) {
                logger.warn("OSM way {} fix for {} is failed.", new Object[]{osmIdentifier, roads, e});
            }
            finally {
                processedCountryOsmIdentifiers.add(countryOsmIdentifier);
            }
        }
        try {
            for (TemporaryRelation relation : relationsToUpdate) {
                Object members = relationMembersToUpdate.get(relation.getIdentifier());
                if (members != null && !members.isEmpty()) {
                    members.forEach(relation::addMember);
                    continue;
                }
                logger.error("Relation {} was identified for an update. However, no fixed edge was added as a member.", (Object)relation.getIdentifier());
            }
            this.fixAtlas = this.applyFixesToAtlas(nodeIdentifiersToNewNodes, newEdgeList, relationsToUpdate);
            this.isCompleted = true;
        }
        catch (Exception e) {
            logger.error("Border fix process has failed.", (Throwable)e);
        }
    }

    protected Edge fixEdge(long identifier) {
        return this.fixAtlas.orElseThrow(() -> new CoreException(MISSING_FIX_ATLAS)).edge(identifier);
    }

    protected Node fixNode(long identifier) {
        return this.fixAtlas.orElseThrow(() -> new CoreException(MISSING_FIX_ATLAS)).node(identifier);
    }

    protected Relation fixRelation(Long identifier) {
        return this.fixAtlas.orElseThrow(() -> new CoreException(MISSING_FIX_ATLAS)).relation(identifier);
    }

    protected Atlas getFixAtlas() {
        return this.fixAtlas.orElseThrow(() -> new CoreException(MISSING_FIX_ATLAS));
    }

    protected MultiMapWithSet<Long, Long> getNodeIdentifiersToRemovedInEdges() {
        if (this.isCompleted) {
            return this.nodeIdentifiersToRemovedInEdges;
        }
        return new MultiMapWithSet<Long, Long>();
    }

    protected MultiMapWithSet<Long, Long> getNodeIdentifiersToRemovedOutEdges() {
        if (this.isCompleted) {
            return this.nodeIdentifiersToRemovedOutEdges;
        }
        return new MultiMapWithSet<Long, Long>();
    }

    protected MultiMapWithSet<Long, Long> getRelationIdentifiersToRemovedEdgeMembers() {
        if (this.isCompleted) {
            return this.relationIdentifiersToRemovedEdgeMembers;
        }
        return new MultiMapWithSet<Long, Long>();
    }

    protected boolean hasFixes() {
        return this.fixAtlas.isPresent();
    }

    protected boolean isFixEdgeIdentifier(long identifier) {
        long osmIdentifier = this.getCountryOsmIdentifier(identifier);
        return this.fixedCountryOsmIdentifiers.contains(osmIdentifier);
    }

    protected boolean nodeIsFixed(long nodeIdentifier) {
        return this.nodeIdentifiersToRemovedInEdges.get(nodeIdentifier) != null || this.nodeIdentifiersToRemovedOutEdges.get(nodeIdentifier) != null;
    }

    protected boolean relationIsFixed(long relationIdentifier) {
        return this.relationIdentifiersToRemovedEdgeMembers.get(relationIdentifier) != null;
    }

    private Optional<Atlas> applyFixesToAtlas(Map<Long, Node> newNodes, List<TemporaryEdge> newEdges, Collection<TemporaryRelation> newRelations) {
        if (newNodes.isEmpty() && newEdges.isEmpty() && newRelations.isEmpty()) {
            logger.debug("No fix is applied.");
            return Optional.empty();
        }
        AtlasSize fixSizeEstimates = new AtlasSize(newEdges.size(), newNodes.size(), 0L, 0L, 0L, newRelations.size());
        PackedAtlasBuilder fixBuilder = new PackedAtlasBuilder().withSizeEstimates(fixSizeEstimates);
        for (Map.Entry<Long, Node> nodeEntry : newNodes.entrySet()) {
            Node node = nodeEntry.getValue();
            fixBuilder.addNode(nodeEntry.getKey(), node.getLocation(), node.getTags());
        }
        for (TemporaryEdge newEdge : newEdges) {
            long newEdgeIdentifier = newEdge.getIdentifier();
            fixBuilder.addEdge(newEdgeIdentifier, newEdge.getPolyLine(), newEdge.getTags());
        }
        for (TemporaryRelation newRelation : newRelations) {
            fixBuilder.addRelation(newRelation.getIdentifier(), newRelation.getOsmIdentifier(), newRelation.getRelationBean(), newRelation.getTags());
        }
        Atlas fixedAtlas = fixBuilder.get();
        logger.debug("Fix atlas meta data: {}", (Object)fixedAtlas.metaData());
        return Optional.of(fixedAtlas);
    }

    private boolean areRoadsConsistent(List<TemporaryRoad> roads) {
        PolyLine referencePolyLine = this.createPolyLineFromRoad(roads.get(0));
        for (int i = 1; i < roads.size(); ++i) {
            PolyLine otherPolyLine = this.createPolyLineFromRoad(roads.get(i));
            if (referencePolyLine.equalsShape(otherPolyLine)) continue;
            return false;
        }
        return true;
    }

    private Set<TemporaryRelation> collectRelations(List<Edge> edges) {
        HashSet<TemporaryRelation> relations = new HashSet<TemporaryRelation>();
        edges.forEach(edge -> edge.relations().forEach(relation -> relations.add(new TemporaryRelation((Relation)relation))));
        return relations;
    }

    private MultiMapWithSet<Long, String> collectRoles(Set<TemporaryRelation> candidateRelations, long osmIdentifier) {
        MultiMapWithSet<Long, String> roles = new MultiMapWithSet<Long, String>();
        for (TemporaryRelation relation : candidateRelations) {
            for (RelationMember member : relation.getOldMembers()) {
                long memberIdentifier = member.getEntity().getOsmIdentifier();
                if (memberIdentifier != osmIdentifier) continue;
                try {
                    long relationIdentifier = relation.getIdentifier();
                    String role = member.getRole();
                    roles.add(relationIdentifier, role);
                }
                catch (Exception error) {
                    throw new CoreException("Error adding in roles: {}", relation, error);
                }
            }
        }
        return roles;
    }

    private Map<String, String> collectTags(List<TemporaryRoad> roads) {
        HashMap<String, String> tags = new HashMap<String, String>();
        roads.forEach(road -> road.getMembers().forEach(edge -> tags.putAll(edge.getTags())));
        return tags;
    }

    private MultiMap<Long, Edge> createIdentifierToEdgeMultiMap(List<Long> edgeIdentifiers) {
        MultiMap<Long, Edge> edgeIdToEdges = new MultiMap<Long, Edge>();
        for (Long candidateIdentifier : edgeIdentifiers) {
            for (Atlas subAtlas : this.subAtlases) {
                Edge candidate = subAtlas.edge(candidateIdentifier);
                if (candidate == null) continue;
                edgeIdToEdges.add(candidate.getIdentifier(), candidate);
            }
        }
        return edgeIdToEdges;
    }

    private PolyLine createPolyLineFromRoad(TemporaryRoad road) {
        SortedSet<TemporaryOrderedLocation> temporaryNodeSet = this.createTemporaryOrderedLocations(road);
        return new PolyLine(temporaryNodeSet.stream().map(TemporaryOrderedLocation::getLocation).collect(Collectors.toList()));
    }

    private PolyLine createPolyLineFromRoads(List<TemporaryRoad> roads) {
        TreeSet<TemporaryOrderedLocation> temporaryNodeSet = new TreeSet<TemporaryOrderedLocation>();
        for (TemporaryRoad road : roads) {
            temporaryNodeSet.addAll(this.createTemporaryOrderedLocations(road));
        }
        return new PolyLine(temporaryNodeSet.stream().map(TemporaryOrderedLocation::getLocation).collect(Collectors.toList()));
    }

    private List<TemporaryRoad> createRoadsPerSubAtlas(long osmIdentifier, List<Edge> edges) {
        HashMap<Integer, TemporaryRoad> edgesPerSubAtlas = new HashMap<Integer, TemporaryRoad>();
        for (Atlas subAtlas : this.subAtlases) {
            edgesPerSubAtlas.put(subAtlas.getIdentifier(), new TemporaryRoad(subAtlas, osmIdentifier));
        }
        for (Edge edge : edges) {
            ((TemporaryRoad)edgesPerSubAtlas.get(edge.getAtlas().getIdentifier())).add(edge);
        }
        edgesPerSubAtlas.values().removeIf(road -> road.getMembers().isEmpty());
        return new ArrayList<TemporaryRoad>(edgesPerSubAtlas.values());
    }

    private SortedSet<TemporaryOrderedLocation> createTemporaryOrderedLocations(TemporaryRoad road) {
        String locationIdentifier;
        TreeSet<TemporaryOrderedLocation> temporaryNodeSet = new TreeSet<TemporaryOrderedLocation>();
        HashMap<String, Integer> locationToTimesSeenSoFar = new HashMap<String, Integer>();
        PolyLine line = new PolyLine(road.locations());
        for (Location location : road.locations()) {
            locationIdentifier = location.toString();
            locationToTimesSeenSoFar.putIfAbsent(locationIdentifier, 0);
        }
        for (Location location : road.locations()) {
            locationIdentifier = location.toString();
            locationToTimesSeenSoFar.put(locationIdentifier, (Integer)locationToTimesSeenSoFar.get(locationIdentifier) + 1);
            int locationTimesSeenSoFar = (Integer)locationToTimesSeenSoFar.get(locationIdentifier);
            int occurrenceIndex = locationTimesSeenSoFar - 1;
            Ratio offset = line.offsetFromStart(location, occurrenceIndex);
            TemporaryOrderedLocation newTemporaryNode = new TemporaryOrderedLocation(location, offset, occurrenceIndex);
            if (temporaryNodeSet.contains(newTemporaryNode)) continue;
            temporaryNodeSet.add(newTemporaryNode);
        }
        return temporaryNodeSet;
    }

    private SortedSet<TemporaryOrderedNode> createTemporaryOrderedNodeList(List<TemporaryRoad> roads) {
        TreeSet<TemporaryOrderedNode> temporaryNodeSet = new TreeSet<TemporaryOrderedNode>();
        for (TemporaryRoad road : roads) {
            long nodeIdentifier;
            PolyLine line = road.getRoute().asPolyLine();
            HashMap<Long, Integer> nodeIdentifierToOccurenceMap = new HashMap<Long, Integer>();
            HashMap<Long, Integer> nodeIdentifierToTimesSeenSoFar = new HashMap<Long, Integer>();
            for (Node node : road.getRoute().nodes()) {
                nodeIdentifier = node.getIdentifier();
                int count = nodeIdentifierToOccurenceMap.containsKey(nodeIdentifier) ? (Integer)nodeIdentifierToOccurenceMap.get(nodeIdentifier) + 1 : 1;
                nodeIdentifierToOccurenceMap.put(nodeIdentifier, count);
                nodeIdentifierToTimesSeenSoFar.putIfAbsent(nodeIdentifier, 0);
            }
            for (Node node : road.getRoute().nodes()) {
                nodeIdentifier = node.getIdentifier();
                nodeIdentifierToTimesSeenSoFar.put(nodeIdentifier, (Integer)nodeIdentifierToTimesSeenSoFar.get(nodeIdentifier) + 1);
                int occurrenceIndex = (Integer)nodeIdentifierToOccurenceMap.get(nodeIdentifier) - (Integer)nodeIdentifierToTimesSeenSoFar.get(nodeIdentifier);
                Ratio offset = line.offsetFromStart(node.getLocation(), occurrenceIndex);
                TemporaryOrderedNode newTemporaryNode = new TemporaryOrderedNode(node, offset, occurrenceIndex);
                if (!temporaryNodeSet.contains(newTemporaryNode)) {
                    temporaryNodeSet.add(newTemporaryNode);
                    continue;
                }
                if (nodeIdentifier == newTemporaryNode.getNodeIdentifier()) continue;
                logger.warn("Node {} (vs a node with id {}) is appearing in different subatlases at the same location.", (Object)newTemporaryNode, (Object)nodeIdentifier);
            }
        }
        return temporaryNodeSet;
    }

    private long getCountryOsmIdentifier(long edgeIdentifier) {
        return new ReverseIdentifierFactory().getCountryOsmIdentifier(edgeIdentifier);
    }

    private long getOsmIdentifier(long edgeIdentifier) {
        return new ReverseIdentifierFactory().getOsmIdentifier(edgeIdentifier);
    }

    private long getStartIdentifier(long osmIdentifier) {
        return new ReverseIdentifierFactory().getStartIdentifier(osmIdentifier);
    }

    private boolean hasInconsistentEdges(MultiMap<Long, Edge> edgesPerEdgeIdentifier) {
        for (List<Edge> edgeListForSameIdentifier : edgesPerEdgeIdentifier.values()) {
            Edge referenceEdge = edgeListForSameIdentifier.get(0);
            PolyLine referenceGeometry = referenceEdge.asPolyLine();
            for (int i = 1; i < edgeListForSameIdentifier.size(); ++i) {
                PolyLine similarGeometry = edgeListForSameIdentifier.get(i).asPolyLine();
                if (referenceGeometry.equals(similarGeometry)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasInconsistentIdentifier(long osmIdentifier, MultiMap<Long, Edge> edgesPerEdgeIdentifier) {
        long startEdgeIdentifier = this.getStartIdentifier(osmIdentifier);
        for (Long referenceIdentifier : edgesPerEdgeIdentifier.keySet()) {
            if (referenceIdentifier != startEdgeIdentifier || edgesPerEdgeIdentifier.size() <= 1) continue;
            return true;
        }
        return false;
    }

    private boolean hasInconsistentRelations(MultiMap<Long, Edge> identifierToEdgeList) {
        for (Long edgeListForSameIdentifier : identifierToEdgeList.keySet()) {
            Object valuesForCurrentKey = identifierToEdgeList.get(edgeListForSameIdentifier);
            Edge firstEdge = (Edge)valuesForCurrentKey.get(0);
            Set<Relation> masterRelations = firstEdge.relations();
            for (int index = 1; index < valuesForCurrentKey.size(); ++index) {
                Edge comparisonEdge = (Edge)valuesForCurrentKey.get(index);
                Set<Relation> candidateRelations = comparisonEdge.relations();
                if (Objects.equals(masterRelations, candidateRelations)) continue;
                return true;
            }
        }
        return false;
    }

    private void markItemsToBeIgnored(List<TemporaryRoad> roads, boolean hasReverseEdges) {
        for (TemporaryRoad road : roads) {
            for (Edge edge : road.getRoute()) {
                Long edgeIdentifier = edge.getIdentifier();
                this.nodeIdentifiersToRemovedInEdges.add(edge.end().getIdentifier(), edgeIdentifier);
                this.nodeIdentifiersToRemovedOutEdges.add(edge.start().getIdentifier(), edgeIdentifier);
                edge.relations().forEach(relation -> this.relationIdentifiersToRemovedEdgeMembers.add(relation.getIdentifier(), edgeIdentifier));
                if (!hasReverseEdges) continue;
                Long reversedEdgeIdentifier = -edge.getIdentifier();
                this.nodeIdentifiersToRemovedInEdges.add(edge.start().getIdentifier(), reversedEdgeIdentifier);
                this.nodeIdentifiersToRemovedOutEdges.add(edge.end().getIdentifier(), reversedEdgeIdentifier);
                edge.relations().forEach(relation -> this.relationIdentifiersToRemovedEdgeMembers.add(relation.getIdentifier(), reversedEdgeIdentifier));
            }
        }
    }
}

