/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.waters.handler;

import java.util.List;
import java.util.Optional;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.ComplexWaterEntity;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.ComplexWaterbody;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.ComplexWaterway;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.handler.WaterHandler;
import org.slf4j.Logger;

public abstract class AbstractWaterHandler
implements WaterHandler {
    public abstract List<ItemType> getAllowedTypes();

    public abstract Logger getLogger();

    @Override
    public Optional<ComplexWaterEntity> handle(AtlasEntity entity) {
        if (this.canHandle(entity) && this.getAllowedTypes().contains((Object)entity.getType())) {
            return this.handleType(entity);
        }
        return Optional.empty();
    }

    public Optional<ComplexWaterEntity> handleType(AtlasEntity entity) {
        try {
            if (entity instanceof Relation || entity instanceof Area) {
                ComplexWaterbody complexWaterbody = new ComplexWaterbody(entity, this.getType());
                return Optional.of(complexWaterbody);
            }
            if (entity instanceof Line) {
                ComplexWaterway complexWaterway = new ComplexWaterway(entity, this.getType());
                return Optional.of(complexWaterway);
            }
        }
        catch (Exception e) {
            String msg = "Skipping entity : " + entity;
            this.getLogger().warn(msg, (Throwable)e);
        }
        return Optional.empty();
    }
}

