/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.waters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.complex.Finder;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.ComplexWaterEntity;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.WaterType;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.handler.CanalHandler;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.handler.CreekHandler;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.handler.DitchHandler;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.handler.HarbourHandler;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.handler.LagoonHandler;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.handler.LakeHandler;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.handler.PondHandler;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.handler.PoolHandler;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.handler.ReservoirHandler;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.handler.RiverHandler;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.handler.WaterHandler;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.handler.WetlandHandler;
import org.openstreetmap.atlas.tags.RelationTypeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;

public class ComplexWaterEntityFinder
implements Finder<ComplexWaterEntity> {
    private static final Predicate<Relation> RELATION_FILTER = relation -> Validators.isOfType((Taggable)relation, RelationTypeTag.class, (Enum[])new RelationTypeTag[]{RelationTypeTag.MULTIPOLYGON, RelationTypeTag.BOUNDARY, RelationTypeTag.WATERWAY});
    private final Map<WaterType, WaterHandler> handlers = new HashMap<WaterType, WaterHandler>();

    public ComplexWaterEntityFinder() {
        this.handlers.put(WaterType.CANAL, new CanalHandler());
        this.handlers.put(WaterType.CREEK, new CreekHandler());
        this.handlers.put(WaterType.DITCH, new DitchHandler());
        this.handlers.put(WaterType.HARBOUR, new HarbourHandler());
        this.handlers.put(WaterType.LAGOON, new LagoonHandler());
        this.handlers.put(WaterType.LAKE, new LakeHandler());
        this.handlers.put(WaterType.POND, new PondHandler());
        this.handlers.put(WaterType.POOL, new PoolHandler());
        this.handlers.put(WaterType.RESERVOIR, new ReservoirHandler());
        this.handlers.put(WaterType.RIVER, new RiverHandler());
        this.handlers.put(WaterType.WETLAND, new WetlandHandler());
    }

    @Override
    public Iterable<ComplexWaterEntity> find(Atlas atlas) {
        Iterable areaEntities = Iterables.translateMulti(atlas.areas(), this::processEntity);
        Iterable lineEntities = Iterables.translateMulti(atlas.lineItems(), this::processEntity);
        Iterable relationEntities = Iterables.translateMulti(atlas.relations(RELATION_FILTER), this::processEntity);
        return new MultiIterable<ComplexWaterEntity>(areaEntities, lineEntities, relationEntities);
    }

    private List<ComplexWaterEntity> processEntity(AtlasObject object) {
        ArrayList<ComplexWaterEntity> complexWaterEntities = new ArrayList<ComplexWaterEntity>();
        if (object instanceof AtlasEntity) {
            AtlasEntity entity = (AtlasEntity)object;
            this.handlers.forEach((waterType, handler) -> {
                Optional<ComplexWaterEntity> complexWaterEntity = handler.handle(entity);
                if (complexWaterEntity.isPresent()) {
                    complexWaterEntities.add(complexWaterEntity.get());
                }
            });
        }
        return complexWaterEntities;
    }
}

