/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.highwayarea;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.complex.Finder;
import org.openstreetmap.atlas.geography.atlas.items.complex.highwayarea.ComplexHighwayArea;
import org.openstreetmap.atlas.tags.AreaTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.collections.Iterables;

public class ComplexHighwayAreaFinder
implements Finder<ComplexHighwayArea> {
    private static Optional<ComplexHighwayArea> toEntity(Edge edge) {
        ComplexHighwayArea complexHighwayAreaEntity = new ComplexHighwayArea(edge);
        return Optional.of(complexHighwayAreaEntity);
    }

    private static boolean validEdge(Edge edge) {
        return Validators.isNotOfType((Taggable)edge, HighwayTag.class, (Enum[])new HighwayTag[]{HighwayTag.NO}) && Validators.isOfType((Taggable)edge, AreaTag.class, (Enum[])new AreaTag[]{AreaTag.YES}) && edge.isMasterEdge();
    }

    @Override
    public Iterable<ComplexHighwayArea> find(Atlas atlas) {
        HashSet visitedEdgeIdentifiers = new HashSet();
        return Iterables.stream(atlas.edges()).flatMap(edges -> this.processEntity((Edge)edges, visitedEdgeIdentifiers));
    }

    private List<ComplexHighwayArea> processEntity(Edge edge, Set<Long> visitedEdgeIdentifiers) {
        ArrayList<ComplexHighwayArea> returnValue = new ArrayList<ComplexHighwayArea>();
        if (!visitedEdgeIdentifiers.contains(edge.getIdentifier())) {
            Stream.of(edge).filter(ComplexHighwayAreaFinder::validEdge).map(ComplexHighwayAreaFinder::toEntity).filter(Optional::isPresent).map(Optional::get).forEach(area -> {
                visitedEdgeIdentifiers.addAll(area.getVisitedEdgeIdentifiers());
                returnValue.add((ComplexHighwayArea)area);
            });
        }
        return returnValue;
    }
}

