/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.boundaries;

import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.items.RelationMemberList;
import org.openstreetmap.atlas.geography.atlas.items.complex.Finder;
import org.openstreetmap.atlas.geography.atlas.items.complex.boundaries.ComplexBoundary;
import org.openstreetmap.atlas.tags.AdministrativeLevelTag;
import org.openstreetmap.atlas.tags.BoundaryTag;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;

public class ComplexBoundaryFinder
implements Finder<ComplexBoundary> {
    private boolean withSubAreas = false;
    private Optional<Integer> administrativeLevel = Optional.empty();

    @Override
    public Iterable<ComplexBoundary> find(Atlas atlas) {
        return Iterables.stream(new MultiIterable(atlas.relations(), atlas.areas())).filter(BoundaryTag::isAdministrative).filter(this::subAreaFilter).map(entity -> new ComplexBoundary((AtlasEntity)entity, this.withSubAreas, this.administrativeLevel));
    }

    public void setAdministrativeLevel(int administrativeLevel) {
        long minimum = AdministrativeLevelTag.minimumAdministrativeLevelValue();
        long maximum = AdministrativeLevelTag.maximumAdministrativeLevelValue();
        if ((long)administrativeLevel < minimum || (long)administrativeLevel > maximum) {
            throw new CoreException("Invalid administrative level: {}. Should be between {} and {} included.", administrativeLevel, minimum, maximum);
        }
        this.administrativeLevel = Optional.of(administrativeLevel);
    }

    public void setWithSubAreas(boolean withSubAreas) {
        this.withSubAreas = withSubAreas;
    }

    private boolean isSubArea(AtlasEntity entity) {
        Set<Relation> parentRelations = entity.relations();
        for (Relation parentRelation : parentRelations) {
            if (!BoundaryTag.isAdministrative(parentRelation)) continue;
            RelationMemberList children = parentRelation.members();
            for (RelationMember child : children) {
                AtlasEntity childEntity = child.getEntity();
                if (!childEntity.getClass().equals(entity.getClass()) || childEntity.getIdentifier() != entity.getIdentifier() || !"subarea".equals(child.getRole())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean subAreaFilter(AtlasEntity entity) {
        return this.withSubAreas ? this.isSubArea(entity) : true;
    }
}

