/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex;

import java.util.ArrayList;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.utilities.conversion.Converter;

public class MultiPolygonRelationToMemberConverter
implements Converter<Relation, Iterable<AtlasEntity>> {
    private final Ring ring;

    public MultiPolygonRelationToMemberConverter(Ring ring) {
        this.ring = ring;
    }

    @Override
    public Iterable<AtlasEntity> convert(Relation relation) {
        if (!relation.isMultiPolygon()) {
            throw new CoreException("Not a MultiPolygon: {}", relation);
        }
        ArrayList<AtlasEntity> list = new ArrayList<AtlasEntity>();
        block4: for (RelationMember member : relation.members()) {
            switch (this.ring) {
                case OUTER: {
                    if (!"outer".equals(member.getRole())) continue block4;
                    list.add(member.getEntity());
                    continue block4;
                }
                case INNER: {
                    if (!"inner".equals(member.getRole())) continue block4;
                    list.add(member.getEntity());
                    continue block4;
                }
            }
            throw new CoreException("Unknown ring type: {}", new Object[]{this.ring});
        }
        return list;
    }

    public static enum Ring {
        OUTER,
        INNER;

    }
}

