/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items;

import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;

public enum ItemType {
    NODE(0),
    EDGE(1),
    AREA(2),
    LINE(3),
    POINT(4),
    RELATION(5);

    private final int value;

    public static ItemType forEntity(AtlasEntity entity) {
        return entity.getType();
    }

    public static ItemType forValue(int value) {
        for (ItemType type : ItemType.values()) {
            if (type.getValue() != value) continue;
            return type;
        }
        throw new CoreException("Invalid value: {}", value);
    }

    public static ItemType shortValueOf(String value) {
        switch (value) {
            case "N": {
                return NODE;
            }
            case "E": {
                return EDGE;
            }
            case "A": {
                return AREA;
            }
            case "L": {
                return LINE;
            }
            case "P": {
                return POINT;
            }
            case "R": {
                return RELATION;
            }
        }
        throw new CoreException("Invalid short value {}", value);
    }

    private ItemType(int value) {
        this.value = value;
    }

    public AtlasEntity entityForIdentifier(Atlas atlas, long identifier) {
        switch (this) {
            case NODE: {
                return atlas.node(identifier);
            }
            case EDGE: {
                return atlas.edge(identifier);
            }
            case AREA: {
                return atlas.area(identifier);
            }
            case LINE: {
                return atlas.line(identifier);
            }
            case POINT: {
                return atlas.point(identifier);
            }
            case RELATION: {
                return atlas.relation(identifier);
            }
        }
        throw new CoreException("Invalid type {}", new Object[]{this});
    }

    public int getValue() {
        return this.value;
    }

    public String toShortString() {
        switch (this) {
            case NODE: {
                return "N";
            }
            case EDGE: {
                return "E";
            }
            case AREA: {
                return "A";
            }
            case LINE: {
                return "L";
            }
            case POINT: {
                return "P";
            }
            case RELATION: {
                return "R";
            }
        }
        throw new CoreException("Invalid type {}", new Object[]{this});
    }
}

