/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.geography.atlas.items.DirectionalizedEdge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.identifier.ReverseIdentifierFactory;
import org.openstreetmap.atlas.tags.HighwayTag;

public abstract class Edge
extends LineItem
implements Comparable<Edge> {
    private static final long serialVersionUID = -4426003484206550921L;
    private static final ReverseIdentifierFactory reverseIdentifierFactory = new ReverseIdentifierFactory();

    public static boolean isMasterEdgeIdentifier(long identifier) {
        return identifier > 0L;
    }

    protected Edge(Atlas atlas) {
        super(atlas);
    }

    @Override
    public int compareTo(Edge other) {
        long difference = this.getIdentifier() - other.getIdentifier();
        return difference > 0L ? 1 : (difference < 0L ? -1 : 0);
    }

    public Set<Edge> connectedEdges() {
        HashSet<Edge> result = new HashSet<Edge>();
        for (Edge edge : this.end().connectedEdges()) {
            if (this.equals(edge)) continue;
            result.add(edge);
        }
        for (Edge edge : this.start().connectedEdges()) {
            if (this.equals(edge)) continue;
            result.add(edge);
        }
        return result;
    }

    public Set<Node> connectedNodes() {
        HashSet<Node> result = new HashSet<Node>();
        result.add(this.start());
        result.add(this.end());
        return result;
    }

    public Edge directionalized() {
        return new DirectionalizedEdge(this);
    }

    public abstract Node end();

    public Edge getMasterEdge() {
        return this.isMasterEdge() ? this : this.reversed().get();
    }

    public long getMasterEdgeIdentifier() {
        return Math.abs(this.getIdentifier());
    }

    @Override
    public ItemType getType() {
        return ItemType.EDGE;
    }

    public boolean hasReverseEdge() {
        return this.getAtlas().edge(-this.getIdentifier()) != null;
    }

    public HighwayTag highwayTag() {
        Optional<HighwayTag> result = HighwayTag.highwayTag(this);
        if (result.isPresent()) {
            return result.get();
        }
        return HighwayTag.NO;
    }

    public Set<Edge> inEdges() {
        return this.start().inEdges();
    }

    public boolean isConnectedAtEndTo(Set<? extends AtlasItem> candidates) {
        for (AtlasItem atlasItem : candidates) {
            if (atlasItem instanceof Node && this.end().equals(atlasItem)) {
                return true;
            }
            if (!(atlasItem instanceof Edge) || !this.end().equals(((Edge)atlasItem).start())) continue;
            return true;
        }
        return false;
    }

    public boolean isConnectedAtStartTo(Set<? extends AtlasItem> candidates) {
        for (AtlasItem atlasItem : candidates) {
            if (atlasItem instanceof Node && this.start().equals(atlasItem)) {
                return true;
            }
            if (!(atlasItem instanceof Edge) || !this.start().equals(((Edge)atlasItem).end())) continue;
            return true;
        }
        return false;
    }

    public boolean isMasterEdge() {
        return Edge.isMasterEdgeIdentifier(this.getIdentifier());
    }

    public boolean isReversedEdge(Edge candidate) {
        return this.getIdentifier() == -candidate.getIdentifier();
    }

    public boolean isWaySectioned() {
        return reverseIdentifierFactory.getWaySectionIndex(this.getIdentifier()) != 0L;
    }

    public Set<Edge> outEdges() {
        return this.end().outEdges();
    }

    public Optional<Edge> reversed() {
        Edge edge = this.getAtlas().edge(-this.getIdentifier());
        if (edge != null) {
            return Optional.of(edge);
        }
        return Optional.empty();
    }

    public abstract Node start();

    @Override
    public String toDiffViewFriendlyString() {
        String relationsString = this.parentRelationsAsDiffViewFriendlyString();
        return "[Edge: id=" + this.getIdentifier() + ", startNode=" + this.start().getIdentifier() + ", endNode=" + this.end().getIdentifier() + ", polyLine=" + this.asPolyLine().toWkt() + ", relations=(" + relationsString + "), " + this.tagString() + "]";
    }

    public String toString() {
        return "[Edge: id=" + this.getIdentifier() + ", startNode=" + this.start().getIdentifier() + ", endNode=" + this.end().getIdentifier() + ", polyLine=" + this.asPolyLine().toWkt() + ", " + this.tagString() + "]";
    }
}

