/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items;

import java.util.Map;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.geojson.GeoJsonBuilder;
import org.openstreetmap.atlas.utilities.collections.StringList;

public abstract class Area
extends AtlasItem {
    private static final long serialVersionUID = 5244165133018408045L;

    protected Area(Atlas atlas) {
        super(atlas);
    }

    public abstract Polygon asPolygon();

    @Override
    public Rectangle bounds() {
        return this.asPolygon().bounds();
    }

    public Polygon getClosedGeometry() {
        return new Polygon(this.asPolygon().closedLoop());
    }

    @Override
    public Iterable<Location> getRawGeometry() {
        return this.asPolygon();
    }

    @Override
    public ItemType getType() {
        return ItemType.AREA;
    }

    @Override
    public boolean intersects(GeometricSurface surface) {
        return surface.overlaps(this.asPolygon());
    }

    @Override
    public String toDiffViewFriendlyString() {
        String relationsString = this.parentRelationsAsDiffViewFriendlyString();
        return "[Area: id=" + this.getIdentifier() + ", polygon=" + this.asPolygon() + ", relations=(" + relationsString + "), " + this.tagString() + "]";
    }

    @Override
    public GeoJsonBuilder.LocationIterableProperties toGeoJsonBuildingBlock() {
        Map<String, String> tags = this.getTags();
        tags.put("identifier", String.valueOf(this.getIdentifier()));
        tags.put("osmIdentifier", String.valueOf(this.getOsmIdentifier()));
        tags.put("itemType", String.valueOf((Object)this.getType()));
        StringList parentRelations = new StringList();
        this.relations().forEach(relation -> {
            RelationMember member = relation.members().get(this.getIdentifier(), this.getType());
            parentRelations.add(member.getRelationIdentifier() + "-" + member.getRole());
        });
        if (!parentRelations.isEmpty()) {
            tags.put("parentRelations", parentRelations.join(", "));
        }
        return new GeoJsonBuilder.LocationIterableProperties(this.getClosedGeometry(), tags);
    }

    public String toString() {
        return "[Area: id=" + this.getIdentifier() + ", polygon=" + this.asPolygon() + ", " + this.tagString() + "]";
    }
}

