/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.dynamic;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicAtlas;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMemberList;

public class DynamicRelation
extends Relation {
    private static final long serialVersionUID = 7994622214805021474L;
    private final long identifier;

    protected DynamicRelation(DynamicAtlas atlas, long identifier) {
        super(atlas);
        this.identifier = identifier;
    }

    @Override
    public RelationMemberList allKnownOsmMembers() {
        return this.subRelation().allKnownOsmMembers();
    }

    @Override
    public List<Relation> allRelationsWithSameOsmIdentifier() {
        return this.subRelation().allRelationsWithSameOsmIdentifier().stream().map(relation -> new DynamicRelation(this.dynamicAtlas(), relation.getIdentifier())).collect(Collectors.toList());
    }

    @Override
    public long getIdentifier() {
        return this.identifier;
    }

    @Override
    public Map<String, String> getTags() {
        return this.subRelation().getTags();
    }

    @Override
    public RelationMemberList members() {
        return this.subRelation().members();
    }

    @Override
    public long osmRelationIdentifier() {
        return this.subRelation().osmRelationIdentifier();
    }

    @Override
    public Set<Relation> relations() {
        return this.subRelation().relations().stream().map(relation -> new DynamicRelation(this.dynamicAtlas(), relation.getIdentifier())).collect(Collectors.toSet());
    }

    private DynamicAtlas dynamicAtlas() {
        return (DynamicAtlas)this.getAtlas();
    }

    private Relation subRelation() {
        Relation result = this.dynamicAtlas().subRelation(this.identifier);
        if (result != null) {
            return result;
        }
        throw new CoreException("DynamicAtlas {} moved too fast! {} {} is missing now.", this.dynamicAtlas().getName(), this.getClass().getSimpleName(), this.identifier);
    }
}

