/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.dynamic;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicAtlas;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicNode;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicRelation;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Relation;

public class DynamicEdge
extends Edge {
    private static final long serialVersionUID = -3839789846949424342L;
    private final long identifier;

    protected DynamicEdge(DynamicAtlas atlas, long identifier) {
        super(atlas);
        this.identifier = identifier;
    }

    @Override
    public PolyLine asPolyLine() {
        return this.subEdge().asPolyLine();
    }

    @Override
    public Node end() {
        return new DynamicNode(this.dynamicAtlas(), this.subEdge().end().getIdentifier());
    }

    @Override
    public long getIdentifier() {
        return this.identifier;
    }

    @Override
    public Map<String, String> getTags() {
        return this.subEdge().getTags();
    }

    @Override
    public Set<Relation> relations() {
        return this.subEdge().relations().stream().map(relation -> new DynamicRelation(this.dynamicAtlas(), relation.getIdentifier())).collect(Collectors.toSet());
    }

    @Override
    public Node start() {
        return new DynamicNode(this.dynamicAtlas(), this.subEdge().start().getIdentifier());
    }

    private DynamicAtlas dynamicAtlas() {
        return (DynamicAtlas)this.getAtlas();
    }

    private Edge subEdge() {
        Edge result = this.dynamicAtlas().subEdge(this.identifier);
        if (result != null) {
            return result;
        }
        throw new CoreException("DynamicAtlas {} moved too fast! {} {} is missing now.", this.dynamicAtlas().getName(), this.getClass().getSimpleName(), this.identifier);
    }
}

