/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.command;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.builder.text.TextAtlasBuilder;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.runtime.FlexibleSubCommand;

public class TextToPackedAtlasSubCommand
implements FlexibleSubCommand {
    private static final String NAME = "text-to-packed";
    private static final String DESCRIPTION = "converts a text-based atlas to a packed atlas";
    private static final Command.Switch<Path> INPUT_PARAMETER = new Command.Switch("text-atlas", "Input atlas data in text atlas format", x$0 -> Paths.get(x$0, new String[0]), Command.Optionality.REQUIRED);
    private static final Command.Switch<Path> OUTPUT_PARAMETER = new Command.Switch("packed-atlas", "Output atlas data path", x$0 -> Paths.get(x$0, new String[0]), Command.Optionality.REQUIRED);
    private Path inputPath;
    private Path outputPath;

    @Override
    public int execute(CommandMap map) {
        this.inputPath = (Path)map.get(INPUT_PARAMETER);
        this.outputPath = (Path)map.get(OUTPUT_PARAMETER);
        this.preVerify();
        new TextAtlasBuilder().read(new File(this.inputPath.toFile())).save(new File(this.outputPath.toFile()));
        return 0;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Command.SwitchList switches() {
        return new Command.SwitchList().with(INPUT_PARAMETER, OUTPUT_PARAMETER);
    }

    @Override
    public void usage(PrintStream writer) {
        writer.println("-text-atlas=/input/path/to/text/atlas");
        writer.println("-packed-atlas=/output/path/to/packed/atlas");
    }

    private void preVerify() {
        if (!Files.isRegularFile(this.inputPath, new LinkOption[0])) {
            throw new CoreException("{} is not a readable file", this.inputPath);
        }
        try {
            if (Files.isDirectory(this.outputPath, new LinkOption[0])) {
                throw new CoreException("{} is a directory.  Aborting", this.outputPath);
            }
            Files.createDirectories(this.outputPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException oops) {
            throw new CoreException("Error when creating directories {}", this.outputPath.getParent(), oops);
        }
    }
}

