/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.command;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.command.AbstractAtlasSubCommand;
import org.openstreetmap.atlas.geography.atlas.multi.MultiAtlas;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasCloner;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;

public class SubAtlasSubCommand
extends AbstractAtlasSubCommand {
    private static final Command.Switch<Path> OUTPUT = new Command.Switch("output", "The file to save the Atlas to", x$0 -> Paths.get(x$0, new String[0]), Command.Optionality.OPTIONAL);
    private static final Command.Switch<Rectangle> SUB = new Command.Switch("sub", "The rectangle to soft-cut this Atlas to", Rectangle::forString, Command.Optionality.REQUIRED);
    private static final Command.Switch<Path> GEOJSON = new Command.Switch("geojson", "The geojson file to save this sub atlas to", x$0 -> Paths.get(x$0, new String[0]), Command.Optionality.OPTIONAL);
    private static final Command.Flag SAVE_MEMORY = new Command.Flag("saveMemory", "Reduce momery cost if this flag is existed");
    private final List<Atlas> atlases = new ArrayList<Atlas>();

    public SubAtlasSubCommand() {
        super("sub", "Subs an Atlas into another smaller Atlas");
    }

    @Override
    public Command.SwitchList switches() {
        return super.switches().with(OUTPUT, SUB, GEOJSON, SAVE_MEMORY);
    }

    @Override
    public void usage(PrintStream writer) {
        writer.printf("-input=/path/to/atlas/files : the atlas files we want to load\n", new Object[0]);
        writer.printf("-output=/path/to/atlas/output/to/save : the path to the output atlas file\n", new Object[0]);
        writer.printf("-geojson=/path/to/atlas/geojson/to/save : the path to the output geojson file (optional)\n", new Object[0]);
        writer.printf("-sub=minLat,minLon:maxLat,maxLon : the rectangle to sub the Atlas with\n", new Object[0]);
        writer.printf("-saveMemory : a flag to save memory\n", new Object[0]);
    }

    @Override
    protected int finish(CommandMap command) {
        MultiAtlas atlas = new MultiAtlas(this.atlases);
        Rectangle rectangle = (Rectangle)command.get(SUB);
        try {
            Atlas saveMe = new PackedAtlasCloner().cloneFrom(atlas).subAtlas(rectangle).orElseThrow(() -> new CoreException("There are no features in the sub rectangle."));
            Path path = (Path)command.get(OUTPUT);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            saveMe.save(new File(path.toString()));
            Path path2 = (Path)command.get(GEOJSON);
            if (path2 != null) {
                Files.createDirectories(path2.getParent(), new FileAttribute[0]);
                saveMe.saveAsGeoJson(new File(path2.toString()));
            }
            return 0;
        }
        catch (IOException oops) {
            throw new CoreException("Error when saving packed atlas", oops);
        }
    }

    @Override
    protected void handle(Atlas atlas, CommandMap command) {
        boolean saveMemory = (Boolean)command.get(SAVE_MEMORY);
        Rectangle rectangle = (Rectangle)command.get(SUB);
        if (!saveMemory || rectangle.overlaps(atlas.bounds())) {
            this.atlases.add(atlas);
        }
    }
}

