/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.command;

import java.io.PrintStream;
import java.io.StreamCorruptedException;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.exception.ExceptionSearch;
import org.openstreetmap.atlas.geography.atlas.AtlasResourceLoader;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.runtime.FlexibleSubCommand;

public class AtlasResourceLoaderErrorSubCommand
implements FlexibleSubCommand {
    private static final Command.Switch<File> INPUT_PARAMETER = new Command.Switch("input", "Path of Atlas file", File::new, Command.Optionality.OPTIONAL);

    @Override
    public int execute(CommandMap map) {
        File input = (File)map.get(INPUT_PARAMETER);
        try {
            new AtlasResourceLoader().load(input);
        }
        catch (CoreException oops) {
            oops.printStackTrace();
            ExceptionSearch.find(StreamCorruptedException.class).within(oops).ifPresent(Throwable::printStackTrace);
        }
        return 0;
    }

    @Override
    public String getDescription() {
        return "Testing the abstract resource loader";
    }

    @Override
    public String getName() {
        return "resource-load-testing";
    }

    @Override
    public Command.SwitchList switches() {
        return new Command.SwitchList().with(INPUT_PARAMETER);
    }

    @Override
    public void usage(PrintStream writer) {
        writer.printf("-input=/path/to/resources/for/loading/atlas/files", new Object[0]);
    }
}

