/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.command;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.command.AbstractAtlasSubCommand;
import org.openstreetmap.atlas.geography.atlas.multi.MultiAtlas;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasCloner;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;

public class AtlasJoinerSubCommand
extends AbstractAtlasSubCommand {
    private static final Command.Switch<Path> OUTPUT_PARAMETER = new Command.Switch("output", "The Atlas file to save to", x$0 -> Paths.get(x$0, new String[0]), Command.Optionality.REQUIRED);
    private final List<Atlas> atlases = new ArrayList<Atlas>();

    public AtlasJoinerSubCommand() {
        super("join", "joins multiple atlas files into a single packed atlas");
    }

    @Override
    public Command.SwitchList switches() {
        return super.switches().with(OUTPUT_PARAMETER);
    }

    @Override
    public void usage(PrintStream writer) {
        writer.printf("-input=/path/to/atlas/files : the atlas files we want to load\n", new Object[0]);
        writer.printf("-output=/path/to/atlas/output/to/save : the path to the output atlas file\n", new Object[0]);
    }

    @Override
    protected int finish(CommandMap command) {
        MultiAtlas atlas = new MultiAtlas(this.atlases);
        try {
            PackedAtlas saveMe = new PackedAtlasCloner().cloneFrom(atlas);
            Path path = (Path)command.get(OUTPUT_PARAMETER);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            saveMe.save(new File(path.toString()));
            return 0;
        }
        catch (IOException oops) {
            throw new CoreException("Error when saving packed atlas", oops);
        }
    }

    @Override
    protected void handle(Atlas atlas, CommandMap command) {
        this.atlases.add(atlas);
    }
}

