/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas;

import java.util.function.Predicate;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.BareAtlas;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.pbf.OsmPbfLoader;
import org.openstreetmap.atlas.geography.index.PackedSpatialIndex;
import org.openstreetmap.atlas.geography.index.RTree;
import org.openstreetmap.atlas.geography.index.SpatialIndex;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.slf4j.Logger;

public abstract class AbstractAtlas
extends BareAtlas {
    private static final long serialVersionUID = -1408393006815178776L;
    protected static final long DEFAULT_NUMBER_OF_ITEMS = 1024L;
    protected static final int HASH_MODULO_RATIO = 10;
    private static final Object NODE_LOCK = new Object();
    private static final Object EDGE_LOCK = new Object();
    private static final Object AREA_LOCK = new Object();
    private static final Object LINE_LOCK = new Object();
    private static final Object POINT_LOCK = new Object();
    private static final Object RELATION_LOCK = new Object();
    private transient SpatialIndex<Node> nodeSpatialIndex;
    private transient SpatialIndex<Edge> edgeSpatialIndex;
    private transient SpatialIndex<Area> areaSpatialIndex;
    private transient SpatialIndex<Line> lineSpatialIndex;
    private transient SpatialIndex<Point> pointSpatialIndex;
    private transient SpatialIndex<Relation> relationSpatialIndex;

    public static Atlas createAndSaveOsmPbf(Resource osmPbf, WritableResource atlasResource) {
        OsmPbfLoader loader = new OsmPbfLoader(osmPbf);
        loader.saveAtlas(atlasResource);
        return loader.read();
    }

    public static Atlas createAndSaveOsmPbfWithSlicing(Resource osmPbf, WritableResource atlasResource) {
        OsmPbfLoader loader = new OsmPbfLoader(osmPbf, AtlasLoadingOption.createOptionWithAllEnabled(null));
        loader.saveAtlas(atlasResource);
        return loader.read();
    }

    public static Atlas forOsmPbf(Resource resource) {
        OsmPbfLoader loader = new OsmPbfLoader(resource);
        return loader.read();
    }

    @Override
    public Iterable<Area> areasCovering(Location location) {
        Iterable<Area> areas = this.getAreaSpatialIndex().get(location.bounds());
        return Iterables.stream(areas).filter(area -> {
            Polygon areaPolygon = area.asPolygon();
            return areaPolygon.fullyGeometricallyEncloses(location);
        });
    }

    @Override
    public Iterable<Area> areasCovering(Location location, Predicate<Area> matcher) {
        return Iterables.filter(this.areasCovering(location), matcher);
    }

    @Override
    public Iterable<Area> areasIntersecting(Polygon polygon) {
        Iterable<Area> areas = this.getAreaSpatialIndex().get(polygon.bounds());
        return Iterables.filter(areas, area -> {
            Polygon areaPolygon = area.asPolygon();
            return polygon.overlaps(areaPolygon);
        });
    }

    @Override
    public Iterable<Area> areasIntersecting(Polygon polygon, Predicate<Area> matcher) {
        return Iterables.filterTranslate(this.areasIntersecting(polygon), item -> item, matcher);
    }

    @Override
    public Iterable<Edge> edgesContaining(Location location) {
        Iterable<Edge> edges = this.getEdgeSpatialIndex().get(location.bounds());
        return Iterables.filter(edges, edge -> {
            PolyLine polyline = edge.asPolyLine();
            return polyline.contains(location);
        });
    }

    @Override
    public Iterable<Edge> edgesContaining(Location location, Predicate<Edge> matcher) {
        return Iterables.filter(this.edgesContaining(location), matcher);
    }

    @Override
    public Iterable<Edge> edgesIntersecting(Polygon polygon) {
        Iterable<Edge> edges = this.getEdgeSpatialIndex().get(polygon.bounds());
        return Iterables.filter(edges, edge -> {
            PolyLine polyline = edge.asPolyLine();
            return polygon.overlaps(polyline);
        });
    }

    @Override
    public Iterable<Edge> edgesIntersecting(Polygon polygon, Predicate<Edge> matcher) {
        return Iterables.filter(this.edgesIntersecting(polygon), matcher);
    }

    public SpatialIndex<Area> getAreaSpatialIndex() {
        this.buildAreaSpatialIndexIfNecessary();
        return this.areaSpatialIndex;
    }

    public SpatialIndex<Edge> getEdgeSpatialIndex() {
        this.buildEdgeSpatialIndexIfNecessary();
        return this.edgeSpatialIndex;
    }

    public SpatialIndex<Line> getLineSpatialIndex() {
        this.buildLineSpatialIndexIfNecessary();
        return this.lineSpatialIndex;
    }

    public SpatialIndex<Node> getNodeSpatialIndex() {
        this.buildNodeSpatialIndexIfNecessary();
        return this.nodeSpatialIndex;
    }

    public SpatialIndex<Point> getPointSpatialIndex() {
        this.buildPointSpatialIndexIfNecessary();
        return this.pointSpatialIndex;
    }

    public SpatialIndex<Relation> getRelationSpatialIndex() {
        this.buildRelationSpatialIndexIfNecessary();
        return this.relationSpatialIndex;
    }

    @Override
    public Iterable<Line> linesContaining(Location location) {
        Iterable<Line> lines = this.getLineSpatialIndex().get(location.bounds());
        return Iterables.filter(lines, line -> {
            PolyLine polyline = line.asPolyLine();
            return polyline.contains(location);
        });
    }

    @Override
    public Iterable<Line> linesContaining(Location location, Predicate<Line> matcher) {
        return Iterables.filter(this.linesContaining(location), matcher);
    }

    @Override
    public Iterable<Line> linesIntersecting(Polygon polygon) {
        Iterable<Line> lines = this.getLineSpatialIndex().get(polygon.bounds());
        return Iterables.filter(lines, line -> {
            PolyLine polyline = line.asPolyLine();
            return polygon.overlaps(polyline);
        });
    }

    @Override
    public Iterable<Line> linesIntersecting(Polygon polygon, Predicate<Line> matcher) {
        return Iterables.filter(this.linesIntersecting(polygon), matcher);
    }

    @Override
    public Iterable<Node> nodesAt(Location location) {
        return this.getNodeSpatialIndex().get(location.bounds());
    }

    @Override
    public Iterable<Node> nodesWithin(Polygon polygon) {
        Iterable<Node> nodes = this.getNodeSpatialIndex().get(polygon.bounds());
        if (polygon instanceof Rectangle) {
            return nodes;
        }
        return Iterables.filter(nodes, node -> polygon.fullyGeometricallyEncloses(node.getLocation()));
    }

    @Override
    public Iterable<Node> nodesWithin(Polygon polygon, Predicate<Node> matcher) {
        return Iterables.filter(this.nodesWithin(polygon), matcher);
    }

    @Override
    public Iterable<Point> pointsAt(Location location) {
        return this.getPointSpatialIndex().get(location.bounds());
    }

    @Override
    public Iterable<Point> pointsWithin(Polygon polygon) {
        Iterable<Point> points = this.getPointSpatialIndex().get(polygon.bounds());
        if (polygon instanceof Rectangle) {
            return points;
        }
        return Iterables.filter(points, point -> polygon.fullyGeometricallyEncloses(point.getLocation()));
    }

    @Override
    public Iterable<Point> pointsWithin(Polygon polygon, Predicate<Point> matcher) {
        return Iterables.filterTranslate(this.pointsWithin(polygon), item -> item, matcher);
    }

    @Override
    public Iterable<Relation> relationsWithEntitiesIntersecting(Polygon polygon) {
        Iterable<Relation> relations = this.getRelationSpatialIndex().get(polygon.bounds());
        return Iterables.filter(relations, relation -> relation.intersects(polygon));
    }

    @Override
    public Iterable<Relation> relationsWithEntitiesIntersecting(Polygon polygon, Predicate<Relation> matcher) {
        return Iterables.filter(this.relationsWithEntitiesIntersecting(polygon), matcher);
    }

    @Override
    public void save(WritableResource writableResource) {
        throw new CoreException("{} does not support saving. Consider using {} instead.", this.getClass().getName(), PackedAtlas.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildAreaSpatialIndexIfNecessary() {
        if (this.areaSpatialIndex == null) {
            Object object = AREA_LOCK;
            synchronized (object) {
                if (this.areaSpatialIndex == null) {
                    this.getLogger().info("Re-Building Area Spatial Index...");
                    SpatialIndex<Area> temporaryIndex = this.newAreaSpatialIndex();
                    this.areas().forEach(area -> temporaryIndex.add((Area)area));
                    this.areaSpatialIndex = temporaryIndex;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildEdgeSpatialIndexIfNecessary() {
        if (this.edgeSpatialIndex == null) {
            Object object = EDGE_LOCK;
            synchronized (object) {
                if (this.edgeSpatialIndex == null) {
                    this.getLogger().info("Re-Building Edge Spatial Index...");
                    SpatialIndex<Edge> temporaryIndex = this.newEdgeSpatialIndex();
                    this.edges().forEach(edge -> temporaryIndex.add((Edge)edge));
                    this.edgeSpatialIndex = temporaryIndex;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildLineSpatialIndexIfNecessary() {
        if (this.lineSpatialIndex == null) {
            Object object = LINE_LOCK;
            synchronized (object) {
                if (this.lineSpatialIndex == null) {
                    this.getLogger().info("Re-Building Line Spatial Index...");
                    SpatialIndex<Line> temporaryIndex = this.newLineSpatialIndex();
                    this.lines().forEach(line -> temporaryIndex.add((Line)line));
                    this.lineSpatialIndex = temporaryIndex;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildNodeSpatialIndexIfNecessary() {
        if (this.nodeSpatialIndex == null) {
            Object object = NODE_LOCK;
            synchronized (object) {
                if (this.nodeSpatialIndex == null) {
                    this.getLogger().info("Re-Building Node Spatial Index...");
                    SpatialIndex<Node> temporaryIndex = this.newNodeSpatialIndex();
                    this.nodes().forEach(node -> temporaryIndex.add((Node)node));
                    this.nodeSpatialIndex = temporaryIndex;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildPointSpatialIndexIfNecessary() {
        if (this.pointSpatialIndex == null) {
            Object object = POINT_LOCK;
            synchronized (object) {
                if (this.pointSpatialIndex == null) {
                    this.getLogger().info("Re-Building Point Spatial Index...");
                    SpatialIndex<Point> temporaryIndex = this.newPointSpatialIndex();
                    this.points().forEach(point -> temporaryIndex.add((Point)point));
                    this.pointSpatialIndex = temporaryIndex;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildRelationSpatialIndexIfNecessary() {
        if (this.relationSpatialIndex == null) {
            Object object = RELATION_LOCK;
            synchronized (object) {
                if (this.relationSpatialIndex == null) {
                    this.getLogger().info("Re-Building Relation Spatial Index...");
                    SpatialIndex<Relation> temporaryIndex = this.newRelationSpatialIndex();
                    this.relations().forEach(relation -> temporaryIndex.add((Relation)relation));
                    this.relationSpatialIndex = temporaryIndex;
                }
            }
        }
    }

    protected SpatialIndex<Area> getAsNewAreaSpatialIndex() {
        if (this.areaSpatialIndex == null) {
            this.areaSpatialIndex = this.newAreaSpatialIndex();
        }
        return this.areaSpatialIndex;
    }

    protected SpatialIndex<Edge> getAsNewEdgeSpatialIndex() {
        if (this.edgeSpatialIndex == null) {
            this.edgeSpatialIndex = this.newEdgeSpatialIndex();
        }
        return this.edgeSpatialIndex;
    }

    protected SpatialIndex<Line> getAsNewLineSpatialIndex() {
        if (this.lineSpatialIndex == null) {
            this.lineSpatialIndex = this.newLineSpatialIndex();
        }
        return this.lineSpatialIndex;
    }

    protected SpatialIndex<Node> getAsNewNodeSpatialIndex() {
        if (this.nodeSpatialIndex == null) {
            this.nodeSpatialIndex = this.newNodeSpatialIndex();
        }
        return this.nodeSpatialIndex;
    }

    protected SpatialIndex<Point> getAsNewPointSpatialIndex() {
        if (this.pointSpatialIndex == null) {
            this.pointSpatialIndex = this.newPointSpatialIndex();
        }
        return this.pointSpatialIndex;
    }

    protected SpatialIndex<Relation> getAsNewRelationSpatialIndex() {
        if (this.relationSpatialIndex == null) {
            this.relationSpatialIndex = this.newRelationSpatialIndex();
        }
        return this.relationSpatialIndex;
    }

    protected abstract Logger getLogger();

    private SpatialIndex<Area> newAreaSpatialIndex() {
        return new PackedSpatialIndex<Area, Long>(new RTree()){
            private static final long serialVersionUID = 6569644967280192054L;

            @Override
            protected Long compress(Area item) {
                return item.getIdentifier();
            }

            @Override
            protected boolean isValid(Area item, Rectangle bounds) {
                return bounds.overlaps(item.asPolygon());
            }

            @Override
            protected Area restore(Long packed) {
                return AbstractAtlas.this.area(packed);
            }
        };
    }

    private SpatialIndex<Edge> newEdgeSpatialIndex() {
        return new PackedSpatialIndex<Edge, Long>(new RTree()){
            private static final long serialVersionUID = -7338204023386941100L;

            @Override
            protected Long compress(Edge item) {
                return item.getIdentifier();
            }

            @Override
            protected boolean isValid(Edge item, Rectangle bounds) {
                return bounds.overlaps(item.asPolyLine());
            }

            @Override
            protected Edge restore(Long packed) {
                return AbstractAtlas.this.edge(packed);
            }
        };
    }

    private SpatialIndex<Line> newLineSpatialIndex() {
        return new PackedSpatialIndex<Line, Long>(new RTree()){
            private static final long serialVersionUID = -2370005868531024004L;

            @Override
            protected Long compress(Line item) {
                return item.getIdentifier();
            }

            @Override
            protected boolean isValid(Line item, Rectangle bounds) {
                return bounds.overlaps(item.asPolyLine());
            }

            @Override
            protected Line restore(Long packed) {
                return AbstractAtlas.this.line(packed);
            }
        };
    }

    private SpatialIndex<Node> newNodeSpatialIndex() {
        return new PackedSpatialIndex<Node, Long>(new RTree()){
            private static final long serialVersionUID = -3524737478519081893L;

            @Override
            protected Long compress(Node item) {
                return item.getIdentifier();
            }

            @Override
            protected boolean isValid(Node item, Rectangle bounds) {
                return bounds.fullyGeometricallyEncloses(item);
            }

            @Override
            protected Node restore(Long packed) {
                return AbstractAtlas.this.node(packed);
            }
        };
    }

    private SpatialIndex<Point> newPointSpatialIndex() {
        return new PackedSpatialIndex<Point, Long>(new RTree()){
            private static final long serialVersionUID = -9098544142517525524L;

            @Override
            protected Long compress(Point item) {
                return item.getIdentifier();
            }

            @Override
            protected boolean isValid(Point item, Rectangle bounds) {
                return bounds.fullyGeometricallyEncloses(item);
            }

            @Override
            protected Point restore(Long packed) {
                return AbstractAtlas.this.point(packed);
            }
        };
    }

    private SpatialIndex<Relation> newRelationSpatialIndex() {
        return new PackedSpatialIndex<Relation, Long>(new RTree()){
            private static final long serialVersionUID = 6569644967280192054L;

            @Override
            protected Long compress(Relation item) {
                return item.getIdentifier();
            }

            @Override
            protected boolean isValid(Relation item, Rectangle bounds) {
                return item.intersects(bounds);
            }

            @Override
            protected Relation restore(Long packed) {
                return AbstractAtlas.this.relation(packed);
            }
        };
    }
}

