/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography;

import com.google.common.collect.Lists;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.triangulate.ConformingDelaunayTriangulationBuilder;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Heading;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.Segment;
import org.openstreetmap.atlas.geography.converters.WktPolygonConverter;
import org.openstreetmap.atlas.geography.converters.jts.GeometryStreamer;
import org.openstreetmap.atlas.geography.converters.jts.JtsLocationConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPointConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPolygonConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPrecisionManager;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;
import org.openstreetmap.atlas.utilities.scalars.Angle;
import org.openstreetmap.atlas.utilities.scalars.Surface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Polygon
extends PolyLine
implements GeometricSurface {
    public static final Polygon SILICON_VALLEY = new Polygon(Location.TEST_3, Location.TEST_7, Location.TEST_4, Location.TEST_1, Location.TEST_5);
    public static final Polygon SILICON_VALLEY_2 = new Polygon(Location.TEST_3, Location.TEST_7, Location.TEST_2, Location.TEST_1, Location.TEST_5);
    public static final Polygon TEST_BUILDING = new Polygon(Location.forString("37.3909505256542,-122.03104734420775"), Location.forString("37.39031973417266,-122.03141212463377"), Location.forString("37.390106627742895,-122.03113317489623"), Location.forString("37.39084823550426,-122.03062891960144"), Location.forString("37.3909505256542,-122.03104734420775"));
    public static final Polygon TEST_BUILDING_PART = new Polygon(Location.forString("37.390234491673446,-122.03111171722412"), Location.forString("37.39020252571126,-122.0311439037323"), Location.forString("37.39018121506223,-122.03110367059708"), Location.forString("37.39021104996917,-122.0310714840889"), Location.forString("37.390234491673446,-122.03111171722412"));
    private static final JtsPolygonConverter JTS_POLYGON_CONVERTER = new JtsPolygonConverter();
    private static final Logger logger = LoggerFactory.getLogger(Polygon.class);
    private static final long serialVersionUID = 2877026648358594354L;
    private static final int MINIMUM_N_FOR_SIDE_CALCULATION = 3;
    private transient Area awtArea;
    private java.awt.Polygon awtPolygon;
    private transient Boolean awtOverflows;

    public static Polygon random(int numberPoints, Rectangle bounds) {
        ArrayList<Location> locations = new ArrayList<Location>();
        IntStream.range(0, numberPoints).forEach((int index) -> locations.add(Location.random(bounds)));
        return new Polygon((List<Location>)locations);
    }

    public static Polygon wkt(String wkt) {
        return new WktPolygonConverter().backwardConvert(wkt);
    }

    public Polygon(Iterable<Location> points) {
        this(Iterables.asList(points));
    }

    public Polygon(List<Location> points) {
        super(points);
    }

    public Polygon(Location ... points) {
        this(Iterables.iterable(points));
    }

    public List<Segment> attachedSegments(int vertexIndex) {
        this.verifyVertexIndex(vertexIndex);
        ArrayList<Segment> result = new ArrayList<Segment>();
        if (vertexIndex > 0) {
            result.add(this.segmentForIndex(vertexIndex - 1));
        } else {
            result.add(this.segmentForIndex(this.size() - 1));
        }
        result.add(this.segmentForIndex(vertexIndex));
        return result;
    }

    public Location center() {
        Point point = JTS_POLYGON_CONVERTER.convert(this).getCentroid();
        return new JtsLocationConverter().backwardConvert(point.getCoordinate());
    }

    public Iterable<Location> closedLoop() {
        return new MultiIterable<Location>(this, Iterables.from(this.first()));
    }

    @Override
    public boolean fullyGeometricallyEncloses(Location location) {
        if (this.awtOverflows()) {
            com.vividsolutions.jts.geom.Polygon polygon = JTS_POLYGON_CONVERTER.convert(this);
            Point point = new JtsPointConverter().convert(location);
            return polygon.covers(point);
        }
        return this.awtPolygon().contains(location.asAwtPoint());
    }

    @Override
    public boolean fullyGeometricallyEncloses(MultiPolygon multiPolygon) {
        return multiPolygon.outers().stream().allMatch(this::fullyGeometricallyEncloses);
    }

    @Override
    public boolean fullyGeometricallyEncloses(PolyLine polyLine) {
        List<Segment> segments = polyLine.segments();
        for (Segment segment : segments) {
            if (this.fullyGeometricallyEncloses(segment)) continue;
            return false;
        }
        return true;
    }

    public boolean fullyGeometricallyEncloses(Rectangle rectangle) {
        Rectangle bounds = this.bounds();
        if (!bounds.fullyGeometricallyEncloses(rectangle)) {
            return false;
        }
        if (this.awtOverflows()) {
            com.vividsolutions.jts.geom.Polygon polygon = JTS_POLYGON_CONVERTER.convert(this);
            return polygon.covers(JTS_POLYGON_CONVERTER.convert(rectangle));
        }
        return this.awtArea().contains(rectangle.asAwtRectangle());
    }

    public boolean fullyGeometricallyEncloses(Segment segment) {
        Set<Location> intersections = this.intersections(segment);
        for (Location intersection : intersections) {
            if (intersection.equals(segment.start()) || intersection.equals(segment.end())) continue;
            return false;
        }
        return this.fullyGeometricallyEncloses(segment.middle());
    }

    public Location interiorCenter() {
        Point point = JTS_POLYGON_CONVERTER.convert(this).getInteriorPoint();
        return new JtsLocationConverter().backwardConvert(point.getCoordinate());
    }

    public boolean isApproximatelyNSided(int expectedNumberOfSides, Angle threshold) {
        if (expectedNumberOfSides < 3 || this.size() < expectedNumberOfSides) {
            return false;
        }
        int expectedHeadingChangeCount = expectedNumberOfSides - 1;
        List<Segment> segments = this.segments();
        int segmentSize = segments.size();
        int segmentIndex = 0;
        int headingChangeCount = 0;
        Optional<Object> previousHeading = Optional.empty();
        while (segmentIndex < segmentSize && !(previousHeading = segments.get(segmentIndex++).heading()).isPresent()) {
        }
        if (!previousHeading.isPresent()) {
            logger.trace("{} doesn't have a heading to calculate number of sides.", (Object)this);
            return false;
        }
        while (segmentIndex < segmentSize && headingChangeCount <= expectedHeadingChangeCount) {
            Optional<Heading> nextHeading;
            if (!(nextHeading = segments.get(segmentIndex++).heading()).isPresent() || !((Heading)previousHeading.get()).difference(nextHeading.get()).isGreaterThan(threshold)) continue;
            ++headingChangeCount;
            previousHeading = nextHeading;
        }
        return headingChangeCount == expectedHeadingChangeCount;
    }

    public boolean isClockwise() {
        long sum = 0L;
        long lastLatitude = Long.MIN_VALUE;
        long lastLongitude = Long.MIN_VALUE;
        for (Location point : this) {
            if (lastLongitude != Long.MIN_VALUE) {
                sum += (point.getLongitude().asDm7() - lastLongitude) * (point.getLatitude().asDm7() + lastLatitude);
            }
            lastLongitude = point.getLongitude().asDm7();
            lastLatitude = point.getLatitude().asDm7();
        }
        return sum >= 0L;
    }

    public int nextSegmentIndex(int currentVertexIndex) {
        this.verifyVertexIndex(currentVertexIndex);
        return currentVertexIndex;
    }

    public int nextVertexIndex(int currentVertexIndex) {
        this.verifyVertexIndex(currentVertexIndex);
        if (currentVertexIndex == this.size() - 1) {
            return 0;
        }
        return currentVertexIndex + 1;
    }

    @Override
    public boolean overlaps(MultiPolygon multiPolygon) {
        for (Polygon outer : multiPolygon.outers()) {
            List<Polygon> inners = multiPolygon.innersOf(outer);
            if (!this.overlaps(outer)) continue;
            boolean result = true;
            for (Polygon inner : inners) {
                if (!inner.fullyGeometricallyEncloses(this)) continue;
                result = false;
                break;
            }
            if (!result) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean overlaps(PolyLine polyline) {
        return this.overlapsInternal(polyline, true);
    }

    public int previousSegmentIndex(int currentVertexIndex) {
        return this.previousVertexIndex(currentVertexIndex);
    }

    public int previousVertexIndex(int currentVertexIndex) {
        this.verifyVertexIndex(currentVertexIndex);
        if (currentVertexIndex == 0) {
            return this.size() - 1;
        }
        return currentVertexIndex - 1;
    }

    @Override
    public Polygon reversed() {
        return new Polygon(super.reversed().getPoints());
    }

    public Segment segmentForIndex(int index) {
        if (index >= this.size()) {
            throw new CoreException("Invalid index");
        }
        return new Segment(this.get(index), index == this.size() - 1 ? this.get(0) : this.get(index + 1));
    }

    @Override
    public List<Segment> segments() {
        List<Segment> result = super.segments();
        result.add(new Segment(this.last(), this.first()));
        return result;
    }

    @Override
    public Surface surface() {
        long dm7Squared = 0L;
        Iterator<Location> loopOnItself = this.loopOnItself().iterator();
        if (!loopOnItself.hasNext()) {
            return Surface.forDm7Squared(0L);
        }
        Location current = loopOnItself.next();
        Location next = null;
        while (loopOnItself.hasNext()) {
            next = loopOnItself.next();
            dm7Squared += (current.getLongitude().asDm7() + next.getLongitude().asDm7()) * (current.getLatitude().asDm7() - next.getLatitude().asDm7());
            current = next;
        }
        return Surface.forDm7Squared(Math.abs(Math.round((double)dm7Squared / 2.0)));
    }

    @Override
    public Surface surfaceOnSphere() {
        double dm7 = 0.0;
        ArrayList<Location> locations = Lists.newArrayList(this.closedLoop());
        if (locations.size() > 2) {
            double radians = 0.0;
            for (int index = 0; index < locations.size() - 1; ++index) {
                radians += (((Location)locations.get(index + 1)).getLongitude().asRadians() - ((Location)locations.get(index)).getLongitude().asRadians()) * (2.0 + Math.sin(((Location)locations.get(index)).getLatitude().asRadians()) + Math.sin(((Location)locations.get(index + 1)).getLatitude().asRadians()));
            }
            radians = Math.abs(radians / 2.0);
            dm7 = radians * 3.28280634851262E17;
        }
        return Surface.forDm7Squared(Math.round(dm7));
    }

    @Override
    public String toWkt() {
        return new WktPolygonConverter().convert(this);
    }

    public List<Polygon> triangles() {
        ConformingDelaunayTriangulationBuilder trianguler = new ConformingDelaunayTriangulationBuilder();
        trianguler.setSites(JTS_POLYGON_CONVERTER.convert(this));
        GeometryCollection triangleCollection = (GeometryCollection)trianguler.getTriangles(JtsPrecisionManager.getGeometryFactory());
        return Iterables.stream(GeometryStreamer.streamPolygons(triangleCollection)).map(JTS_POLYGON_CONVERTER.revert()).filter(polygon -> this.fullyGeometricallyEncloses(polygon.center())).collectToList();
    }

    public Polygon withoutVertex(int index) {
        if (index < 0 || index >= this.size()) {
            throw new CoreException("{} is not a vertex index of {}", index, this);
        }
        List<Location> vertices = Iterables.asList(this);
        vertices.remove(index);
        return new Polygon(vertices);
    }

    public Polygon withoutVertex(Location vertex) {
        int index = 0;
        for (Location location : this) {
            if (location.equals(vertex)) {
                return this.withoutVertex(index);
            }
            ++index;
        }
        throw new CoreException("{} is not a vertex of {}", vertex, this);
    }

    protected Area awtArea() {
        if (this.awtArea == null) {
            this.awtArea = new Area(this.awtPolygon());
        }
        return this.awtArea;
    }

    private boolean awtOverflows() {
        if (this.awtOverflows == null) {
            Rectangle bounds = this.bounds();
            this.awtOverflows = bounds.width().asDm7() <= 0L || bounds.height().asDm7() <= 0L;
        }
        return this.awtOverflows;
    }

    private java.awt.Polygon awtPolygon() {
        if (this.awtPolygon == null) {
            int size = this.size();
            int[] xArray = new int[size];
            int[] yArray = new int[size];
            int index = 0;
            for (Location location : this) {
                xArray[index] = (int)location.getLongitude().asDm7();
                yArray[index] = (int)location.getLatitude().asDm7();
                ++index;
            }
            this.awtPolygon = new java.awt.Polygon(xArray, yArray, size);
        }
        return this.awtPolygon;
    }

    private Iterable<Location> loopOnItself() {
        return new MultiIterable<Location>(this, () -> new Iterator<Location>(){
            private boolean read = false;

            @Override
            public boolean hasNext() {
                return !this.read;
            }

            @Override
            public Location next() {
                if (!this.read) {
                    this.read = true;
                    return Polygon.this.first();
                }
                return null;
            }
        });
    }

    private boolean overlapsInternal(PolyLine polyline, boolean runReverseCheck) {
        for (Location location : polyline) {
            if (!this.fullyGeometricallyEncloses(location)) continue;
            return true;
        }
        if (runReverseCheck && polyline instanceof Polygon && ((Polygon)polyline).overlapsInternal(this, false)) {
            return true;
        }
        return this.intersects(polyline);
    }

    private void verifyVertexIndex(int index) {
        if (index < 0 || index >= this.size()) {
            throw new CoreException("Invalid Vertex Index {}.", index);
        }
    }
}

