/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography;

import org.openstreetmap.atlas.utilities.scalars.Angle;

public class Longitude
extends Angle {
    private static final long serialVersionUID = 4222162088144937632L;
    public static final Longitude MINIMUM = Longitude.dm7(-1800000000L);
    public static final Longitude ZERO = Longitude.dm7(0L);
    public static final Longitude MAXIMUM = Longitude.dm7(1799999999L);
    public static final Longitude ANTIMERIDIAN_WEST = MINIMUM;
    public static final Longitude ANTIMERIDIAN_EAST = Longitude.dm7(1800000000L);
    private boolean isMaximumDm7 = false;

    public static Longitude degrees(double degrees) {
        return Longitude.dm7(Math.round(degrees * 1.0E7));
    }

    public static Longitude dm7(long dm7) {
        if (dm7 < -1800000000L || dm7 > 1800000000L) {
            throw new IllegalArgumentException("Cannot have a longitude of " + dm7 / 10000000L + " degrees which is outside of " + -180 + " degrees -> " + 180 + " degrees.");
        }
        return new Longitude((int)dm7);
    }

    public static Longitude radians(double radians) {
        return Longitude.dm7(Math.round(radians * 5.72957795E8));
    }

    public static Longitude radiansBounded(double radians) {
        long dm7 = Math.round(radians * 5.72957795E8);
        if (dm7 < -1800000000L) {
            dm7 = -1800000000L;
        }
        if (dm7 >= 1800000000L) {
            dm7 = 1799999999L;
        }
        return Longitude.dm7(dm7);
    }

    protected Longitude(int dm7) {
        super(dm7);
        if (dm7 == 1800000000) {
            this.isMaximumDm7 = true;
        }
    }

    @Override
    public long asDm7() {
        if (this.isMaximumDm7) {
            return 1800000000L;
        }
        return super.asDm7();
    }

    public boolean isCloserViaAntimeridianTo(Longitude that) {
        return Math.abs(this.asDm7() - that.asDm7()) > 1800000000L;
    }

    @Override
    public String toString() {
        return String.valueOf(this.asDegrees());
    }

    @Override
    protected int assertDm7(int dm7) {
        if (dm7 == 1800000000) {
            return -1800000000;
        }
        return super.assertDm7(dm7);
    }
}

