/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.atlas.geography.Latitude;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Longitude;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Rectangle;

public class CompressedPolyLine
implements Located,
Serializable {
    private static final long serialVersionUID = -7813027521625470225L;
    private static final int BYTE_FULL_MASK = 255;
    private static final int BYTE_SIZE = 8;
    private static final int INT_SIGN_MASK = Integer.MIN_VALUE;
    private static final int INT_NO_SIGN_MASK = Integer.MAX_VALUE;
    private final byte[][] positions;
    private final boolean[] signs;

    public CompressedPolyLine(byte[][] positions, boolean[] signs) {
        this.positions = positions;
        this.signs = signs;
    }

    public CompressedPolyLine(PolyLine polyLine) {
        int i;
        ArrayList<byte[]> positions = new ArrayList<byte[]>();
        ArrayList<Boolean> signs = new ArrayList<Boolean>();
        int formerLatitude = 0;
        int formerLongitude = 0;
        for (Location location : polyLine) {
            int latitude = (int)location.getLatitude().asDm7();
            int longitude = (int)location.getLongitude().asDm7();
            int deltaLatitude = latitude - formerLatitude;
            int deltaLongitude = longitude - formerLongitude;
            formerLatitude = latitude;
            formerLongitude = longitude;
            ByteSign latShrink = this.shrink(deltaLatitude);
            ByteSign lonShrink = this.shrink(deltaLongitude);
            positions.add(latShrink.getBytes());
            signs.add(latShrink.isSign());
            positions.add(lonShrink.getBytes());
            signs.add(lonShrink.isSign());
        }
        this.positions = new byte[positions.size()][];
        for (i = 0; i < positions.size(); ++i) {
            this.positions[i] = (byte[])positions.get(i);
        }
        this.signs = new boolean[signs.size()];
        for (i = 0; i < signs.size(); ++i) {
            this.signs[i] = (Boolean)signs.get(i);
        }
    }

    public PolyLine asPolyLine() {
        boolean lat = true;
        int latitude = 0;
        int longitude = 0;
        ArrayList<Location> locations = new ArrayList<Location>();
        for (int index = 0; index < this.positions.length; ++index) {
            byte[] result = this.positions[index];
            if (lat) {
                latitude += this.expand(result, index);
                lat = false;
                continue;
            }
            locations.add(new Location(Latitude.dm7(latitude), Longitude.dm7(longitude += this.expand(result, index))));
            lat = true;
        }
        return new PolyLine((List<? extends Location>)locations);
    }

    @Override
    public Rectangle bounds() {
        return this.asPolyLine().bounds();
    }

    public byte[][] getPositions() {
        return this.positions;
    }

    public boolean[] getSigns() {
        return this.signs;
    }

    public String toString() {
        return this.asPolyLine().toString();
    }

    private int expand(byte[] result, int index) {
        int placeholder = 0;
        for (int i = 0; i < result.length; ++i) {
            byte byteValue = result[i];
            placeholder |= byteValue & 0xFF;
            if (i >= result.length - 1) continue;
            placeholder <<= 8;
        }
        boolean negative = this.signs[index];
        if (negative) {
            placeholder |= Integer.MIN_VALUE;
        }
        return placeholder;
    }

    private ByteSign shrink(int value) {
        int placeholder = value & Integer.MAX_VALUE;
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        while (Math.abs(placeholder) > 0) {
            byte byteValue = (byte)placeholder;
            bytes.add(byteValue);
            placeholder >>>= 8;
        }
        int size = bytes.size();
        byte[] result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (Byte)bytes.get(size - 1 - i);
        }
        return new ByteSign(result, value < 0);
    }

    private static class ByteSign {
        private final byte[] bytes;
        private final boolean sign;

        ByteSign(byte[] bytes, boolean sign) {
            this.bytes = bytes;
            this.sign = sign;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public boolean isSign() {
            return this.sign;
        }
    }
}

