/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography;

import java.io.Serializable;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public final class Altitude
implements Serializable {
    private static final long serialVersionUID = -9064525655677062110L;
    public static final Altitude MEAN_SEA_LEVEL = Altitude.meters(0.0);
    private final Distance distance;
    private boolean isNegative = false;

    public static Altitude meters(double meters) {
        return new Altitude(meters);
    }

    private Altitude(double meters) {
        if (meters < 0.0) {
            if (-meters > Distance.AVERAGE_EARTH_RADIUS.asMeters()) {
                throw new CoreException("Cannot have an altitude below the center of the Earth.");
            }
            this.isNegative = true;
            this.distance = Distance.meters(-meters);
        } else {
            this.distance = Distance.meters(meters);
        }
    }

    public double asMeters() {
        return this.isNegative ? -this.distance.asMeters() : this.distance.asMeters();
    }

    public boolean equals(Object other) {
        if (other instanceof Altitude) {
            Altitude that = (Altitude)other;
            return this.asMeters() == that.asMeters();
        }
        return false;
    }

    public int hashCode() {
        return Double.hashCode(this.asMeters());
    }

    public String toString() {
        return String.valueOf(this.asMeters());
    }
}

