/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.tools.streaming.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.streaming.compression.Compressor;
import org.openstreetmap.atlas.streaming.compression.Decompressor;
import org.openstreetmap.atlas.streaming.resource.AbstractWritableResource;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.utilities.runtime.Retry;
import org.openstreetmap.atlas.utilities.scalars.Duration;

public class HDFSFile
extends AbstractWritableResource {
    private static final int DEFAULT_RETRIES = 3;
    private static final Duration DEFAULT_RETRYWAIT = Duration.seconds(2.0);
    private final Path path;
    private final FileSystem system;
    private boolean appendToFile = false;
    private int retries = 3;
    private Duration retryWait = DEFAULT_RETRYWAIT;

    public HDFSFile(Path path) throws IOException {
        this.path = path;
        this.system = FileSystem.get((URI)path.toUri(), (Configuration)new Configuration());
        FileSuffix.suffixFor(path.getName()).ifPresent(suffix -> {
            if (suffix == FileSuffix.GZIP) {
                this.setCompressor(Compressor.GZIP);
                this.setDecompressor(Decompressor.GZIP);
            }
        });
    }

    public HDFSFile(String path) throws IOException {
        this(new Path(path));
    }

    public HDFSFile(String server, int port, String path) throws URISyntaxException, IOException {
        this(new Path(String.format("hdfs://%s:%d/%s", server, port, path)));
    }

    public boolean exists() {
        try {
            return this.system.exists(this.path);
        }
        catch (IOException oops) {
            throw new CoreException("Could not check if path {} exists", this.path.toString(), oops);
        }
    }

    public Path getPath() {
        return this.path;
    }

    public int getRetries() {
        return this.retries;
    }

    public Duration getRetryWait() {
        return this.retryWait;
    }

    public boolean isAppendToFile() {
        return this.appendToFile;
    }

    public boolean isDirectory() {
        try {
            return this.system.isDirectory(this.path);
        }
        catch (IOException e) {
            throw new CoreException("Could not check if path {} is a directory", this.path.toString(), e);
        }
    }

    @Override
    public long length() {
        try {
            return this.system.getFileStatus(this.path).getLen();
        }
        catch (IOException e) {
            throw new CoreException("Could not check length of path {}", this.path.toString(), e);
        }
    }

    public void mkdirs(boolean clean) {
        new Retry(this.retries, this.retryWait).run(() -> {
            try {
                if (clean) {
                    this.system.delete(this.path, true);
                }
                this.system.mkdirs(this.path);
            }
            catch (IOException oops) {
                throw new CoreException("Could not create directories in HDFS for location {}", this.path, oops);
            }
        });
    }

    public void remove(boolean recursive) {
        new Retry(this.retries, this.retryWait).run(() -> {
            try {
                this.system.delete(this.path, recursive);
            }
            catch (IOException oops) {
                throw new CoreException("Could not delete path in HDFS location {}", this.path, oops);
            }
        });
    }

    public void setAppendToFile(boolean appendToFile) {
        this.appendToFile = appendToFile;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setRetryWait(Duration retryWait) {
        this.retryWait = retryWait;
    }

    @Override
    protected InputStream onRead() {
        return (InputStream)new Retry(this.retries, this.retryWait).run(() -> {
            try {
                return this.system.open(this.path);
            }
            catch (IOException ioe) {
                throw new CoreException("Could not read file.", ioe);
            }
        });
    }

    @Override
    protected OutputStream onWrite() {
        return (OutputStream)new Retry(this.retries, this.retryWait).run(() -> {
            try {
                if (this.system.exists(this.path)) {
                    if (this.appendToFile) {
                        return this.system.append(this.path);
                    }
                    this.system.delete(this.path, true);
                }
                return this.system.create(this.path);
            }
            catch (IOException ioe) {
                throw new CoreException("Could not write to file.", ioe);
            }
        });
    }
}

