/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.tools.spark.testing;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.openstreetmap.atlas.generator.tools.spark.SparkJob;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.scalars.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmptySparkJob
extends SparkJob {
    private static final long serialVersionUID = -687554634010359849L;
    private static final Logger logger = LoggerFactory.getLogger(EmptySparkJob.class);
    public static final Command.Switch<Integer> SIZE = new Command.Switch("size", "The size of the RDD", value -> Integer.parseInt(value), Command.Optionality.REQUIRED);
    public static final Command.Switch<Integer> LENGTH = new Command.Switch("lengthInSeconds", "The length in Seconds of each task.", value -> Integer.parseInt(value), Command.Optionality.REQUIRED);

    public static void main(String[] args) {
        new EmptySparkJob().run(args);
    }

    @Override
    public String getName() {
        return "EmptySparkJob";
    }

    @Override
    public void start(CommandMap command) {
        int size = (Integer)command.get(SIZE);
        int length = (Integer)command.get(LENGTH);
        String output = (String)command.get(OUTPUT);
        logger.info("Starting empty spark job with size {} and length {} seconds.", (Object)size, (Object)length);
        ArrayList<Integer> input = new ArrayList<Integer>();
        for (int value2 = 0; value2 < size; ++value2) {
            input.add(value2);
        }
        JavaRDD rdd = this.getContext().parallelize(input);
        JavaRDD result = rdd.map((Function & Serializable)value -> {
            for (int counter = 0; counter < length; ++counter) {
                Duration.ONE_SECOND.sleep();
                logger.info("RDD part {} slept {} times.", value, (Object)counter);
            }
            return true;
        });
        result.saveAsTextFile(output);
    }

    @Override
    protected Command.SwitchList switches() {
        return super.switches().with(SIZE, LENGTH);
    }
}

