/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.tools.filesystem;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.tools.filesystem.FileSystemCreator;
import org.openstreetmap.atlas.generator.tools.streaming.resource.HDFSWalker;
import org.openstreetmap.atlas.streaming.compression.Compressor;
import org.openstreetmap.atlas.streaming.compression.Decompressor;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.streaming.resource.InputStreamResource;
import org.openstreetmap.atlas.streaming.resource.OutputStreamWritableResource;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileSystemHelper {
    private static final Map<String, String> DEFAULT = Maps.hashMap("fs.file.impl", RawLocalFileSystem.class.getCanonicalName());
    private static final Logger logger = LoggerFactory.getLogger(FileSystemHelper.class);

    public static boolean delete(String path, boolean recursive, Map<String, String> configuration) {
        try {
            FileSystem fileSystem = new FileSystemCreator().get(path, configuration);
            return fileSystem.delete(new Path(path), recursive);
        }
        catch (Exception e) {
            throw new CoreException("Unable to delete {}", path, e);
        }
    }

    public static List<Resource> listResourcesRecursively(String directory, Map<String, String> configuration, PathFilter filter) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        FileSystem fileSystem = new FileSystemCreator().get(directory, configuration);
        FileSystemHelper.streamPathsRecursively(directory, configuration, filter).forEach(path -> {
            try {
                InputStreamResource resource = new InputStreamResource(() -> {
                    try {
                        return fileSystem.open(path);
                    }
                    catch (Exception e) {
                        throw new CoreException("Unable to open {}", path, e);
                    }
                }).withName(path.getName());
                if (path.getName().endsWith(FileSuffix.GZIP.toString())) {
                    resource.setDecompressor(Decompressor.GZIP);
                }
                resources.add(resource);
            }
            catch (Exception e) {
                throw new CoreException("Unable to read {}", path, e);
            }
        });
        return resources;
    }

    public static boolean mkdir(String path, Map<String, String> configuration) {
        try {
            FileSystem fileSystem = new FileSystemCreator().get(path, configuration);
            return fileSystem.mkdirs(new Path(path));
        }
        catch (Exception e) {
            throw new CoreException("Unable to mkdir {}", path, e);
        }
    }

    public static boolean rename(String sourcePath, String destinationPath, Map<String, String> configuration) {
        try {
            FileSystem fileSystem = new FileSystemCreator().get(sourcePath, configuration);
            return fileSystem.rename(new Path(sourcePath), new Path(destinationPath));
        }
        catch (Exception e) {
            throw new CoreException("Unable to rename {} to {}", sourcePath, destinationPath, e);
        }
    }

    public static Resource resource(String path) {
        return FileSystemHelper.resource(path, DEFAULT);
    }

    public static Resource resource(String path, Map<String, String> configuration) {
        FileSystem fileSystem = new FileSystemCreator().get(path, configuration);
        Path hadoopPath = new Path(path);
        try {
            InputStreamResource resource = new InputStreamResource(() -> {
                try {
                    return fileSystem.open(hadoopPath);
                }
                catch (Exception e) {
                    throw new CoreException("Unable to open {}", hadoopPath, e);
                }
            }).withName(hadoopPath.getName());
            if (hadoopPath.getName().endsWith(FileSuffix.GZIP.toString())) {
                resource.setDecompressor(Decompressor.GZIP);
            }
            return resource;
        }
        catch (Exception e) {
            throw new CoreException("Unable to read {}", hadoopPath, e);
        }
    }

    public static List<Resource> resources(String directory, Map<String, String> configuration) {
        return FileSystemHelper.resources(directory, configuration, path -> !path.getName().endsWith("_SUCCESS"));
    }

    public static List<Resource> resources(String directory, Map<String, String> configuration, PathFilter filter) {
        FileStatus[] fileStatusList;
        ArrayList<Resource> resources = new ArrayList<Resource>();
        FileSystem fileSystem = new FileSystemCreator().get(directory, configuration);
        try {
            fileStatusList = filter == null ? fileSystem.listStatus(new Path(directory)) : fileSystem.listStatus(new Path(directory), filter);
        }
        catch (Exception e) {
            throw new CoreException("Could not locate files on directory {}", directory, e);
        }
        for (FileStatus fileStatus : fileStatusList) {
            Path path = fileStatus.getPath();
            try {
                InputStreamResource resource = new InputStreamResource(() -> {
                    try {
                        return fileSystem.open(path);
                    }
                    catch (Exception e) {
                        throw new CoreException("Unable to open {}", path, e);
                    }
                }).withName(path.getName());
                if (path.getName().endsWith(FileSuffix.GZIP.toString())) {
                    resource.setDecompressor(Decompressor.GZIP);
                }
                resources.add(resource);
            }
            catch (Exception e) {
                throw new CoreException("Unable to read {}", path, e);
            }
        }
        return resources;
    }

    public static Stream<Path> streamPathsRecursively(String directory, Map<String, String> configuration, PathFilter filter) {
        FileSystem fileSystem = new FileSystemCreator().get(directory, configuration);
        return new HDFSWalker().usingConfiguration(fileSystem.getConf()).walk(new Path(directory)).map(HDFSWalker.debug(path -> logger.info("{}", path))).map(FileStatus::getPath).filter(path -> filter == null || filter.accept(path));
    }

    public static WritableResource writableResource(String path) {
        return FileSystemHelper.writableResource(path, DEFAULT);
    }

    public static WritableResource writableResource(String path, Map<String, String> configuration) {
        Path hadoopPath = new Path(path);
        try {
            FSDataOutputStream out;
            FileSystem fileSystem = new FileSystemCreator().get(path, configuration);
            try {
                out = fileSystem.create(hadoopPath);
            }
            catch (Exception e) {
                throw new CoreException("Unable to open {}", hadoopPath, e);
            }
            OutputStreamWritableResource resource = new OutputStreamWritableResource((OutputStream)out);
            resource.setName(hadoopPath.getName());
            if (resource.isGzipped()) {
                resource.setCompressor(Compressor.GZIP);
            }
            return resource;
        }
        catch (Exception e) {
            throw new CoreException("Unable to read {}", hadoopPath, e);
        }
    }

    private FileSystemHelper() {
    }
}

