/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.PbfContext;
import org.openstreetmap.atlas.generator.tools.filesystem.FileSystemCreator;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.SlippyTile;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.streaming.resource.InputStreamResource;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.StreamIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PbfLocator
implements Serializable {
    private static final long serialVersionUID = -5831212599367503519L;
    private static final Logger logger = LoggerFactory.getLogger(PbfLocator.class);
    public static final String DEFAULT_SCHEME = "zz-xx-yy" + FileSuffix.PBF.toString();
    private final PbfContext pbfContext;
    private final Function<SlippyTile, Optional<LocatedPbf>> pbfFetcher;

    public PbfLocator(PbfContext pbfContext, Map<String, String> spark) {
        this.pbfContext = pbfContext;
        FileSystem fileSystem = new FileSystemCreator().get(this.pbfContext.getPbfPath(), spark);
        this.pbfFetcher = (Function<SlippyTile, Optional> & Serializable)shard -> {
            Path pbfName = new Path(this.pbfContext.getPbfPath() + "/" + this.pbfContext.getScheme().compile((SlippyTile)shard));
            try {
                if (!fileSystem.exists(pbfName)) {
                    logger.warn("PBF Resource {} does not exist.", (Object)pbfName.toString());
                    return Optional.empty();
                }
            }
            catch (IOException e) {
                throw new CoreException("Cannot test if {} exists.", pbfName.toString());
            }
            LocatedPbf locatedPbf = new LocatedPbf(new InputStreamResource(() -> {
                try {
                    return fileSystem.open(pbfName);
                }
                catch (Exception e) {
                    throw new CoreException("Cannot translate {} to a PBF resource.", shard, e);
                }
            }).withName(pbfName.toString()), shard.bounds());
            return Optional.of(locatedPbf);
        };
    }

    public Iterable<LocatedPbf> pbfsCovering(MultiPolygon multiPolygon) {
        logger.trace("Seeking tiles for MultiPolygon {}", (Object)multiPolygon.toSimpleString());
        List<Polygon> inners = multiPolygon.inners();
        StreamIterable tileIterable = Iterables.stream(multiPolygon.outers()).flatMap(this::tilesCoveringPartially);
        Set tileSet = Iterables.asSet(tileIterable);
        logger.trace("Found tiles {} for MultiPolygon {}", tileSet, (Object)multiPolygon.toSimpleString());
        return Iterables.stream(tileSet).filter(tile -> !this.innerCovers((Shard)tile, inners)).map(shard -> (SlippyTile)shard).map(this.pbfFetcher).filter(Optional::isPresent).map(Optional::get).collect();
    }

    public Iterable<LocatedPbf> pbfsCovering(Polygon polygon) {
        logger.trace("Seeking tiles for Polygon {}", (Object)polygon.toSimpleString());
        return Iterables.stream(this.tilesCoveringPartially(polygon)).map(shard -> (SlippyTile)shard).map(this.pbfFetcher).filter(Optional::isPresent).map(Optional::get).collect();
    }

    private boolean innerCovers(Shard shard, List<Polygon> inners) {
        for (Polygon inner : inners) {
            if (!inner.fullyGeometricallyEncloses(shard.bounds())) continue;
            return true;
        }
        return false;
    }

    private Iterable<? extends Shard> tilesCoveringPartially(Polygon polygon) {
        return this.pbfContext.getSharding().shards(polygon);
    }

    public static class LocatedPbf
    implements Located,
    Serializable {
        private static final long serialVersionUID = 1033855164646532750L;
        private final Resource resource;
        private final Rectangle bounds;

        public LocatedPbf(Resource resource, Rectangle bounds) {
            this.resource = resource;
            this.bounds = bounds;
        }

        @Override
        public Rectangle bounds() {
            return this.bounds;
        }

        public Resource getResource() {
            return this.resource;
        }
    }
}

