/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.AtlasGenerationTask;
import org.openstreetmap.atlas.generator.AtlasGeneratorHelper;
import org.openstreetmap.atlas.generator.PbfContext;
import org.openstreetmap.atlas.generator.PbfLoader;
import org.openstreetmap.atlas.generator.PbfLocator;
import org.openstreetmap.atlas.generator.persistence.MultipleAtlasCountryStatisticsOutputFormat;
import org.openstreetmap.atlas.generator.persistence.MultipleAtlasOutputFormat;
import org.openstreetmap.atlas.generator.persistence.MultipleAtlasStatisticsOutputFormat;
import org.openstreetmap.atlas.generator.persistence.delta.RemovedMultipleAtlasDeltaOutputFormat;
import org.openstreetmap.atlas.generator.persistence.scheme.SlippyTilePersistenceScheme;
import org.openstreetmap.atlas.generator.sharding.AtlasSharding;
import org.openstreetmap.atlas.generator.tools.filesystem.FileSystemHelper;
import org.openstreetmap.atlas.generator.tools.spark.SparkJob;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.delta.AtlasDelta;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.statistics.AtlasStatistics;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMapArchiver;
import org.openstreetmap.atlas.geography.boundary.CountryShardListing;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.tags.filters.ConfiguredTaggableFilter;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.conversion.StringConverter;
import org.openstreetmap.atlas.utilities.maps.MultiMapWithSet;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.runtime.system.memory.Memory;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class AtlasGenerator
extends SparkJob {
    private static final long serialVersionUID = 5985696743749843135L;
    private static final Logger logger = LoggerFactory.getLogger(AtlasGenerator.class);
    public static final String ATLAS_FOLDER = "atlas";
    public static final String RAW_ATLAS_FOLDER = "rawAtlas";
    public static final String SLICED_RAW_ATLAS_FOLDER = "slicedRawAtlas";
    public static final String SHARD_STATISTICS_FOLDER = "shardStats";
    public static final String COUNTRY_STATISTICS_FOLDER = "countryStats";
    public static final String SHARD_DELTAS_FOLDER = "deltas";
    public static final String SHARD_DELTAS_ADDED_FOLDER = "deltasAdded";
    public static final String SHARD_DELTAS_CHANGED_FOLDER = "deltasChanged";
    public static final String SHARD_DELTAS_REMOVED_FOLDER = "deltasRemoved";
    private static final String SHARDING_DEFAULT = "slippy@10";
    public static final Command.Switch<StringList> COUNTRIES = new Command.Switch("countries", "Comma separated list of countries to be included in the final Atlas", value -> StringList.split(value, ","), Command.Optionality.REQUIRED);
    public static final Command.Switch<String> COUNTRY_SHAPES = new Command.Switch<String>("countryShapes", "Shape file containing the countries", StringConverter.IDENTITY, Command.Optionality.REQUIRED);
    public static final Command.Switch<String> PBF_PATH = new Command.Switch<String>("pbfs", "The path to PBFs", StringConverter.IDENTITY, Command.Optionality.REQUIRED);
    public static final Command.Switch<SlippyTilePersistenceScheme> PBF_SCHEME = new Command.Switch("pbfScheme", "The folder structure of the PBF", SlippyTilePersistenceScheme::new, Command.Optionality.OPTIONAL, PbfLocator.DEFAULT_SCHEME);
    public static final Command.Switch<String> PBF_SHARDING = new Command.Switch<String>("pbfSharding", "The sharding tree of the pbf files. If not specified, this will default to the general Atlas sharding.", StringConverter.IDENTITY, Command.Optionality.OPTIONAL);
    public static final Command.Switch<SlippyTilePersistenceScheme> ATLAS_SCHEME = new Command.Switch("atlasScheme", "The folder structure of the output Atlas. Example: \"zz/xx/yy/\" or \"\" (everything under the same folder)", SlippyTilePersistenceScheme::new, Command.Optionality.OPTIONAL, "");
    public static final Command.Switch<String> SHARDING_TYPE = new Command.Switch<String>("sharding", "The sharding definition.", StringConverter.IDENTITY, Command.Optionality.OPTIONAL, "slippy@10");
    public static final Command.Switch<String> PREVIOUS_OUTPUT_FOR_DELTA = new Command.Switch<String>("previousOutputForDelta", "The path of the output of the previous job that can be used for delta computation", StringConverter.IDENTITY, Command.Optionality.OPTIONAL, "");
    public static final Command.Switch<String> CODE_VERSION = new Command.Switch<String>("codeVersion", "The code version", StringConverter.IDENTITY, Command.Optionality.OPTIONAL, "unknown");
    public static final Command.Switch<String> DATA_VERSION = new Command.Switch<String>("dataVersion", "The data version", StringConverter.IDENTITY, Command.Optionality.OPTIONAL, "unknown");
    public static final Command.Switch<String> EDGE_CONFIGURATION = new Command.Switch<String>("edgeConfiguration", "The path to the configuration file that defines what OSM Way becomes an Edge", StringConverter.IDENTITY, Command.Optionality.OPTIONAL);
    public static final Command.Switch<String> WAY_SECTIONING_CONFIGURATION = new Command.Switch<String>("waySectioningConfiguration", "The path to the configuration file that defines where to section Ways to make Edges.", StringConverter.IDENTITY, Command.Optionality.OPTIONAL);
    public static final Command.Switch<String> PBF_WAY_CONFIGURATION = new Command.Switch<String>("osmPbfWayConfiguration", "The path to the configuration file that defines which PBF Ways becomes an Atlas Entity.", StringConverter.IDENTITY, Command.Optionality.OPTIONAL);
    public static final Command.Switch<String> PBF_NODE_CONFIGURATION = new Command.Switch<String>("osmPbfNodeConfiguration", "The path to the configuration file that defines which PBF Nodes becomes an Atlas Entity.", StringConverter.IDENTITY, Command.Optionality.OPTIONAL);
    public static final Command.Switch<String> PBF_RELATION_CONFIGURATION = new Command.Switch<String>("osmPbfRelationConfiguration", "The path to the configuration file that defines which PBF Relations becomes an Atlas Entity", StringConverter.IDENTITY, Command.Optionality.OPTIONAL);
    public static final Command.Switch<Boolean> USE_RAW_ATLAS = new Command.Switch("useRawAtlas", "Allow PBF to Atlas process to use Raw Atlas flow", Boolean::parseBoolean, Command.Optionality.OPTIONAL, "false");
    public static final Command.Switch<String> SHOULD_ALWAYS_SLICE_CONFIGURATION = new Command.Switch<String>("shouldAlwaysSliceConfiguration", "The path to the configuration file that defines which entities on which country slicing will always be attempted regardless of the number of countries it intersects according to the country boundary map's grid index.", StringConverter.IDENTITY, Command.Optionality.OPTIONAL);

    public static void main(String[] args) {
        new AtlasGenerator().run(args);
    }

    protected static List<AtlasGenerationTask> generateTasks(StringList countries, CountryBoundaryMap boundaryMap, Sharding sharding) {
        MultiMapWithSet<String, Shard> countryToShardMap = CountryShardListing.countryToShardList(countries, boundaryMap, sharding);
        ArrayList<AtlasGenerationTask> tasks = new ArrayList<AtlasGenerationTask>();
        countryToShardMap.keySet().forEach(country -> {
            Object shards = countryToShardMap.get(country);
            if (!shards.isEmpty()) {
                shards.forEach(arg_0 -> AtlasGenerator.lambda$null$1(tasks, country, (Set)shards, arg_0));
            } else {
                logger.warn("No shards were found for {}. Skipping task generation.", country);
            }
        });
        return tasks;
    }

    private static Map<String, String> extractAtlasLoadingProperties(CommandMap command, Map<String, String> sparkContext) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put(CODE_VERSION.getName(), (String)command.get(CODE_VERSION));
        propertyMap.put(DATA_VERSION.getName(), (String)command.get(DATA_VERSION));
        String edgeConfiguration = (String)command.get(EDGE_CONFIGURATION);
        propertyMap.put(EDGE_CONFIGURATION.getName(), edgeConfiguration == null ? null : FileSystemHelper.resource(edgeConfiguration, sparkContext).all());
        String waySectioningConfiguration = (String)command.get(WAY_SECTIONING_CONFIGURATION);
        propertyMap.put(WAY_SECTIONING_CONFIGURATION.getName(), waySectioningConfiguration == null ? null : FileSystemHelper.resource(waySectioningConfiguration, sparkContext).all());
        String pbfNodeConfiguration = (String)command.get(PBF_NODE_CONFIGURATION);
        propertyMap.put(PBF_NODE_CONFIGURATION.getName(), pbfNodeConfiguration == null ? null : FileSystemHelper.resource(pbfNodeConfiguration, sparkContext).all());
        String pbfWayConfiguration = (String)command.get(PBF_WAY_CONFIGURATION);
        propertyMap.put(PBF_WAY_CONFIGURATION.getName(), pbfWayConfiguration == null ? null : FileSystemHelper.resource(pbfWayConfiguration, sparkContext).all());
        String pbfRelationConfiguration = (String)command.get(PBF_RELATION_CONFIGURATION);
        propertyMap.put(PBF_RELATION_CONFIGURATION.getName(), pbfRelationConfiguration == null ? null : FileSystemHelper.resource(pbfRelationConfiguration, sparkContext).all());
        return propertyMap;
    }

    @Override
    public String getName() {
        return "Atlas Generator";
    }

    @Override
    public void start(CommandMap command) {
        Map<String, String> sparkContext = this.configurationMap();
        StringList countries = (StringList)command.get(COUNTRIES);
        String countryShapes = (String)command.get(COUNTRY_SHAPES);
        String previousOutputForDelta = (String)command.get(PREVIOUS_OUTPUT_FOR_DELTA);
        String pbfPath = (String)command.get(PBF_PATH);
        SlippyTilePersistenceScheme pbfScheme = (SlippyTilePersistenceScheme)command.get(PBF_SCHEME);
        SlippyTilePersistenceScheme atlasScheme = (SlippyTilePersistenceScheme)command.get(ATLAS_SCHEME);
        String pbfShardingName = (String)command.get(PBF_SHARDING);
        String shardingName = (String)command.get(SHARDING_TYPE);
        Sharding sharding = AtlasSharding.forString(shardingName, this.configuration());
        Sharding pbfSharding = pbfShardingName != null ? AtlasSharding.forString(pbfShardingName, this.configuration()) : sharding;
        PbfContext pbfContext = new PbfContext(pbfPath, pbfSharding, pbfScheme);
        String codeVersion = (String)command.get(CODE_VERSION);
        String dataVersion = (String)command.get(DATA_VERSION);
        boolean useRawAtlas = (Boolean)command.get(USE_RAW_ATLAS);
        String shouldAlwaysSliceConfiguration = (String)command.get(SHOULD_ALWAYS_SLICE_CONFIGURATION);
        ConfiguredTaggableFilter shouldAlwaysSlicePredicate = shouldAlwaysSliceConfiguration == null ? taggable -> false : AtlasGeneratorHelper.getTaggableFilterFrom(FileSystemHelper.resource(shouldAlwaysSliceConfiguration, sparkContext));
        String output = this.output(command);
        Resource countryBoundaries = this.resource(countryShapes);
        logger.info("Reading country boundaries from {}", (Object)countryShapes);
        CountryBoundaryMap boundaries = new CountryBoundaryMapArchiver().read(countryBoundaries);
        logger.info("Done Reading {} country boundaries from {}", (Object)boundaries.size(), (Object)countryShapes);
        if (!boundaries.hasGridIndex()) {
            logger.warn("Given country boundary file didn't have grid index. Initializing grid index for {}.", (Object)countries);
            boundaries.initializeGridIndex(countries.stream().collect(Collectors.toSet()));
        }
        boundaries.setShouldAlwaysSlicePredicate(shouldAlwaysSlicePredicate);
        Time timer = Time.now();
        List<AtlasGenerationTask> tasks = AtlasGenerator.generateTasks(countries, boundaries, sharding);
        logger.debug("Generated {} tasks in {}.", (Object)tasks.size(), (Object)timer.elapsedSince());
        Map<String, String> atlasLoadingOptions = AtlasGenerator.extractAtlasLoadingProperties(command, sparkContext);
        if (useRawAtlas) {
            JavaPairRDD countryRawAtlasShardsRDD = this.getContext().parallelize(tasks, tasks.size()).mapToPair(AtlasGeneratorHelper.generateRawAtlas(boundaries, sparkContext, atlasLoadingOptions, pbfContext, atlasScheme)).filter((Function & Serializable)tuple -> tuple._2() != null);
            countryRawAtlasShardsRDD.cache();
            countryRawAtlasShardsRDD.saveAsHadoopFile(this.getAlternateSubFolderOutput(output, RAW_ATLAS_FOLDER), Text.class, Atlas.class, MultipleAtlasOutputFormat.class, new JobConf(this.configuration()));
            logger.info("\n\n********** SAVED THE RAW ATLAS **********\n");
            JavaPairRDD countrySlicedRawAtlasShardsRDD = countryRawAtlasShardsRDD.mapToPair(AtlasGeneratorHelper.sliceRawAtlas(boundaries)).filter((Function & Serializable)tuple -> tuple._2() != null);
            String slicedRawAtlasPath = this.getAlternateSubFolderOutput(output, SLICED_RAW_ATLAS_FOLDER);
            countrySlicedRawAtlasShardsRDD.cache();
            countrySlicedRawAtlasShardsRDD.saveAsHadoopFile(slicedRawAtlasPath, Text.class, Atlas.class, MultipleAtlasOutputFormat.class, new JobConf(this.configuration()));
            logger.info("\n\n********** SAVED THE SLICED RAW ATLAS **********\n");
            countryRawAtlasShardsRDD.unpersist();
            JavaPairRDD countryAtlasShardsRDD = countrySlicedRawAtlasShardsRDD.mapToPair(AtlasGeneratorHelper.sectionRawAtlas(boundaries, sharding, sparkContext, atlasLoadingOptions, slicedRawAtlasPath, tasks));
            countryAtlasShardsRDD.cache();
            countryAtlasShardsRDD.saveAsHadoopFile(this.getAlternateSubFolderOutput(output, ATLAS_FOLDER), Text.class, Atlas.class, MultipleAtlasOutputFormat.class, new JobConf(this.configuration()));
            logger.info("\n\n********** SAVED THE FINAL ATLAS **********\n");
            countrySlicedRawAtlasShardsRDD.unpersist();
            JavaPairRDD statisticsRDD = countryAtlasShardsRDD.mapToPair(AtlasGeneratorHelper.generateAtlasStatistics(sharding));
            statisticsRDD.cache();
            statisticsRDD.saveAsHadoopFile(this.getAlternateSubFolderOutput(output, SHARD_STATISTICS_FOLDER), Text.class, AtlasStatistics.class, MultipleAtlasStatisticsOutputFormat.class, new JobConf(this.configuration()));
            logger.info("\n\n********** SAVED THE SHARD STATISTICS **********\n");
            JavaPairRDD reducedStatisticsRDD = statisticsRDD.mapToPair((PairFunction & Serializable)tuple -> {
                String countryShardName = (String)tuple._1();
                String countryName = StringList.split(countryShardName, "_").get(0);
                return new Tuple2((Object)countryName, tuple._2());
            }).reduceByKey((Function2 & Serializable)(xva$0, xva$1) -> AtlasStatistics.merge(xva$0, xva$1));
            reducedStatisticsRDD.saveAsHadoopFile(this.getAlternateSubFolderOutput(output, COUNTRY_STATISTICS_FOLDER), Text.class, AtlasStatistics.class, MultipleAtlasCountryStatisticsOutputFormat.class, new JobConf(this.configuration()));
            logger.info("\n\n********** SAVED THE COUNTRY STATISTICS **********\n");
            if (!previousOutputForDelta.isEmpty()) {
                JavaPairRDD deltasRDD = countryAtlasShardsRDD.flatMapToPair(AtlasGeneratorHelper.computeAtlasDelta(sparkContext, previousOutputForDelta));
                deltasRDD.saveAsHadoopFile(this.getAlternateSubFolderOutput(output, SHARD_DELTAS_FOLDER), Text.class, AtlasDelta.class, RemovedMultipleAtlasDeltaOutputFormat.class, new JobConf(this.configuration()));
                logger.info("\n\n********** SAVED THE DELTAS **********\n");
            }
        } else {
            JavaPairRDD countryAtlasShardsRDD = this.getContext().parallelize(tasks, tasks.size()).mapToPair((PairFunction & Serializable)task -> {
                Atlas atlas;
                String countryName = task.getCountry();
                Shard shard = task.getShard();
                AtlasLoadingOption atlasLoadingOption = AtlasGeneratorHelper.buildAtlasLoadingOption(boundaries, sparkContext, atlasLoadingOptions).setAdditionalCountryCodes(countryName);
                PbfLoader loader = new PbfLoader(pbfContext, sparkContext, boundaries, atlasLoadingOption, codeVersion, dataVersion, task.getAllShards());
                String name = countryName + "_" + shard.getName();
                logger.info("Starting building Atlas {}", (Object)name);
                Time start = Time.now();
                try {
                    atlas = loader.load(countryName, shard);
                }
                catch (Throwable e) {
                    throw new CoreException("Building Atlas {} failed!", name, e);
                }
                logger.info("Finished building Atlas {} in {}", (Object)name, (Object)start.elapsedSince());
                logger.info("Printing memory after loading Atlas {}", (Object)name);
                Memory.printCurrentMemory();
                Tuple2 result = new Tuple2((Object)(name + "_" + atlasScheme.getScheme()), (Object)atlas);
                return result;
            });
            JavaPairRDD countryNonNullAtlasShardsRDD = countryAtlasShardsRDD.filter((Function & Serializable)tuple -> tuple._2() != null);
            countryNonNullAtlasShardsRDD.cache();
            logger.info("\n\n********** CACHED THE ATLAS **********\n");
            JavaPairRDD statisticsRDD = countryNonNullAtlasShardsRDD.mapToPair(AtlasGeneratorHelper.generateAtlasStatistics(sharding));
            statisticsRDD.cache();
            logger.info("\n\n********** CACHED THE SHARD STATISTICS **********\n");
            statisticsRDD.saveAsHadoopFile(this.getAlternateSubFolderOutput(output, SHARD_STATISTICS_FOLDER), Text.class, AtlasStatistics.class, MultipleAtlasStatisticsOutputFormat.class, new JobConf(this.configuration()));
            logger.info("\n\n********** SAVED THE SHARD STATISTICS **********\n");
            JavaPairRDD reducedStatisticsRDD = statisticsRDD.mapToPair((PairFunction & Serializable)tuple -> {
                String countryShardName = (String)tuple._1();
                String countryName = StringList.split(countryShardName, "_").get(0);
                return new Tuple2((Object)countryName, tuple._2());
            }).reduceByKey((Function2 & Serializable)(xva$0, xva$1) -> AtlasStatistics.merge(xva$0, xva$1));
            reducedStatisticsRDD.saveAsHadoopFile(this.getAlternateSubFolderOutput(output, COUNTRY_STATISTICS_FOLDER), Text.class, AtlasStatistics.class, MultipleAtlasCountryStatisticsOutputFormat.class, new JobConf(this.configuration()));
            logger.info("\n\n********** SAVED THE COUNTRY STATISTICS **********\n");
            if (!previousOutputForDelta.isEmpty()) {
                JavaPairRDD deltasRDD = countryNonNullAtlasShardsRDD.flatMapToPair(AtlasGeneratorHelper.computeAtlasDelta(sparkContext, previousOutputForDelta));
                deltasRDD.saveAsHadoopFile(this.getAlternateSubFolderOutput(output, SHARD_DELTAS_REMOVED_FOLDER), Text.class, AtlasDelta.class, RemovedMultipleAtlasDeltaOutputFormat.class, new JobConf(this.configuration()));
                logger.info("\n\n********** SAVED THE DELTAS REMOVED **********\n");
            }
            countryNonNullAtlasShardsRDD.saveAsHadoopFile(this.getAlternateSubFolderOutput(output, ATLAS_FOLDER), Text.class, Atlas.class, MultipleAtlasOutputFormat.class, new JobConf(this.configuration()));
            logger.info("\n\n********** SAVED THE ATLAS **********\n");
        }
    }

    @Override
    protected List<String> outputToClean(CommandMap command) {
        String output = this.output(command);
        List<String> staticPaths = super.outputToClean(command);
        staticPaths.add(this.getAlternateSubFolderOutput(output, COUNTRY_STATISTICS_FOLDER));
        staticPaths.add(this.getAlternateSubFolderOutput(output, SHARD_STATISTICS_FOLDER));
        staticPaths.add(this.getAlternateSubFolderOutput(output, SHARD_DELTAS_FOLDER));
        staticPaths.add(this.getAlternateSubFolderOutput(output, SHARD_DELTAS_ADDED_FOLDER));
        staticPaths.add(this.getAlternateSubFolderOutput(output, SHARD_DELTAS_CHANGED_FOLDER));
        staticPaths.add(this.getAlternateSubFolderOutput(output, SHARD_DELTAS_REMOVED_FOLDER));
        staticPaths.add(this.getAlternateSubFolderOutput(output, ATLAS_FOLDER));
        return staticPaths;
    }

    @Override
    protected Command.SwitchList switches() {
        return super.switches().with(COUNTRIES, COUNTRY_SHAPES, SHARDING_TYPE, PBF_PATH, PBF_SCHEME, PBF_SHARDING, PREVIOUS_OUTPUT_FOR_DELTA, CODE_VERSION, DATA_VERSION, EDGE_CONFIGURATION, WAY_SECTIONING_CONFIGURATION, PBF_NODE_CONFIGURATION, PBF_WAY_CONFIGURATION, PBF_RELATION_CONFIGURATION, ATLAS_SCHEME, USE_RAW_ATLAS, SHOULD_ALWAYS_SLICE_CONFIGURATION);
    }

    private static /* synthetic */ void lambda$null$1(List tasks, String country, Set shards, Shard shard) {
        tasks.add(new AtlasGenerationTask(country, shard, shards));
    }

    private static class CountrySplitter
    implements Serializable,
    java.util.function.Function<String, String> {
        private static final long serialVersionUID = 6984474253285033371L;

        private CountrySplitter() {
        }

        @Override
        public String apply(String key) {
            return StringList.split(key, "_").get(0);
        }
    }
}

