/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.event;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openstreetmap.atlas.checks.event.Event;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.geojson.GeoJsonBuilder;
import org.openstreetmap.atlas.tags.HighwayTag;

public final class CheckFlagEvent
extends Event {
    private static final GeoJsonBuilder GEOJSON_BUILDER = new GeoJsonBuilder();
    private final String checkName;
    private final CheckFlag flag;

    public static JsonObject flagToFeature(CheckFlag flag, Map<String, String> additionalProperties) {
        JsonObject flagProperties = new JsonObject();
        flagProperties.addProperty("instructions", flag.getInstructions());
        additionalProperties.forEach(flagProperties::addProperty);
        List<GeoJsonBuilder.LocationIterableProperties> geometries = flag.getLocationIterableProperties();
        JsonObject feature = geometries.size() == 1 ? GEOJSON_BUILDER.create(geometries.get(0)) : GEOJSON_BUILDER.createGeometryCollection(geometries).jsonObject();
        JsonArray featureProperties = new JsonArray();
        HashSet featureOsmIds = new HashSet();
        geometries.stream().forEach(geometry -> Optional.ofNullable(geometry.getProperties()).ifPresent(propertyMap -> {
            JsonObject properties = new JsonObject();
            propertyMap.forEach(properties::addProperty);
            featureProperties.add(properties);
            Optional.ofNullable(properties.get("osmid")).ifPresent(featureOsmIds::add);
        }));
        JsonArray uniqueFeatureOsmIds = new JsonArray();
        featureOsmIds.forEach(uniqueFeatureOsmIds::add);
        CheckFlagEvent.featureDecorator(featureProperties).ifPresent(decorator -> flagProperties.addProperty("name", String.format("%s (%s)", Optional.ofNullable(flagProperties.getAsJsonPrimitive("name")).map(JsonPrimitive::getAsString).orElse("Task"), decorator)));
        flagProperties.add("feature_properties", featureProperties);
        flagProperties.add("feature_osmids", uniqueFeatureOsmIds);
        flagProperties.addProperty("feature_count", geometries.size());
        feature.addProperty("id", flag.getIdentifier());
        feature.add("properties", flagProperties);
        return feature;
    }

    public static JsonObject flagToJson(CheckFlag flag, Map<String, String> additionalProperties) {
        JsonObject flagJson = GEOJSON_BUILDER.create(flag.getLocationIterableProperties()).jsonObject();
        JsonObject flagPropertiesJson = new JsonObject();
        flagPropertiesJson.addProperty("id", flag.getIdentifier());
        flagPropertiesJson.addProperty("instructions", flag.getInstructions());
        additionalProperties.forEach(flagPropertiesJson::addProperty);
        flagJson.add("properties", flagPropertiesJson);
        return flagJson;
    }

    private static Optional<String> featureDecorator(JsonArray featureProperties) {
        HighwayTag highestHighwayTag = null;
        for (JsonElement featureProperty : featureProperties) {
            HighwayTag baslineHighwayTag = highestHighwayTag == null ? HighwayTag.NO : highestHighwayTag;
            highestHighwayTag = Optional.ofNullable(((JsonObject)featureProperty).getAsJsonPrimitive("highway")).map(JsonPrimitive::getAsString).map(String::toUpperCase).map(HighwayTag::valueOf).filter(baslineHighwayTag::isLessImportantThan).orElse(highestHighwayTag);
        }
        return Optional.ofNullable(highestHighwayTag).map(tag -> String.format("%s=%s", "highway", tag.getTagValue()));
    }

    public CheckFlagEvent(String checkName, CheckFlag flag) {
        this.checkName = checkName;
        this.flag = flag;
    }

    public CheckFlag getCheckFlag() {
        return this.flag;
    }

    public String getCheckName() {
        return this.checkName;
    }

    public JsonObject toGeoJsonFeature() {
        HashMap<String, String> contextualProperties = new HashMap<String, String>();
        contextualProperties.put("name", this.getCheckFlag().getChallengeName().orElse(this.getCheckName()));
        contextualProperties.put("generator", "AtlasChecks");
        contextualProperties.put("timestamp", this.getTimestamp().toString());
        return CheckFlagEvent.flagToFeature(this.getCheckFlag(), contextualProperties);
    }

    public JsonObject toGeoJsonFeatureCollection() {
        HashMap<String, String> contextualProperties = new HashMap<String, String>();
        contextualProperties.put("generator", this.getCheckName());
        contextualProperties.put("timestamp", this.getTimestamp().toString());
        return CheckFlagEvent.flagToJson(this.getCheckFlag(), contextualProperties);
    }

    public String toString() {
        return this.toGeoJsonFeatureCollection().toString();
    }
}

