/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElement;
import io.github.lukehutch.fastclasspathscanner.scanner.RelativePath;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.InterruptionChecker;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.NestedJarHandler;
import io.github.lukehutch.fastclasspathscanner.utils.SingletonMap;
import io.github.lukehutch.fastclasspathscanner.utils.WorkQueue;

class RelativePathToElementMap
extends SingletonMap<RelativePath, ClasspathElement>
implements AutoCloseable {
    private final boolean scanFiles;
    private final ScanSpec scanSpec;
    private final NestedJarHandler nestedJarHandler;
    private final InterruptionChecker interruptionChecker;
    private final LogNode log;
    private WorkQueue<RelativePath> workQueue;

    RelativePathToElementMap(boolean scanFiles, ScanSpec scanSpec, NestedJarHandler nestedJarHandler, InterruptionChecker interruptionChecker, LogNode log) {
        this.scanFiles = scanFiles;
        this.scanSpec = scanSpec;
        this.nestedJarHandler = nestedJarHandler;
        this.interruptionChecker = interruptionChecker;
        this.log = log;
    }

    public void setWorkQueue(WorkQueue<RelativePath> workQueue) {
        this.workQueue = workQueue;
    }

    @Override
    public ClasspathElement newInstance(RelativePath classpathElt) {
        return ClasspathElement.newInstance(classpathElt, this.scanFiles, this.scanSpec, this.nestedJarHandler, this.workQueue, this.interruptionChecker, this.log);
    }

    @Override
    public void close() throws Exception {
        for (ClasspathElement classpathElt : this.values()) {
            classpathElt.close();
        }
    }
}

