/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.atlas.predicates.TagPredicates;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.tags.AerowayTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.RouteTag;
import org.openstreetmap.atlas.tags.SyntheticBoundaryNodeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class SinkIslandCheck
extends BaseCheck<Long> {
    public static final float LOAD_FACTOR = 0.8f;
    public static final long TREE_SIZE_DEFAULT = 50L;
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Road is impossible to get out of.");
    private static final long serialVersionUID = -1432150496331502258L;
    private final int storeSize;
    private final int treeSize;

    public SinkIslandCheck(Configuration configuration) {
        super(configuration);
        this.treeSize = this.configurationValue(configuration, "tree.size", 50L, Math::toIntExact);
        this.storeSize = (int)((float)this.treeSize / 0.8f);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return this.validEdge(object) && !this.isFlagged(object.getIdentifier());
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        boolean emptyFlag = false;
        Edge candidate = (Edge)object;
        HashSet<AtlasObject> explored = new HashSet<AtlasObject>(this.storeSize, 0.8f);
        HashSet<Edge> terminal = new HashSet<Edge>();
        ArrayDeque candidates = new ArrayDeque(this.storeSize);
        explored.add((AtlasObject)candidate);
        while (candidate != null) {
            if (this.isFlagged(candidate.getIdentifier())) {
                emptyFlag = true;
                break;
            }
            Set outEdges = candidate.outEdges().stream().filter(this::validEdge).collect(Collectors.toSet());
            if (outEdges.isEmpty()) {
                terminal.add(candidate);
            } else {
                explored.add((AtlasObject)candidate);
                outEdges.stream().filter(outEdge -> !explored.contains(outEdge)).forEach(candidates::add);
                if (candidates.size() + explored.size() > this.treeSize) {
                    emptyFlag = true;
                    break;
                }
            }
            candidate = (Edge)candidates.poll();
        }
        if (!emptyFlag) {
            explored.addAll(terminal);
        }
        explored.forEach(marked -> this.markAsFlagged(marked.getIdentifier()));
        return emptyFlag ? Optional.empty() : Optional.of(this.createFlag(explored, this.getLocalizedInstruction(0, new Object[0])));
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean validEdge(AtlasObject object) {
        return object instanceof Edge && !Validators.isOfType((Taggable)object, AerowayTag.class, (Enum[])new AerowayTag[]{AerowayTag.TAXIWAY, AerowayTag.RUNWAY}) && !SyntheticBoundaryNodeTag.isBoundaryNode((Taggable)((Edge)object).end()) && !SyntheticBoundaryNodeTag.isBoundaryNode((Taggable)((Edge)object).start()) && HighwayTag.isCarNavigableHighway((Taggable)object) && !RouteTag.isFerry((Taggable)object) && !TagPredicates.IS_AREA.test(object);
    }
}

