/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.directory.api.util.Strings;
import org.openstreetmap.atlas.checks.atlas.predicates.TypePredicates;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.Heading;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Angle;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class SignPostCheck
extends BaseCheck<String> {
    private static final long serialVersionUID = 8042255121118115024L;
    private static final String NODE_INSTRUCTION = "Junction node {0,number,#} is missing the following tags: {1}.";
    private static final String EDGE_INSTRUCTION = "Way {0,number,#} ({1}) is missing the following tags: {2}.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Junction node {0,number,#} is missing the following tags: {1}.", "Way {0,number,#} ({1}) is missing the following tags: {2}.");
    private static final String OFF_RAMP_KEY = "off-ramp";
    private static final String ON_RAMP_KEY = "on-ramp";
    private static final double DISTANCE_MINIMUM_METERS_DEFAULT = 50.0;
    private static final String SOURCE_EDGE_FILTER_DEFAULT = "highway->motorway,trunk";
    private static final String RAMP_FILTER_DEFAULT = "highway->motorway,motorway_link,trunk,trunk_link";
    private static final double RAMP_ANGLE_DIFFERENCE_DEFAULT = 30.0;
    private static final int MAX_EDGE_COUNT_FOR_RAMP = 5;
    private final Distance minimumLinkLength;
    private final TaggableFilter sourceEdgeFilter;
    private final TaggableFilter rampEdgeFilter;
    private final String rampDifferentiatorTag;
    private final Angle rampAngleDifference;

    public SignPostCheck(Configuration configuration) {
        super(configuration);
        this.minimumLinkLength = this.configurationValue(configuration, "linkLength.minimum.meters", 50.0, Distance::meters);
        this.sourceEdgeFilter = this.configurationValue(configuration, "source.filter", SOURCE_EDGE_FILTER_DEFAULT, value -> new TaggableFilter(value));
        this.rampEdgeFilter = this.configurationValue(configuration, "ramp.filter", RAMP_FILTER_DEFAULT, value -> new TaggableFilter(value));
        this.rampDifferentiatorTag = this.configurationValue(configuration, "ramp.differentiator.tag", null);
        this.rampAngleDifference = this.configurationValue(configuration, "ramp.angle.difference.degrees", 30.0, Angle::degrees);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return TypePredicates.IS_EDGE.test(object) && this.sourceEdgeFilter.test((Taggable)object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Edge edge = (Edge)object;
        HighwayTag highwayTag = edge.highwayTag();
        CheckFlag flag = new CheckFlag(this.getTaskIdentifier(object));
        edge.end().outEdges().stream().filter(connectedEdge -> this.isPossiblyRamp(edge, highwayTag, (Edge)connectedEdge)).forEach(outEdge -> {
            Node start = outEdge.start();
            if (!Validators.isOfType((Taggable)start, HighwayTag.class, (Enum[])new HighwayTag[]{HighwayTag.MOTORWAY_JUNCTION})) {
                flag.addInstruction(this.getLocalizedInstruction(0, start.getOsmIdentifier(), String.format("%s=%s", "highway", HighwayTag.MOTORWAY_JUNCTION.getTagValue())));
                flag.addObject((AtlasObject)start);
            }
            if (!outEdge.getTag("destination").isPresent()) {
                flag.addInstruction(this.getLocalizedInstruction(1, outEdge.getOsmIdentifier(), OFF_RAMP_KEY, "destination"));
                flag.addObject((AtlasObject)outEdge);
            }
        });
        edge.start().inEdges().stream().filter(connectedEdge -> this.isPossiblyRamp(edge, highwayTag, (Edge)connectedEdge)).forEach(inEdge -> {
            Edge rampEdge = this.findFirstRampEdge((Edge)inEdge);
            Node start = rampEdge.start();
            if (!Validators.isOfType((Taggable)start, HighwayTag.class, (Enum[])new HighwayTag[]{HighwayTag.MOTORWAY_JUNCTION})) {
                flag.addInstruction(this.getLocalizedInstruction(0, start.getOsmIdentifier(), String.format("%s=%s", "highway", HighwayTag.MOTORWAY_JUNCTION.getTagValue())));
                flag.addObject((AtlasObject)start);
            }
            if (!rampEdge.getTag("destination").isPresent()) {
                flag.addInstruction(this.getLocalizedInstruction(1, rampEdge.getOsmIdentifier(), ON_RAMP_KEY, "destination"));
                flag.addObject((AtlasObject)rampEdge);
            }
        });
        if (!flag.getFlaggedObjects().isEmpty()) {
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private Edge findFirstRampEdge(Edge finalEdge) {
        Edge nextEdge = finalEdge;
        for (int count = 0; count < 5; ++count) {
            Optional finalHeading;
            Edge precedingEdge;
            HighwayTag highwayTag;
            Set inEdges;
            Optional initialHeading = nextEdge.asPolyLine().initialHeading();
            if (!initialHeading.isPresent() || (inEdges = nextEdge.inEdges()).isEmpty() || inEdges.size() > 1 || !(highwayTag = nextEdge.highwayTag()).isIdenticalClassification((precedingEdge = (Edge)inEdges.iterator().next()).highwayTag()) || !(finalHeading = precedingEdge.asPolyLine().finalHeading()).isPresent() || ((Heading)initialHeading.get()).asPositiveAngle().difference(((Heading)finalHeading.get()).asPositiveAngle()).isGreaterThan(this.rampAngleDifference)) break;
            nextEdge = precedingEdge;
        }
        return nextEdge;
    }

    private boolean isPossiblyRamp(Edge sourceEdge, HighwayTag sourceHighwayTag, Edge connectedEdge) {
        if (!this.rampEdgeFilter.test((Taggable)connectedEdge) || !connectedEdge.length().isGreaterThan(this.minimumLinkLength)) {
            return false;
        }
        if (!sourceHighwayTag.isIdenticalClassification(connectedEdge.highwayTag())) {
            return true;
        }
        if (this.rampDifferentiatorTag == null) {
            return true;
        }
        String sourceTag = sourceEdge.tag(this.rampDifferentiatorTag);
        String rampTag = connectedEdge.tag(this.rampDifferentiatorTag);
        return (sourceTag != null || rampTag != null) && !Strings.equals((String)sourceTag, (String)rampTag);
    }
}

