/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.intersections;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.tags.BuildingTag;
import org.openstreetmap.atlas.tags.CoveredTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.LayerTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.TunnelTag;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class BuildingRoadIntersectionCheck
extends BaseCheck<Long> {
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Building (id-{0,number,#}) intersects road (id-{1,number,#})");
    private static final long serialVersionUID = 5986017212661374165L;

    private static Predicate<Edge> ignoreTags() {
        return edge -> !Validators.isOfType((Taggable)edge, CoveredTag.class, (Enum[])new CoveredTag[]{CoveredTag.YES}) && !Validators.isOfType((Taggable)edge, TunnelTag.class, (Enum[])new TunnelTag[]{TunnelTag.BUILDING_PASSAGE});
    }

    private static Predicate<Edge> intersectsCoreWayInvalidly(Area building) {
        return edge -> HighwayTag.isCoreWay((Taggable)edge) && edge.asPolyLine().intersects((PolyLine)building.asPolygon()) && LayerTag.getTaggedValue((Taggable)edge).orElse(0L).equals(LayerTag.getTaggedValue((Taggable)building).orElse(0L)) && !BuildingRoadIntersectionCheck.isValidIntersection(building, edge);
    }

    private static boolean isValidIntersection(Area building, Edge edge) {
        Node edgeStart = edge.start();
        Node edgeEnd = edge.end();
        Set intersections = building.asPolygon().intersections(edge.asPolyLine());
        if (intersections.size() == 1 && !building.asPolygon().fullyGeometricallyEncloses(edge.asPolyLine())) {
            if (intersections.contains(edgeStart.getLocation()) && edge.inEdges().stream().anyMatch(BuildingRoadIntersectionCheck.ignoreTags().negate())) {
                return true;
            }
            if (intersections.contains(edgeEnd.getLocation()) && edge.outEdges().stream().anyMatch(BuildingRoadIntersectionCheck.ignoreTags().negate())) {
                return true;
            }
        }
        return false;
    }

    public BuildingRoadIntersectionCheck(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Area && BuildingTag.isBuilding((Taggable)object) && !HighwayTag.isHighwayArea((Taggable)object) && !Validators.isOfType((Taggable)object, BuildingTag.class, (Enum[])new BuildingTag[]{BuildingTag.ROOF});
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Area building = (Area)object;
        Iterable intersectingEdges = Iterables.filter((Iterable)building.getAtlas().edgesIntersecting((Polygon)building.bounds(), BuildingRoadIntersectionCheck.intersectsCoreWayInvalidly(building)), BuildingRoadIntersectionCheck.ignoreTags());
        CheckFlag flag = new CheckFlag(this.getTaskIdentifier((AtlasObject)building));
        flag.addObject((AtlasObject)building);
        this.handleIntersections(intersectingEdges, flag, building);
        if (flag.getPolyLines().size() > 1) {
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private void handleIntersections(Iterable<Edge> intersectingEdges, CheckFlag flag, Area building) {
        HashSet<Object> knownIntersections = new HashSet<Object>();
        for (Edge edge : intersectingEdges) {
            if (knownIntersections.contains(edge)) continue;
            flag.addObject((AtlasObject)edge, this.getLocalizedInstruction(0, building.getOsmIdentifier(), edge.getOsmIdentifier()));
            knownIntersections.add(edge);
            if (!edge.hasReverseEdge()) continue;
            knownIntersections.add(edge.reversed().get());
        }
    }
}

