/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.event;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import org.openstreetmap.atlas.checks.event.FileProcessor;
import org.openstreetmap.atlas.checks.event.MetricEvent;
import org.openstreetmap.atlas.checks.event.ShutdownEvent;
import org.openstreetmap.atlas.generator.tools.spark.utilities.SparkFileHelper;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetricFileGenerator
extends FileProcessor<MetricEvent> {
    private static final Logger logger = LoggerFactory.getLogger(MetricFileGenerator.class);
    private final String label;
    private final FileSuffix suffix;

    public MetricFileGenerator(String label, SparkFileHelper fileHelper, String outputFolder) {
        super(fileHelper, outputFolder);
        Optional<FileSuffix> knownSuffix = Arrays.stream(FileSuffix.values()).filter(suffix -> label.endsWith(suffix.toString())).findFirst();
        if (knownSuffix.isPresent()) {
            this.label = label.substring(0, label.lastIndexOf(String.valueOf(knownSuffix.get())));
            this.suffix = knownSuffix.get();
        } else {
            this.label = label;
            this.suffix = FileSuffix.CSV;
        }
        this.process(MetricEvent.header());
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void process(MetricEvent event) {
        this.process(event.toString());
    }

    @Override
    @Subscribe
    public void process(ShutdownEvent event) {
        try {
            this.write();
        }
        catch (Exception e) {
            logger.warn("Metric file write is failed.", (Throwable)e);
        }
    }

    @Override
    protected String getFilename() {
        return String.format("%s-%s%s", this.label, new Date().getTime(), this.suffix);
    }
}

