/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm.testsuite;

import purejavacomm.UnsupportedCommOperationException;
import purejavacomm.testsuite.TestBase;

public class Test8
extends TestBase {
    private static final int[] LIMITED_PARITY = new int[]{0, 1, 2};
    private static final int[] LIMITED_STOPBITS = new int[]{1};
    private static final int[] LIMITED_DATABITS = new int[]{8};
    private static final int[] LIMITED_DATAMASK = new int[]{255};
    private static final int[] FULL_PARITY = new int[]{0, 1, 2, 3, 4};
    private static final int[] FULL_STOPBITS = new int[]{1, 3, 2};
    private static final int[] FULL_DATABITS = new int[]{8, 7, 6, 5};
    private static final int[] FULL_DATAMASK = new int[]{255, 127, 63, 31};

    static void run() throws Exception {
        Test8.run(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void run(boolean allModes) throws Exception {
        try {
            int[] datamask;
            int[] databits;
            int[] stopbits;
            int[] parity;
            Test8.begin("Test8 - parity etc");
            Test8.openPort();
            if (allModes) {
                parity = FULL_PARITY;
                stopbits = FULL_STOPBITS;
                databits = FULL_DATABITS;
                datamask = FULL_DATAMASK;
            } else {
                parity = LIMITED_PARITY;
                stopbits = LIMITED_STOPBITS;
                databits = LIMITED_DATABITS;
                datamask = LIMITED_DATAMASK;
            }
            System.out.println();
            int tn = 0;
            for (int ppi = 0; ppi < parity.length; ++ppi) {
                for (int sbi = 0; sbi < stopbits.length; ++sbi) {
                    for (int dbi = 0; dbi < databits.length; ++dbi) {
                        m_Port.enableReceiveTimeout(10000);
                        m_Port.enableReceiveThreshold(256);
                        try {
                            String db = "?";
                            switch (databits[dbi]) {
                                case 5: {
                                    db = "5";
                                    break;
                                }
                                case 6: {
                                    db = "6";
                                    break;
                                }
                                case 7: {
                                    db = "7";
                                    break;
                                }
                                case 8: {
                                    db = "8";
                                }
                            }
                            String sb = "?";
                            switch (stopbits[sbi]) {
                                case 1: {
                                    sb = "1";
                                    break;
                                }
                                case 3: {
                                    sb = "1.5";
                                    break;
                                }
                                case 2: {
                                    sb = "2";
                                }
                            }
                            String pb = "?";
                            switch (parity[ppi]) {
                                case 2: {
                                    pb = "E";
                                    break;
                                }
                                case 1: {
                                    pb = "O";
                                    break;
                                }
                                case 3: {
                                    pb = "M";
                                    break;
                                }
                                case 4: {
                                    pb = "S";
                                    break;
                                }
                                case 0: {
                                    pb = "N";
                                }
                            }
                            Test8.begin("Test8." + ++tn + " databits=" + db + " stopbits=" + sb + " parity=" + pb);
                            m_Port.setSerialPortParams(19200, databits[dbi], stopbits[sbi], parity[ppi]);
                            Test8.sleep(100);
                            byte[] sent = new byte[256];
                            byte[] rcvd = new byte[256];
                            for (int i = 0; i < 256; ++i) {
                                sent[i] = (byte)i;
                            }
                            m_Out = m_Port.getOutputStream();
                            m_In = m_Port.getInputStream();
                            long t0 = System.currentTimeMillis();
                            m_Out.write(sent);
                            int n = 0;
                            while ((n += m_In.read(rcvd, n, 256 - n)) < 256) {
                            }
                            if (n != sent.length) {
                                Test8.fail("was expecting %d characters got %d", sent.length, n);
                            }
                            for (int i = 0; i < 256; ++i) {
                                int tx;
                                if (i <= datamask[dbi]) {
                                    if (rcvd[i] == sent[i]) continue;
                                    Test8.fail("failed: transmit '0x%02X' != receive'0x%02X'", sent[i], rcvd[i]);
                                    continue;
                                }
                                if (databits[dbi] < 7 || rcvd[i] == (tx = sent[i] & datamask[dbi])) continue;
                                Test8.fail("failed: transmit (excessive) '0x%02X' != receive'0x%02X'%n", tx, rcvd[i]);
                            }
                            if (n < 256) {
                                Test8.fail("did not receive all 256 chars, got %d", n);
                            }
                            Test8.finishedOK();
                            continue;
                        }
                        catch (UnsupportedCommOperationException e) {
                            Test8.finishedOK(" NOT SUPPORTED " + e.getMessage(), new Object[0]);
                        }
                    }
                }
            }
        }
        finally {
            Test8.closePort();
        }
    }
}

