/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm.testsuite;

import purejavacomm.testsuite.TestBase;

public class Test7
extends TestBase {
    private static Exception m_Exception = null;
    private static Thread m_Receiver;
    private static Thread m_Transmitter;
    private static volatile long m_T0;

    static void run() throws Exception {
        try {
            Test7.begin("Test7 - threshold");
            Test7.openPort();
            m_Receiver = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        TestBase.sync(2);
                        TestBase.m_Port.enableReceiveThreshold(7);
                        TestBase.m_Port.disableReceiveTimeout();
                        byte[] b = new byte[8];
                        int n = TestBase.m_In.read(b);
                        long dT = System.currentTimeMillis() - m_T0;
                        if (n != 7) {
                            TestBase.fail("read did not get 7 bytes as expected, got %d", n);
                        }
                        if (dT < 10000L) {
                            TestBase.fail("timed out in %d though we got 7 bytes", dT);
                        }
                    }
                    catch (InterruptedException b) {
                    }
                    catch (Exception e) {
                        if (m_Exception == null) {
                            m_Exception = e;
                        }
                        m_Receiver.interrupt();
                        m_Transmitter.interrupt();
                    }
                }
            });
            m_Transmitter = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        TestBase.sync(2);
                        m_T0 = System.currentTimeMillis();
                        TestBase.sleep(10000);
                        TestBase.m_Out.write(new byte[7]);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (m_Exception == null) {
                            m_Exception = e;
                        }
                        m_Receiver.interrupt();
                        m_Transmitter.interrupt();
                    }
                }
            });
            m_Receiver.start();
            m_Transmitter.start();
            while (m_Receiver.isAlive() || m_Transmitter.isAlive()) {
                Test7.sleep(100);
            }
            if (m_Exception != null) {
                throw m_Exception;
            }
            Test7.finishedOK();
        }
        finally {
            Test7.closePort();
        }
    }
}

